VehicleFruitHudGuiBoxSetGet = {};

function VehicleFruitHudGuiBoxSetGet:loadIcons(guiBox) 
	if guiBox.overlays == nil then guiBox.overlays = {byName={}};end;
	local firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="vf_hud.otherIcons", modDir=VehicleFruitHud.modDir, iconFile="hlHudSystem/icons/otherIcons.dds", xmlFile="icons_vfhud/icons.xml", modName="defaultIcons", groupName="guiBox", fileFormat={32,256,512}, iconTable=guiBox.overlays} );
	firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="vf_hud.icons", modDir=VehicleFruitHud.modDir, iconFile="hlHudSystem/icons/icons.dds", xmlFile="icons_vfhud/icons.xml", modName="defaultIcons", groupName="guiBox", fileFormat={64,512,1024}, iconTable=guiBox.overlays} );
end;

function VehicleFruitHudGuiBoxSetGet.getLines(args)	
	local guiBox = args.guiBox;
	if guiBox == nil then return;end;	
	local line = args.line or 1;
	local overlayDefaultGroup = guiBox.overlays["defaultIcons"]["guiBox"];
	local overlayDefaultByName = guiBox.overlays.byName["defaultIcons"]["guiBox"];
	local values = guiBox.ownTable;
	local textL = "";
	local textR = "-";
	local textColor = "white";
	local textOffColor = g_currentMission.hlHudSystem.overlays.color.notActive;
	local iconColor = g_currentMission.hlHudSystem.overlays.color.notActive;	
	local onColor = g_currentMission.hlHudSystem.overlays.color.on;
	local languageColorTxt = g_i18n:getText("configuration_valueColor");
	local helpText = "";
	local helpText2 = "";	
	local stateOn = g_i18n:getText("ui_on");
	local stateOff = g_i18n:getText("ui_off");
	local state = false;
	local stateColor = nil;	
	local moreTxt = "";
	local infoTxt = "";
	
	local isFillLevelExtras = values.view.fillLevelExtras[1] > 1;
	---filllevel hud---
	if guiBox.guiLines[line] == "fillLevelHudHeadline_" then	
		textL = g_i18n:getText("info_fillLevel").. "-Hud (".. g_i18n:getText("ui_vehicles").. ")";
		helpText = g_i18n:getText("setting_radioVehicleOnly");
		return {typ="headline", helpText=helpText, text={[1]={text=textL, color="ls25"}} };
	end;
	if guiBox.guiLines[line] == "clickPrice_" then	
		textL = g_i18n:getText("info_fillLevel").. "-Click"; --g_i18n:getText("shop_configurationPriceTotal").. "-Click";	
		helpText = "4x ".. g_i18n:getText("ui_sellingPoints")
		if values.view.clickPrice[1] > 1 then state=true;iconColor = onColor;else stateColor = textOffColor;end;		
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}}, ownTable={"clickPrice"} };
	end;
	if guiBox.guiLines[line] == "sellingStationDistance_" then
		textL = g_i18n:getText("ui_distance").. "-".. g_i18n:getText("ui_sellingPoints");
		if values.view.clickPrice[1] > 1 then 
			if values.view.sellingStationDistance[1] > 1 then state=true;iconColor = onColor;else stateColor = textOffColor;end;
			return {oneClick=true, typ="boolean", text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}}, ownTable={"sellingStationDistance"} };
		else
			stateColor = textOffColor;
			return {oneClick=true, typ="boolean", text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}}, ownTable={} };
		end;		
	end;
	if guiBox.guiLines[line] == "fillLevelExtras_" then	
		textL = g_i18n:getText("modHub_extraContent"); --"Show Extras";
		helpText = g_i18n:getText("introduction_tourVehicleSelection");
		if isFillLevelExtras then iconColor = onColor;else stateColor = textOffColor;end;
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=isFillLevelExtras}}, ownTable={"fillLevelExtras"} };
	end;
	if guiBox.guiLines[line] == "capacity_" then	
		textL = g_i18n:getText("ui_silos_totalCapacity");		
		if isFillLevelExtras and values.view.capacity[1] > 1 then state=true;iconColor = onColor;else stateColor = textOffColor;end;
		return {oneClick=true, typ="boolean", text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}}, ownTable={"capacity"} };
	end;
	if guiBox.guiLines[line] == "bestPrice_" then	
		textL = g_i18n:getText("ui_buyPrices");	--"shop_configurationPriceTotal"	
		helpText = g_i18n:getText("setting_radioAlways").. " - ".. stateOn.. " = ".. g_i18n:getText("performance_attention").. "\n".. g_i18n:getText("input_MENU_ACTIVATE").. " --> ".. string.format(g_i18n:getText("action_unfoldOBJECT"), g_i18n:getText("ui_buyPrices"));
		if isFillLevelExtras and values.view.bestPrice[1] > 1 then state=true;iconColor = onColor;else stateColor = textOffColor;end;
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}}, ownTable={"bestPrice"} };
	end;
	if guiBox.guiLines[line] == "priceTrend_" then	
		textL = g_i18n:getText("button_showFluctuations");		
		if isFillLevelExtras and values.view.bestPrice[1] > 1 and values.view.priceTrend[1] > 1 then state=true;iconColor = onColor;else stateColor = textOffColor;end;
		return {oneClick=true, typ="boolean", text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}}, ownTable={"priceTrend"} };
	end;
	if guiBox.guiLines[line] == "priceFolder_" then	
		textL = string.format(g_i18n:getText("action_unfoldOBJECT"), g_i18n:getText("ui_buyPrices"));		
		helpText = g_i18n:getText("performance_good");
		if isFillLevelExtras and values.view.bestPrice[1] > 1 and values.view.priceFolder[1] > 1 then state=true;iconColor = onColor;else stateColor = textOffColor;end;
		return {oneClick=true, typ="boolean", helpText=helpText, text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=state}}, ownTable={"priceFolder"} };
	end;
	if guiBox.guiLines[line] == "maxFillLevel_" then	
		textL = g_i18n:getText("ui_max").. g_i18n:getText("info_fillLevel");		
		helpText = g_i18n:getText("ui_buyPrices").. " (".. g_i18n:getText("ui_max").. " >= ".. g_i18n:getText("info_fillLevel").. ") ".. g_i18n:getText("configuration_valueDefault").. " ".. tostring(values.view.maxFillLevel[5]).. " ".. g_i18n:getText("unit_liter");
		if isFillLevelExtras and values.view.bestPrice[1] > 1 then state=true;iconColor = onColor;else stateColor = textOffColor;end;		
		if state then
			return {typ="number", helpText=helpText, text={[1]={text=textL}, [2]={text=tostring(values.view.maxFillLevel[1])}} };
		else
			return {oneClick=true, typ="string", text={[1]={text=textL,color=stateColor}}, ownTable={} };
		end;
	end;
	---filllevel hud---	
	---horse hud---	
	if guiBox.guiLines[line] == "horseHudHeadline_" then	
		textL = g_i18n:getText("construction_tab_horses").. "-Hud";
		return {typ="headline", text={[1]={text=textL, color="ls25"}} };
	end;
	if guiBox.guiLines[line] == "horseHud_" then	
		textL = g_i18n:getText("modHub_extraContent"); --"Show Horse Hud";
		if values.view.horseHud[1] > 1 then iconColor = onColor;else stateColor = textOffColor;end;
		return {oneClick=true, typ="boolean", text={[1]={text=textL,color=stateColor}, [2]={color=stateColor,state=values.view.horseHud[1] > 1}}, ownTable={"horseHud"} };
	end;
	---horse hud---	
end;