vfSetGet = {};

function vfSetGet:loadFillLevelDisplay(firstStart)
	if VehicleFruitHud.values.fillLevelBox == nil then VehicleFruitHud.values.fillLevelBox = {};end;
	if VehicleFruitHud.values.guiMenu.ownTable.view.fillLevelExtras[1] > 1 then
		local pixelH = g_currentMission.hlHudSystem.screen.pixelH*1;
		local textHeight = getTextHeight(g_currentMission.hud.fillLevelsDisplay.fillLevelTextSize , utf8Substr("Äg", 0));
		local h = textHeight+pixelH+g_currentMission.hud.fillLevelsDisplay.bgScale.height;		
		VehicleFruitHud.values.fillLevelBox.defaultHeight = g_currentMission.hud.fillLevelsDisplay.bgLeft;
		
		vfSetGet:refreshFillLevelDisplayHeight(g_currentMission.hud.fillLevelsDisplay, h);		
			
		VehicleFruitHud.values.fillLevelBox.textHeight = textHeight;
		VehicleFruitHud.values.fillLevelBox.difHeight = pixelH;
		VehicleFruitHud.values.fillLevelBox.difWidth = g_currentMission.hlHudSystem.screen.pixelW*1;
		VehicleFruitHud.values.fillLevelBox.priceColor = g_currentMission.hlUtils.getColor("khaki", true);		
	end;
	if firstStart then 
		VehicleFruitHud_Draw:drawFillLevelsDisplay();
		local iconWidth, iconHeight = g_currentMission.hlUtils.getOptiIconWidthHeight(getTextHeight(g_currentMission.hud.fillLevelsDisplay.fillLevelTextSize , utf8Substr("Äg", 0)), g_currentMission.hlHudSystem.screen.pixelW, g_currentMission.hlHudSystem.screen.pixelH);	
		local guiBox = VehicleFruitHud.values.guiMenu;
		local overlayDefaultGroup = guiBox.overlays["defaultIcons"]["guiBox"];
		local overlayDefaultByName = guiBox.overlays.byName["defaultIcons"]["guiBox"];
		local overlay = overlayDefaultGroup[overlayDefaultByName["priceTrendNormal"]];
		g_currentMission.hlUtils.setOverlay(overlay, nil, nil, iconWidth/1.2, iconHeight/1.2);
		overlay = overlayDefaultGroup[overlayDefaultByName["priceTrendGreatDemand"]];
		g_currentMission.hlUtils.setOverlay(overlay, nil, nil, iconWidth/1.2, iconHeight/1.2);
		overlay = overlayDefaultGroup[overlayDefaultByName["priceTrendUp"]];
		g_currentMission.hlUtils.setOverlay(overlay, nil, nil, iconWidth/1.2, iconHeight/1.2);
		overlay = overlayDefaultGroup[overlayDefaultByName["priceTrendDown"]];
		g_currentMission.hlUtils.setOverlay(overlay, nil, nil, iconWidth/1.2, iconHeight/1.2);
		overlay = overlayDefaultGroup[overlayDefaultByName["left"]];
		g_currentMission.hlUtils.setOverlay(overlay, nil, nil, g_currentMission.hud.fillLevelsDisplay.iconWidth/1.2, g_currentMission.hud.fillLevelsDisplay.iconHeight/1.2);
		overlay = overlayDefaultGroup[overlayDefaultByName["right"]];
		g_currentMission.hlUtils.setOverlay(overlay, nil, nil, g_currentMission.hud.fillLevelsDisplay.iconWidth/1.2, g_currentMission.hud.fillLevelsDisplay.iconHeight/1.2);
		overlay = overlayDefaultGroup[overlayDefaultByName["selling"]];
		g_currentMission.hlUtils.setOverlay(overlay, nil, nil, iconWidth, iconHeight);
		overlay = overlayDefaultGroup[overlayDefaultByName["buying"]];
		g_currentMission.hlUtils.setOverlay(overlay, nil, nil, iconWidth, iconHeight);
	end;
end;

function vfSetGet:unLoadFillLevelDisplay()	
	local isRefresh = vfSetGet:refreshEnhancedVehicle(false);
	vfSetGet:refreshFillLevelDisplayHeight(g_currentMission.hud.fillLevelsDisplay);	
	g_currentMission.hud.fillLevelsDisplay:storeScaledValues(g_currentMission.hud.fillLevelsDisplay);	
	if isRefresh ~= nil and isRefresh then vfSetGet:refreshEnhancedVehicle(true);end;	
end;

function vfSetGet:refreshFillLevelDisplayHeight(fillLevelsDisplay, height)
	local h = height or VehicleFruitHud.values.fillLevelBox.defaultHeight;	
	g_currentMission.hlUtils.setOverlay(fillLevelsDisplay.bgLeft, nil, nil, nil, h);
	g_currentMission.hlUtils.setOverlay(fillLevelsDisplay.bgScale, nil, nil, nil, h);
	g_currentMission.hlUtils.setOverlay(fillLevelsDisplay.bgRight, nil, nil, nil, h);	
end;

function vfSetGet:refreshEnhancedVehicle(state)
	if g_modIsLoaded["FS25_EnhancedVehicle"] and _G["FS25_EnhancedVehicle"] ~= nil then
		local enhancedVehicleHud = _G["FS25_EnhancedVehicle"].FS25_EnhancedVehicle.ui_hud;
		local enhancedVehicle = _G["FS25_EnhancedVehicle"].FS25_EnhancedVehicle;
		if enhancedVehicleHud ~= nil and enhancedVehicle ~= nil then 
			if not state then
				if enhancedVehicle.functionSnapIsEnabled then 
					enhancedVehicle.functionSnapIsEnabled = false;
					enhancedVehicleHud:storeScaledValues(enhancedVehicleHud);
					return true;
				end;
				return false;
			else
				enhancedVehicle.functionSnapIsEnabled = true;
				enhancedVehicleHud:storeScaledValues(enhancedVehicleHud);
			end;
		end;
	end;
	return nil;
end;

function vfSetGet:generateHorseHud()
	if VehicleFruitHud.values.horseHud ~= nil then return;end;	
	if g_currentMission.hud ~= nil and g_currentMission.hud.infoDisplay ~= nil then
		VehicleFruitHud.values.horseHud = g_currentMission.hud.infoDisplay:createBox(InfoDisplayKeyValueBox);
		VehicleFruitHud.values.horseHud.cluster = AnimalClusterHorse.new();
		VehicleFruitHud.values.horseHud.cluster.infoAge = {text="",title=g_i18n:getText("infohud_age")};
		VehicleFruitHud.values.horseHud.cluster.infoTyp = {text="",title=g_i18n:getText("infohud_type")};
		VehicleFruitHud.values.horseHud.cluster.infoSpeed = {text="",title=g_i18n:getText("ui_hudSpeedGaugeSpeed")};
		VehicleFruitHud.values.horseHud.cluster.infoSellPrice = {text="",title=g_i18n:getText("ui_sellPrices")};
		VehicleFruitHud.values.horseHud:setTitle(tostring(VehicleFruitHud.metadata.title));		
	end;
end;

function vfSetGet:clearBox(box)
	for _, line in ipairs(box.lines) do
		line.isActive = false
	end
	box.currentLineIndex = 0
end;

function vfSetGet:setBoxTitle(box, title)		
	local text = utf8ToUpper(title)
	if text ~= box.title then
		box.title = Utils.limitTextToWidth(text, box.titleTextSize, box.titleMaxWidth, false, ".");
	end;	
end;

function vfSetGet:addBoxLine(box, key, value, otherColor, isWarning)
	box.currentLineIndex = box.currentLineIndex + 1
	local line = box.lines[box.currentLineIndex]
	if line == nil then
		line = {
			["key"] = "",
			["value"] = "",
			["otherColor"] = {1,1,1,1},
			["isWarning"] = false
		}
		table.addElement(box.lines, line)
	end
	line.key = key;
	line.value = value or "";
	line.otherColor = otherColor;
	line.isWarning = isWarning;
	line.isActive = true
end;

function vfSetGet:getBoxDisplayHeight(box)
	return 2 * box.listMarginHeight + #box.activeLines * box.rowHeight + box.labelTextSize + box.labelTextOffsetY;
end;

function vfSetGet:getSupportsReproduction(vehicle)
	local subType = g_currentMission.animalSystem:getSubTypeByIndex(vehicle.cluster.subTypeIndex);
	return subType.supportsReproduction;
end;

function vfSetGet:getCanReproduce(vehicle, healthFactor)
	local subType = g_currentMission.animalSystem:getSubTypeByIndex(vehicle.cluster.subTypeIndex);
	if subType.supportsReproduction then		
		return subType.reproductionMinHealth <= healthFactor and subType.reproductionMinAgeMonth <= vehicle.cluster.age;
	end;
	return false;
end;

function vfSetGet:getSpeed(vehicle)
	local speed = Utils.getNoNil(vehicle.lastSpeed, 0)*3600;
	if g_gameSettings:getValue('useMiles') then speed = speed*0.621371;end;
	return string.format("%1.0f", "".. Utils.getNoNil(speed, 0));
end;

function vfSetGet:getSellPrice(vehicle, healthFactor, fitnessFactor)
	local subType = g_currentMission.animalSystem:getSubTypeByIndex(vehicle.cluster.subTypeIndex);
	local sellPrice = subType.sellPrice:get(vehicle.cluster.age);
	return sellPrice * (0.3 + 0.5 * healthFactor + 0.2 * fitnessFactor);
end;

function vfSetGet:getSellingStations()
	local sellingStations = {};
	for _, station in pairs(g_currentMission.storageSystem:getUnloadingStations()) do
		if station:isa(SellingStation) and not station.hideFromPricesMenu then --bug not view prices !
		--if station.isSellingPoint and (station.hideFromPricesMenu == nil or not station.hideFromPricesMenu) then
			station.uiName = station:getName();			
			table.insert(sellingStations, station);			
		end;
	end;	
	return sellingStations;
end;

function vfSetGet:getNameMissingXmlText(text, name)	
	if text == nil or text:len() == 0 then return "Unknown Station";end; --string.format(g_i18n:getText("missing_txt"), name or "Object");end;
	if string.find(text:lower(), "missing") or string.find(text:lower(), ".xml") then return "Unknown Station";end; --string.format(g_i18n:getText("missing_txt"), name or "Object");end;
	return text;
end;

function vfSetGet:getFillTypeExtra(fillType, unloadTriggers)
	local eScale = nil;
	local ePrice = nil;
	local eTyp = {[1]=false,[2]=false,[3]=false,[4]=false,[5]=false};	
	local tempScalePrice = {[1]={0,0},[2]={0,0},[3]={0,0},[4]={0,0},[5]={0,0}}; --later check this
	local scaleTyp = 1;
	local multipleTyp = 0;
	if unloadTriggers ~= nil and #unloadTriggers > 0 then 
		function getExtraAttributes(trigger, typ)
			if trigger.extraAttributes ~= nil then
				eScale = trigger.extraAttributes.priceScale;
				ePrice = trigger.extraAttributes.price;
			end;
		end;
		local desc = g_fillTypeManager:getFillTypeByIndex(fillType);
		if desc ~= nil then
			local defaultType = false;
			local bulkType = desc.isBulkType or false; --2
			local palType = desc.isPalletType or false; --3
			local baleType = desc.isBaleType or false; --4
			local woodType = false; --5
			if not bulkType and not palType and not baleType and not woodType then defaultType = true;end;
			for u=1, #unloadTriggers do
				if bulkType then if not eTyp[2] then multipleTyp = multipleTyp+1;end;eTyp[2] = true;end;
				if palType and unloadTriggers[u].palletsInRange ~= nil then	if not eTyp[3] then multipleTyp = multipleTyp+1;end;eTyp[3] = true;end;
				if baleType and unloadTriggers[u].balesInTrigger ~= nil then if not eTyp[4] then multipleTyp = multipleTyp+1;end;eTyp[4] = true;end;
				if woodType and unloadTriggers[u].woodInTrigger ~= nil then if not eTyp[5] then multipleTyp = multipleTyp+1;end;eTyp[5] = true;end;
				if not eTyp[2] and not eTyp[3] and not eTyp[4] and not eTyp[5] then if not eTyp[1] then multipleTyp = multipleTyp+1;end;eTyp[1] = true;end;
				----
				function setExtraAttributes(forceTyp)
					local foundScaleTyp = false;
					if bulkType or forceTyp then
						getExtraAttributes(unloadTriggers[u], 2);
						if eScale ~= nil or ePrice ~= nil then scaleTyp = 2;foundScaleTyp = true;end;						
					elseif palType and unloadTriggers[u].palletsInRange ~= nil then
						getExtraAttributes(unloadTriggers[u], 3);
						scaleTyp = 3;					
					elseif baleType and unloadTriggers[u].balesInTrigger ~= nil then
						getExtraAttributes(unloadTriggers[u], 4);
						scaleTyp = 4;
					elseif woodType and unloadTriggers[u].woodInTrigger ~= nil then
						getExtraAttributes(unloadTriggers[u], 5);
						scaleTyp = 5;
					else
						getExtraAttributes(unloadTriggers[u], 1);
						scaleTyp = 1;
					end;
					if not foundScaleTyp then
						getExtraAttributes(unloadTriggers[u], 1);
						scaleTyp = 1;
					end;
				end;				
				----
				if multipleTyp <=1 then
					setExtraAttributes(false);
				else
					local foundScaleTyp = false;
					local scaleTypByPlayer = VehicleFruitHud.values.guiMenu.ownTable.view.sellingStationScaleTyp[1];
					if scaleTypByPlayer == 3 then
						if baleType and unloadTriggers[u].balesInTrigger ~= nil then getExtraAttributes(unloadTriggers[u], 4);if eScale ~= nil or ePrice ~= nil then scaleTyp = 4;foundScaleTyp = true;end;end;
					end;
					if scaleTypByPlayer == 2 then
						if palType and unloadTriggers[u].palletsInRange ~= nil then getExtraAttributes(unloadTriggers[u], 3);if eScale ~= nil or ePrice ~= nil then scaleTyp = 3;foundScaleTyp = true;end;end;
					end;
					if scaleTypByPlayer == 1 then
						if bulkType then getExtraAttributes(unloadTriggers[u], 2);if eScale ~= nil or ePrice ~= nil then scaleTyp = 2;foundScaleTyp = true;end;end;
						if not foundScaleTyp then getExtraAttributes(unloadTriggers[u], 1);if eScale ~= nil or ePrice ~= nil then scaleTyp = 1;foundScaleTyp = true;end;end;
					end;
					if not foundScaleTyp then setExtraAttributes(true);end;
				end;
			end;
		end;
	end;	
	return eScale, ePrice, scaleTyp, eTyp;
end;

function vfSetGet:getPrices(fillType)
	if fillType == nil then return {};end;
	local sellingStations = vfSetGet:getSellingStations();
	local prices = {};
	if sellingStations ~= nil and #sellingStations > 0 then
		for s=1, #sellingStations do
			local sellingStation = sellingStations[s];
			if sellingStation.ownerFarmId == 0 and sellingStation:getIsFillTypeAllowed(fillType) then --keine eigenen produktionen anzeigen	
				local typ = {[1]=true,[2]=false,[3]=false,[4]=false,[5]=false};
				local objectId = Utils.getNoNil(sellingStation.rootNode, sellingStation.nodeId);					
				local stationName = vfSetGet:getNameMissingXmlText(Utils.getNoNil(sellingStation.uiName, sellingStation.stationName), "Unknown Station");
				local mapHotspot = nil;
				if sellingStation.owningPlaceable ~= nil and sellingStation.owningPlaceable.spec_hotspots ~= nil then mapHotspot = sellingStation.owningPlaceable.spec_hotspots;end;
				local difficultyMultiplier = 1000;
				local price = sellingStation:getEffectiveFillTypePrice(fillType);				
				---
				local priceScale = 1;
				local eScale, ePrice, scaleTyp, eTyp = vfSetGet:getFillTypeExtra(fillType, sellingStation.unloadTriggers);				
				typ = eTyp or typ;
				price = ePrice or price;
				priceScale = eScale or priceScale;				
				price = price * priceScale;
				price = math.floor(price * difficultyMultiplier - 0.5);
				---				
				local priceTrend = sellingStation:getCurrentPricingTrend(fillType)
				local isPriceTrend = "Normal";
				if priceTrend ~= nil then
					if Utils.isBitSet(priceTrend, SellingStation.PRICE_GREAT_DEMAND) then
						isPriceTrend = "GreatDemand";								
					elseif Utils.isBitSet(priceTrend, SellingStation.PRICE_CLIMBING) then
						isPriceTrend = "Up";
					elseif Utils.isBitSet(priceTrend, SellingStation.PRICE_FALLING) then
						isPriceTrend = "Down";
					end;
				end;					
				prices[#prices+1] = {price=price, stationName=stationName, priceTrend=isPriceTrend, nodeId=objectId, scaleTyp=scaleTyp, typ=typ, mapHotspot=mapHotspot};				
			end;
		end;		
		function comp(w1,w2)		
			if w1.price > w2.price then
				return true;
			end;				
		end;		
		table.sort(prices, comp);				
	end;	
	return prices;
end;

function vfSetGet:bestPriceStations(prices, fillLevel, fillType)
	if prices == nil and fillType ~= nil then
		prices = vfSetGet:getPrices(fillType);
		if prices == nil or #prices == 0 then 
			g_currentMission.hlHudSystem.showInfoBox( {g_i18n:getText("ui_buyPrices").. "/".. g_i18n:getText("ui_noSellPointsForThisFillType"), 2500, g_currentMission.hlUtils.getColor("orangeRed", true)} )
			return;
		end;
	end;
	local text = ""
	local priceTrend = {Down=KeyboardHelper.getDisplayKeyName(274.0),Up=KeyboardHelper.getDisplayKeyName(273.0),Normal=KeyboardHelper.getDisplayKeyName(276.0),GreatDemand=KeyboardHelper.getDisplayKeyName(276.0)};
	local stations = {[1]=g_i18n:getText("shopItem_sellStation")..": ",[2]=g_i18n:getText("shopItem_sellingStation")..": ",[3]=g_i18n:getText("shopItem_sellingStationBales")..": ",[4]=g_i18n:getText("shopItem_sellingStationTrain")..": "};
	local scaleTypes = {[1]=g_i18n:getText("configuration_valueDefault"),[2]=g_i18n:getText("scaleTypBulk").. "/".. g_i18n:getText("scaleTypLiquid"),[3]=g_i18n:getText("category_pallets"),[4]=g_i18n:getText("infohud_bale"),[5]=g_i18n:getText("infohud_wood")}; --standard,schüttgut/flüssigkeit,paletten,ballen,holz
	local typ = "";
	local multipleTyp = 0;
	local distanceText = g_i18n:getText("ui_distance");
	function getStationsName(price)
		local stationName = tostring(price.stationName);
		if string.find(stationName:lower(), "unknown station") then stationName = g_i18n:getText("ui_noSellPointsForThisFillType");end;
		return stationName;
	end;
	function setTyp() --view typ (is testing)
		for t=1, #prices[1].typ do
			if prices[1].typ[t] then 
				multipleTyp = multipleTyp+1;
				--if typ:len() > 0 then typ = typ.. ",".. tostring(t);else typ = tostring(scaleTypes[t]);end;
			end;
		end;
		--if typ:len() >= 3 then typ = " (".. typ.. ")";end;
	end;
	function getDistance(nodeId)
		local distanceString = "";
		if nodeId ~= nil and VehicleFruitHud.values.guiMenu.ownTable.view.sellingStationDistance[1] > 1 then
			local distance = -1;
			local x, y, z = getWorldTranslation(nodeId);
			if x ~= nil and y ~= nil and z ~= nil then
				distance = g_currentMission.hlUtils.getDistance(nil, {x=x,y=y,z=z}, "vehicle");			
			end;
			if distance >= 0 then distanceString = " (".. g_i18n:formatDistance(distance, 0).. ") ";end;
		end;
		return distanceString;
	end;
	for price=1, #prices do
		if price ~= 1 then text = text.. "\n";end;
		text = text.. tostring(priceTrend[prices[price].priceTrend]).. stations[price]..  tostring(g_i18n:formatMoney(fillLevel/1000*prices[price].price, 0, true, false)).. " ".. tostring(getDistance(prices[price].nodeId)).. "- ".. tostring(getStationsName(prices[price]));
		if price == 4 then break;end;
	end;
	if text:len() <= 0 then 
		text = g_i18n:getText("ui_noSellPointsForThisFillType");
	else
		setTyp();
		if multipleTyp > 1 then text = text.. "\n".. g_i18n:getText("scaleTypDifference").. "\n! ".. scaleTypes[2].. ",".. scaleTypes[3].. ",".. scaleTypes[4].. " ... !\n".. string.format(g_i18n:getText("scaleTypFor"), tostring(scaleTypes[prices[1].scaleTyp]));end;
	end;
	g_currentMission.hud:showInGameMessage(g_i18n:getText("ui_sellingPoints").. tostring(typ), text, -1);
end;

--by FillTyeAmountPrice Display Mod
function vfSetGet:showInGameMenuFrame(frame, page, fillType, global, change, forceMouse)	
	if frame == nil or g_gui.frames[frame] == nil or change > 1 then return;end;
	local change = change or 0;
	function setForceMouse()		
		g_currentMission.hlUtils.mouseOnOff(false, false); --force mouseOff			
	end;
	if frame == "ingameMenuGameStats" then		
		if (global ~= nil and global) or page == nil then
			if forceMouse == nil or forceMouse then setForceMouse();end; --force mouseOff
			local show = g_gui:showGui("InGameMenu");			
			local pageId = show.parent.pagingElement:getPageIdByElement(show.parent.pageStatistics);
			local pageIndex = show.parent.pagingElement:getPageMappingIndex(pageId);
			show.parent.pageSelector:setState(pageIndex, true);				
		else
			if page ~= nil then
				if forceMouse == nil or forceMouse then setForceMouse();end; --force mouseOff
				local show = g_gui:showGui("InGameMenu");
				local pageId = show.parent.pagingElement:getPageIdByElement(show.parent.pageStatistics);
				local pageIndex = show.parent.pagingElement:getPageMappingIndex(pageId);					
				
				show.parent.pageSelector:setState(pageIndex, true);					
								
				local pageElement = show.parent.pagingElement:getPageById(pageId);
				
				if page == "SUB_CATEGORY.PRICES" then
					InGameMenuStatisticsFrame.onClickPrices(pageElement.element);					
					function searchFillType()
						for f=1, #pageElement.element.fillTypes do
							if pageElement.element.fillTypes[f] ~= nil then
								for i=1, #pageElement.element.fillTypes[f] do
									if fillType == pageElement.element.fillTypes[f][i].index then
										if pageElement.element.fillTypes[f][i].showOnPriceTable then return f, i;else return 0,0;end;
									end;
								end;
							end;												
						end;
						return 0,0;
					end;
					if fillType ~= nil then
						local selectIndex, selectItem = searchFillType();						
						if selectIndex ~= 0 and selectItem ~= 0 then pageElement.element.productList:setSelectedItem(selectIndex, selectItem);end;						
					end;
				end;					
			elseif change == 0 then
				vfSetGet:showInGameMenuFrame(frame, page, fillType, true, change+1, forceMouse)
			end;
		end;
	end;	
end;