VehicleInspector = {};
VehicleInspector.modDir = g_currentModDirectory;
VehicleInspector.modName = g_currentModName;
VehicleInspector.settingsDir = getUserProfileAppPath().. "modSettings/HL/FS25_VehicleInspector/";

VehicleInspector.metadata = {
	interface = "FS25 ...", --convert ls22 to ls25
	title = "VehicleInspector",
	notes = "Zeigt/Ändert Vehicle Informationen/Bestände und vieles mehr in einem Hud/Pda/Box an (mit integrierten HL Hud System)",
	author = "(by HappyLooser)",
	version = "1.0.0.5",
	build = 2125,
	xmlVersion = 1,
	languageVersion = 1,
	datum = "05.11.2016",
	update = "15.10.2025",	
	discord = "HappyLooser Modding",
	info = " Link Freigabe,Änderungen,Kopien oder Code Benutzung ist ohne meine Zustimmung nicht erlaubt",
	"##Orginal Link Freigabe:"
};

function VehicleInspector:loadMap(mapName)		
	print("---loading ".. tostring(VehicleInspector.metadata.title).. " ".. tostring(VehicleInspector.metadata.version).. "(#".. tostring(VehicleInspector.metadata.build).. ") ".. tostring(VehicleInspector.metadata.author).. "---")
	source(VehicleInspector.modDir.."scripte_vidisplay/viSetGetMp.lua");
	viSetGetMp:setServerEvents();
	if not VehicleInspector:getDetiServer() then
		VehicleInspector:loadValues();		
	end;
end;

function VehicleInspector:loadValues() --for All in Mod Extra Load
	if not VehicleInspector:getDetiServer() then		
		VehicleInspector.hlDebugMode = false;	--for Modder Testing				
		generateFolders();
		VehicleInspector.values = {}; --global
		VehicleInspector.testString = {};
		VehicleInspector:loadSource(1);		
		VehicleInspector.loadError = false; --optional for !
		Mission00.onStartMission = Utils.appendedFunction(Mission00.onStartMission, VehicleInspector.onStartMission);
		Vehicle.loadFinished = Utils.appendedFunction(Vehicle.loadFinished, viSetGet.loadFinishedVehicles);
		PlayerInputComponent.registerGlobalPlayerActionEvents = Utils.appendedFunction(PlayerInputComponent.registerGlobalPlayerActionEvents, VehicleInspector.registerActionEventsPlayer);
		VehicleInspector:registerActionEventsPlayer();
	end;
end;

function VehicleInspector:onStartMission()	
	if VehicleInspector:getDetiServer() then return;end;	
	g_currentMission.hlUtils.modLoad("FS25_VehicleInspector");	
	VehicleInspector.otherMods = {autoDrive=false,coursePlay=false,infoDisplayExtension=false,adBlue=false,autoLight=false,allRoundExtension=false,vehicleStatisticMarker=false}; --mod Support	
	VehicleInspector:searchOtherMods();	
	viSetGet:generateKeyValueBox();
	PlayerHUDUpdater.showVehicleInfo = Utils.appendedFunction(PlayerHUDUpdater.showVehicleInfo, viSetGet.showVehicleInfo);	
	local isLoaded = viSetGet:generateAttachedDamageBar();
	if isLoaded then SpeedMeterDisplay.draw = Utils.prependedFunction(SpeedMeterDisplay.draw, viSetGet.showDamageSpeedMeterDraw);end; 
			
	viSetGetSettingsXml:loadConfig();
	VehicleInspector.vmSupport = 1;
	VehicleInspector:loadSource(2);
	VehicleInspector.lastPlayerFarmId = g_currentMission.hlUtils.getPlayerFarmId();
	VehicleInspector_DisplaySetGet:setGlobalFunctions();
	if TrailerJointBlock ~= nil then TrailerJointBlock:loadIcons();end;
	--FSBaseMission.saveSavegame = Utils.appendedFunction(FSBaseMission.saveSavegame, VehicleInspector.saveSavegame);
	ItemSystem.save = Utils.prependedFunction(ItemSystem.save, VehicleInspector.saveSavegame); --patch 1.5.0.1
	if g_currentMission.hlHudSystem ~= nil and g_currentMission.hlHudSystem.hlHud ~= nil and g_currentMission.hlHudSystem.hlHud.generate ~= nil then --check is HL Hud System ready !
		print("#Info: ".. tostring(VehicleInspector.metadata.title).. " generate Hud --> for HL Hud System (".. tostring(g_currentMission.hlHudSystem.metadata.version).. ")")		
		viSetGet:loadOwnIcons();
		if VehicleInspector_Display_XmlHud:loadHud("VehicleInspector_Display_Hud") then			
			VehicleInspector:loadSource(4);
		else
			VehicleInspector.loadError = true; --optional for !			
			print("#WARNING: ".. tostring(VehicleInspector.metadata.title).. " CAN NOT GENERATE Hud ! Check/Search: ? Mod cause with integrated HL Hud System ? ")
		end;		
	else
		g_currentMission.hlUtils.modUnLoad("FS25_VehicleInspector");
		VehicleInspector.loadError = true; --optional for !		
		print("#WARNING: ".. tostring(VehicleInspector.metadata.title).. " CAN NOT GENERATE Hud/Pda/Box ! MISSING --> HL Hud System ! Check/Search: ? Corrupt Mod with integrated HL Hud System ? ")
	end;	
end;

function VehicleInspector:registerActionEventsPlayer()    
   	local isOkay, eventName = InputBinding.registerActionEvent(g_inputBinding, 'VI_MARKEDVEHICLE', self, VehicleInspector.actionKeyMouse ,false ,true ,false ,true);
	if isOkay then g_inputBinding.events[eventName].displayIsVisible = false;end;
	isOkay, eventName = InputBinding.registerActionEvent(g_inputBinding, 'VI_JOINMARKEDVEHICLE', self, VehicleInspector.actionKeyMouse ,false ,true ,false ,true);
	if isOkay then g_inputBinding.events[eventName].displayIsVisible = false;end;
	isOkay, eventName = InputBinding.registerActionEvent(g_inputBinding, 'VI_VIEWCONTRACTORVEHICLE', self, VehicleInspector.actionKeyMouse ,false ,true ,false ,true);
	if isOkay then g_inputBinding.events[eventName].displayIsVisible = false;end;
end;

function VehicleInspector:actionKeyMouse(actionName, keyStatus, arg4, arg5, arg6)	
	if not g_currentMission.hlUtils.dragDrop.on then
		if actionName == "VI_MARKEDVEHICLE" then
			VehicleInspector_MouseKeyEvents:setKey(unicode, sym, modifier, isDownKey, "VI_MARKEDVEHICLE");
		elseif actionName == "VI_JOINMARKEDVEHICLE" then
			VehicleInspector_MouseKeyEvents:setKey(unicode, sym, modifier, isDownKey, "VI_JOINMARKEDVEHICLE");
		elseif actionName == "VI_VIEWCONTRACTORVEHICLE" then
			VehicleInspector_MouseKeyEvents:setKey(unicode, sym, modifier, isDownKey, "VI_VIEWCONTRACTORVEHICLE");
		end;
	end;
end;

function VehicleInspector:delete()
	
end;

function VehicleInspector:deleteMap()
	if g_currentMission == nil then return;end;
	if VehicleInspector:getDetiServer() then return;end;
	if VehicleInspector.attachedDamageBar ~= nil then g_currentMission.hlUtils.deleteOverlays(VehicleInspector.attachedDamageBar.overlay);end;		
end;

function VehicleInspector:mouseEvent(posX, posY, isDown, isUp, button)
	--if g_currentMission == nil then return;end;
	--if VehicleInspector:getDetiServer() or g_currentMission.hlUtils:getIngameMap() or g_currentMission.hlUtils:getFullSize(true,true) then return;end;
	--VehicleInspector_MouseKeyEvents:setKeyMouse(nil, nil, nil, nil, posX, posY, isDown, isUp, button);
end;	

function VehicleInspector:keyEvent(unicode, sym, modifier, isDown)
	if VehicleInspector:getDetiServer() or g_currentMission.hlUtils:getIngameMap() or g_currentMission.hlUtils:getFullSize(true,true) then return;end;
	VehicleInspector_MouseKeyEvents:setKey(unicode, sym, modifier, isDownKey);
end;

function VehicleInspector:update(dt)	
	if VehicleInspector:getDetiServer() then return;end;		
	if VehicleInspector.values.otherData ~= nil and VehicleInspector.otherMods ~= nil then viSetGet:updateAutoLight(dt);end;
	--if VehicleInspector.lastPlayerFarmId ~= g_currentMission.hlUtils.getPlayerFarmId() then VehicleInspector.lastPlayerFarmId = g_currentMission.hlUtils.getPlayerFarmId();VehicleInspector_DisplaySetGet:resetAllData();end;	
end;

function VehicleInspector:draw()
	if VehicleInspector:getDetiServer() or g_currentMission.hlUtils:getIngameMap() or g_currentMission.hlUtils:getFullSize(true,true) then return;end;
	--respect settings for other mods (not every mod) that's why
	setTextAlignment(0);
	setTextLineBounds(0, 0);
	setTextWrapWidth(0);
	setTextColor(1, 1, 1, 1);
	setTextBold(false);
	--respect settings for other mods	
	
	if VehicleInspector.values.previewData ~= nil and VehicleInspector.values.previewData.loadedFillTypes.view[1] > 1 and not VehicleInspector.values.previewData.vehicles.state and #VehicleInspector.values.previewData.loadedFillTypes.fillTypes > 0 then VehicleInspector_DrawPreviewData:setFillTypesShowInfo();end;
	if VehicleInspector.values.previewData ~= nil and VehicleInspector.values.previewData.unloadSide.view[1] > 1 then VehicleInspector_DrawPreviewData:setOpenTipSide();end;
	--if VehicleInspector.values.previewData ~= nil and VehicleInspector.values.previewData.workingWidth.view[1] > 1 then VehicleInspector_DrawPreviewData:setWorkingWidth();end;	
		
	if #VehicleInspector.testString > 0 then
		setTextBold(true);		
		for a=1, #VehicleInspector.testString do
			local posY = 0.25-(a/100);
			renderText(0.5, posY, 0.010, "-S ".. tostring(a).. "- ".. tostring(VehicleInspector.testString[a]));
		end;
	end;
		
	--respect settings for other mods
	setTextAlignment(0);
	setTextLineBounds(0, 0);
	setTextWrapWidth(0);
	setTextColor(1, 1, 1, 1);
	setTextBold(false);
	--respect settings for other mods
end;
addModEventListener(VehicleInspector);

function VehicleInspector:getDetiServer()	
	return g_server ~= nil and g_client ~= nil and g_dedicatedServer ~= nil;	
end;

function VehicleInspector:getHostOrSp()	
	return (g_server ~= nil and g_client ~= nil and g_dedicatedServer == nil) or (not g_currentMission.missionDynamicInfo.isMultiplayer); --only mp host player or single player
end;

function VehicleInspector:searchOtherMods()
	VehicleInspector.otherMods.autoDrive = g_modIsLoaded["FS25_AutoDrive"] and _G["FS25_AutoDrive"] ~= nil;
	VehicleInspector.otherMods.coursePlay = g_modIsLoaded["FS25_Courseplay"] and _G["FS25_Courseplay"] ~= nil;	
	VehicleInspector.otherMods.infoDisplayExtension = g_modIsLoaded["FS25_InfoDisplayExtension"] and _G["FS25_InfoDisplayExtension"] ~= nil and _G["FS25_InfoDisplayExtension"]["InfoDisplayExtension"] ~= nil and _G["FS25_InfoDisplayExtension"]["InfoDisplayExtension"].WearableShowInfo ~= nil;
	VehicleInspector.otherMods.adBlue = false; --g_modIsLoaded["FS25_DefPack"] and _G["FS25_DefPack"] ~= nil;
	VehicleInspector.otherMods.autoLight = false; --g_modIsLoaded["FS25_AutoLightOnOff"] and _G["FS25_AutoLightOnOff"] ~= nil;
	VehicleInspector.otherMods.vehicleStatisticMarker = g_currentMission.hlUtils.modLoaded["FS25_VehicleStatisticMarker"] ~= nil;
	VehicleInspector.otherMods.allRoundExtension = g_currentMission.hlUtils.modLoaded["FS25_AllRoundExtension"] ~= nil and g_currentMission.hlUtils.globalFunction["FS25_AllRoundExtension"].setFrameVehicles ~= nil;
end;

function VehicleInspector.saveSavegame() --Save by LS25
	viSetGetSettingsXml:saveConfig();
end;

function VehicleInspector:loadSource(int)
	if int == 1 then		
		source(VehicleInspector.modDir.."scripte_vidisplay/defaultSettings/viLoadTables.lua");
		source(VehicleInspector.modDir.."scripte_vidisplay/defaultSettings/viSetGetSettingsXml.lua");
		source(VehicleInspector.modDir.."scripte_vidisplay/viSetGet.lua");
		source(VehicleInspector.modDir.."scripte_vidisplay/VehicleInspector_DisplaySetGet.lua");
		source(VehicleInspector.modDir.."scripte_vidisplay/xml/VehicleInspector_Display_XmlHud.lua");
		source(VehicleInspector.modDir.."scripte_vidisplay/mouseKeyEvents/VehicleInspector_MouseKeyEvents.lua");		
	elseif int == 2 then		
		source(VehicleInspector.modDir.."scripte_vidisplay/draw/VehicleInspector_DrawPreviewData.lua");		
	elseif int == 3 then
		source(VehicleInspector.modDir.."scripte_vidisplay/mouseKeyEvents/VehicleInspector_Display_MouseKeyEventsHud.lua");
		source(VehicleInspector.modDir.."scripte_vidisplay/draw/VehicleInspector_Display_DrawHud.lua");		
		source(VehicleInspector.modDir.."scripte_vidisplay/mouseKeyEvents/VehicleInspector_Display_MouseKeyEventsBox.lua");
		source(VehicleInspector.modDir.."scripte_vidisplay/draw/VehicleInspector_Display_DrawBox.lua");
		source(VehicleInspector.modDir.."scripte_vidisplay/mouseKeyEvents/VehicleInspector_Display_MouseKeyEventsAllInBox.lua");
		source(VehicleInspector.modDir.."scripte_vidisplay/draw/VehicleInspector_Display_DrawAllInBox.lua");
		source(VehicleInspector.modDir.."scripte_vidisplay/xml/VehicleInspector_Display_XmlBox.lua");
		source(VehicleInspector.modDir.."scripte_vidisplay/viGuiBoxSetGet.lua");
		source(VehicleInspector.modDir.."scripte_vidisplay/mouseKeyEvents/VehicleInspector_Display_MouseKeyEventsGuiBox.lua");
	elseif int == 4 then
		
	end;
end;

function generateFolders()
	createFolder(getUserProfileAppPath().. "modSettings/");
	createFolder(getUserProfileAppPath().. "modSettings/HL/");
	createFolder(getUserProfileAppPath().. "modSettings/HL/FS25_VehicleInspector/");
	createFolder(getUserProfileAppPath().. "modSettings/HL/FS25_VehicleInspector/languages/");	
end;