VehicleInspector_DisplaySetGet = {};

function VehicleInspector_DisplaySetGet:loadFillTypesIcons()
	g_currentMission.hlUtils.loadFillTypesOverlays();	
end;

function VehicleInspector_DisplaySetGet:loadHudIcons(hud)
	if hud.overlays.modIcons == nil then hud.overlays.modIcons = {byName={}};end;
	local _, _ = g_currentMission.hlUtils.insertIcons( {xmlTagName="vi_display.hudIcons", modDir=VehicleInspector.modDir, iconFile="icons_vidisplay/icons.dds", xmlFile="icons_vidisplay/icons.xml", modName="VehicleInspector", groupName="hud", fileFormat={64,256,256}, iconTable=hud.overlays.modIcons} );
end;

function VehicleInspector_DisplaySetGet:loadBoxIcons(box)
	if box.name == "VehicleInspector_Display_Box" then
		if box.overlays.icons == nil then box.overlays.icons = {byName={}};end;
		local firstIcon, lastIcon =	g_currentMission.hlUtils.insertIcons( {xmlTagName="vi_display.boxIcons_64", modDir=VehicleInspector.modDir, iconFile="icons_vidisplay/icons.dds", xmlFile="icons_vidisplay/icons.xml", modName="defaultIcons", groupName="box", fileFormat={64,256,256}, iconTable=box.overlays.icons} ); --own
		
		firstIcon, lastIcon =	g_currentMission.hlUtils.insertIcons( {xmlTagName="vi_display.boxIcons_32", modDir=VehicleInspector.modDir, iconFile="icons_vidisplay/icons.dds", xmlFile="icons_vidisplay/icons.xml", modName="defaultIcons", groupName="box", fileFormat={32,256,256}, iconTable=box.overlays.icons} ); --own
		
		firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="vi_display.boxIcons64", modDir=VehicleInspector.modDir, iconFile="hlHudSystem/icons/icons.dds", xmlFile="icons_vidisplay/icons.xml", modName="defaultIcons", groupName="box", fileFormat={64,512,1024}, iconTable=box.overlays.icons} );		
						
		firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="vi_display.otherIcons32", modDir=VehicleInspector.modDir, iconFile="hlHudSystem/icons/otherIcons.dds", xmlFile="icons_vidisplay/icons.xml", modName="defaultIcons", groupName="box", fileFormat={32,256,512}, iconTable=box.overlays.icons} );
		
		firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="vi_display.other1Icons32", modDir=VehicleInspector.modDir, iconFile="hlHudSystem/icons/other1Icons.dds", xmlFile="icons_vidisplay/icons.xml", modName="defaultIcons", groupName="box", fileFormat={32,256,512}, iconTable=box.overlays.icons} );
		
		firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="vi_display.colorIcons32", modDir=VehicleInspector.modDir, iconFile="hlHudSystem/icons/colorIcons.dds", xmlFile="icons_vidisplay/icons.xml", modName="defaultIcons", groupName="box", fileFormat={32,128,256}, iconTable=box.overlays.icons} );
	
	elseif box.name == "VehicleInspector_Display_AllInBox" then
		if box.overlays.icons == nil then box.overlays.icons = {byName={}};end;
		local firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="vi_display.otherAllInBoxIcons32", modDir=VehicleInspector.modDir, iconFile="hlHudSystem/icons/otherIcons.dds", xmlFile="icons_vidisplay/icons.xml", modName="defaultIcons", groupName="box", fileFormat={32,256,512}, iconTable=box.overlays.icons} );
		
		firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="vi_display.other1AllInBoxIcons32", modDir=VehicleInspector.modDir, iconFile="hlHudSystem/icons/other1Icons.dds", xmlFile="icons_vidisplay/icons.xml", modName="defaultIcons", groupName="box", fileFormat={32,256,512}, iconTable=box.overlays.icons} );
		
		firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="vi_display.colorAllInBoxIcons32", modDir=VehicleInspector.modDir, iconFile="hlHudSystem/icons/colorIcons.dds", xmlFile="icons_vidisplay/icons.xml", modName="defaultIcons", groupName="box", fileFormat={32,128,256}, iconTable=box.overlays.icons} );
		
		firstIcon, lastIcon =	g_currentMission.hlUtils.insertIcons( {xmlTagName="vi_display.allInBoxIcons_32", modDir=VehicleInspector.modDir, iconFile="icons_vidisplay/icons.dds", xmlFile="icons_vidisplay/icons.xml", modName="defaultIcons", groupName="box", fileFormat={32,256,256}, iconTable=box.overlays.icons} ); --own
		
		firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="vi_display.allInBoxIcons64", modDir=VehicleInspector.modDir, iconFile="hlHudSystem/icons/icons.dds", xmlFile="icons_vidisplay/icons.xml", modName="defaultIcons", groupName="box", fileFormat={64,512,1024}, iconTable=box.overlays.icons} );		
		
	end;
end;

function VehicleInspector_DisplaySetGet:setIconsColor(box)
	if box ~= nil then
		local overlayDefaultGroup = box.overlays.icons["defaultIcons"]["box"];
		local overlayDefaultByName = box.overlays.icons.byName["defaultIcons"]["box"];
		local overlay = overlayDefaultGroup[overlayDefaultByName["markedVehicle"]];
		if overlay ~= nil then g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(box.ownTable.showColors.marked, true));end;
		overlay = nil;
		overlay = overlayDefaultGroup[overlayDefaultByName["tempomat"]];
		if overlay ~= nil then g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor("yellowGreen", true));end;
	end;	
end;

function VehicleInspector_DisplaySetGet:setIconsForOtherMods()
	--local firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="vi_display.forOtherModsIcons32", modDir=VehicleInspector.modDir, iconFile="icons_vidisplay/icons.dds", xmlFile="icons_vidisplay/icons.xml", modName="vehicleInspector", groupName="32x32", fileFormat={32,256,256}, iconTable=box.overlays.icons} );
	--firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="vi_display.forOtherModsIcons64", modDir=VehicleInspector.modDir, iconFile="icons_vidisplay/icons.dds", xmlFile="icons_vidisplay/icons.xml", modName="vehicleInspector", groupName="64x64", fileFormat={64,256,256}, iconTable=box.overlays.icons} );
end;

function VehicleInspector_DisplaySetGet:setForceMouseOff()
	g_currentMission.hlUtils.mouseOnOff(false, false); --force mouseOff
end;

function VehicleInspector_DisplaySetGet:loadVehicleOverlay(vehicle)
	if vehicle ~= nil then		
		local storeItem = g_storeManager:getItemByXMLFilename(vehicle.configFileName)
		if storeItem ~= nil then
			local isLoad = g_currentMission.hlUtils.loadVehicleOverlay(nil, storeItem);		
		end;
	end;
end;

function VehicleInspector_DisplaySetGet:getStoreItemName(vehicleNode)	
	local storeName = "VehicleName Unknown";
	local vehicle = g_currentMission.nodeToObject[vehicleNode];
	if vehicle ~= nil then
		local storeItem = g_storeManager:getItemByXMLFilename(vehicle.configFileName);
		if storeItem ~= nil then storeName = storeItem.name;end;
		if storeName == nil then storeName = "VehicleName Unknown";end;
	end;
	return storeName;
end;

function VehicleInspector_DisplaySetGet:getVehicleNodes(boxValues, globalValues)
	local playerFarmId = g_currentMission.hlUtils.getPlayerFarmId();
	local vehicles = {};
	if g_currentMission ~= nil and g_currentMission.vehicleSystem ~= nil and g_currentMission.vehicleSystem.vehicles ~= nil then
		for v=1, #g_currentMission.vehicleSystem.vehicles do
			local vehicle = g_currentMission.vehicleSystem.vehicles[v];			
			if vehicle ~= nil and vehicle.finishedLoading == true and vehicle.getIsControlled ~= nil then
				local playerControlled = viSetGet:isControlledVehicle() and viSetGet:getControlledVehicle() == vehicle;
				if playerControlled or playerFarmId == vehicle.ownerFarmId or (playerFarmId ~= vehicle.ownerFarmId and viSetGet:getFarmContractor(playerFarmId, vehicle.ownerFarmId)) then
					if vehicle.viJobIsActive == nil then vehicle.viJobIsActive = false;end;
					if vehicle.viIsMarked == nil then vehicle.viIsMarked = false;end;
					if vehicle.viTypIcon == nil then vehicle.viTypIcon = viSetGet:getVehicleTypIconBySchema(vehicle);end;
					table.insert(vehicles, vehicle.rootNode);
				end;
			end;
		end;
	end;
	return vehicles;
end;

function VehicleInspector_DisplaySetGet:clickVehicleLine(mouseClick, vehicleNode)
	local vehicle = g_currentMission.nodeToObject[vehicleNode];
	if vehicle ~= nil then
		if mouseClick == "right" then
			if g_currentMission.hlHudSystem.camera.active and g_currentMission.hlHudSystem.camera.node ~= 0 then
				local box = g_currentMission.hlHudSystem.hlBox:getData("VehicleInspector_Display_Box");
				local camBox = g_currentMission.hlHudSystem.hlBox:getData("hlHudSystem_CameraBox");
				if box ~= nil and camBox ~= nil then
					if g_currentMission.hlHudSystem.camera.object.node == 0 or g_currentMission.hlHudSystem.camera.object.node ~= vehicleNode then
						g_currentMission.hlHudSystem.camBox.setObject( {node=vehicleNode, isVehicle=true, camZoom=box.ownTable.camera.zoom[1], camRotation={box.ownTable.camera.rotX[1]}, onClick=VehicleInspector_Display_MouseKeyEventsBox.onClickCamBox} );
						g_currentMission.hlHudSystem.camBox.setShow(true);
					elseif g_currentMission.hlHudSystem.camera.object.node == vehicleNode then
						g_currentMission.hlHudSystem.camBox.setShow(false);
					end;
				end;
			else
				g_currentMission.hlHudSystem.showInfoBox( {"CamBox... ".. g_i18n:getText("noConvertLs25"), 3000, g_currentMission.hlUtils.getColor("orangeRed", true)} );				
			end;			
		elseif mouseClick == "left" then
			VehicleInspector_DisplaySetGet:clickVehicleJoin(vehicle);
		end;
	end;
end;

function VehicleInspector_DisplaySetGet.clickVehicleDisplayJoin() 
	
end;

function VehicleInspector_DisplaySetGet:clickVehicleJoin(vehicle) 
	if vehicle == nil then return;end;
	if viSetGet:isControlledVehicle() and vehicle == viSetGet:getControlledVehicle() then return;end;		
	if vehicle.getIsControlled ~= nil and vehicle.getIsControlled(vehicle) then g_currentMission.hlHudSystem.showInfoBox( {g_i18n:getText("shop_messageIsInUse"), 1500} );end;	
	if vehicle.getIsEnterable ~= nil and vehicle:getIsEnterable() then		
		VehicleInspector_DisplaySetGet:setForceMouseOff();
		g_localPlayer:requestToEnterVehicle(vehicle);		
		return;
	end;
	return;	
end;

function VehicleInspector_DisplaySetGet:isParkingVehicle(vehicle) --parkingMod
	if vehicle.spec_parkvehicle ~= nil then
		local spec = vehicle.spec_parkvehicle;
		if spec.state[spec.uniqueUserId] then return true;end;
		return false;
	end;
	return false;
end;

function VehicleInspector_DisplaySetGet:getAttachedType(vehicle, attachedType, attachedNr)	
	local attached = 0;	
	if attachedNr == 0 and vehicle.getAttachedImplements == nil and (attachedType == "none" or attachedType == "all") then return -1;end;
	if vehicle.getAttachedImplements ~= nil then 
		local attachTable = vehicle:getAttachedImplements(vehicle);
		if attachTable ~= nil then		
			for _,attach in pairs(attachTable) do		
				if attach.object ~= nil and attach.object.typeName ~= nil then
					local typeName = Utils.getNoNil(attach.object.typeName, "Unknown"):lower();
					if not string.find(typeName, "implement") then
						attached = attached+1;
						if attachedType == "all" or attachedType == "none" then break;end;											
						if attach.object.viCategoryName ~= nil and attach.object.viCategoryName ~= attachedType then attached = attached-1;end;
					end;					
					local tempAttached = VehicleInspector_DisplaySetGet:getAttachedType(attach.object, attachedType, attachedNr+1);
					attached = attached+tempAttached;					
				end;
			end;
		end;
	end;
	return attached;
end;

function VehicleInspector_DisplaySetGet:joinVehicle(delta, joinType, trailer, attachedType)
	local playerFarmId = g_currentMission.hlUtils.getPlayerFarmId();
	local joinContractorVehicle = VehicleInspector.values.joinVehicles == 2 or not g_currentMission.missionDynamicInfo.isMultiplayer;
	local isMarkedVehicle = false;
	function isVehicleAndTrailerType(vehicle)		
		if joinType == "marked" then 
			if vehicle.viIsMarked ~= nil and vehicle.viIsMarked then isMarkedVehicle = true;return isMarkedVehicle;end;
			return isMarkedVehicle;
		end;
		
		if joinType == "all" then return true;end;
		if joinType == "implement_conveyorbelt" or joinType == "handtoolmower" then return false;end;		
		if joinType == "miscvehicles" and (vehicle.trainSystem ~= nil or vehicle.spec_rideable ~= nil) then return true;end;
		if joinType == "tractor_frontloader" then
			local _, frontloaderAttached = viSetGet:getAttached(vehicle, {}, false);
			local hasFrontloader = vehicle.configurations ~= nil and vehicle.configurations.frontloader ~= nil;
			local isFrontloader = hasFrontloader and vehicle.configurations.frontloader > 1;				
			return isFrontloader and frontloaderAttached;			
		end;
		if joinType == vehicle.viTypIcon then 
			if not trailer then return true;end;
			local attached = VehicleInspector_DisplaySetGet:getAttachedType(vehicle, attachedType, 0);			
			if attached == -1 then return false;end;
			if attached <= 0 and attachedType == "none" then return true;end;
			if attached > 0 and attachedType == "none" then return false;end;
			return attached > 0;
		end;			
		return false;
	end;	
		
	if not g_currentMission.isToggleVehicleAllowed then
		return;
	end;
	local numVehicles = #g_currentMission.vehicleSystem.enterables;
	if numVehicles > 0 then
		local index = 1;
		local oldIndex = 1;
		if g_localPlayer:getIsInVehicle() then 
			for i = 1, numVehicles do
				if viSetGet:getControlledVehicle() == g_currentMission.vehicleSystem.enterables[i] then
					oldIndex = i;
					index = i + delta;
					if numVehicles < index then
						index = 1;
					end;
					if index < 1 then
						index = numVehicles;
					end;
					break;
				end;
			end;
		elseif delta < 0 then
			index = numVehicles;
		end;
		local found = false;
		repeat
			local enterable = g_currentMission.vehicleSystem.enterables[index];			
			local isContractorVehicle = viSetGet:getFarmContractor(playerFarmId, enterable.ownerFarmId);
			local canJoinContratorVehicle = (isContractorVehicle and joinContractorVehicle) or (not isContractorVehicle and VehicleInspector.values.joinVehicles == 1);
			local canTabbable = enterable:getIsTabbable();
			local canJoinType = isVehicleAndTrailerType(enterable);					
			if canJoinType and canTabbable and enterable:getIsEnterable() and canJoinContratorVehicle then
				found = true;
			else
				index = index + delta;
				if numVehicles < index then
					index = 1;
				end;
				if index < 1 then
					index = numVehicles;
				end;
			end;
		until found or index == oldIndex;
		if found then
			g_localPlayer:requestToEnterVehicle(g_currentMission.vehicleSystem.enterables[index]);
		end;
	end;	
end;

function VehicleInspector_DisplaySetGet:markedVehicle()
	local vehicle = viSetGet:getControlledVehicle(true);
	if vehicle == nil then return;end;		
	if vehicle.viIsMarked == nil then vehicle.viIsMarked = false;end;
	if not vehicle.viIsMarked then			
		vehicle.viIsMarked = true;		
		g_currentMission.hlHudSystem.showInfoBox( {"Vehicle is Marked", 1000, g_currentMission.hlUtils.getColor("ls25active", true)} );		
		if g_currentMission.hlUtils.modLoaded["FS25_VehicleManagerDisplay"] ~= nil and vehicle.vmControl ~= nil and vehicle.vmControl.typId ~= nil then
			g_currentMission.hlUtils.globalFunction["FS25_VehicleManagerDisplay"].setMarkedVehicleByTypId( {status=true, typId=vehicle.vmControl.typId} );
		end;				
	elseif vehicle.viIsMarked then
		vehicle.viIsMarked = false;
		g_currentMission.hlHudSystem.showInfoBox( {"Vehicle mark deleted", 1000, g_currentMission.hlUtils.getColor("ls25active", true)} );		
		if g_currentMission.hlUtils.modLoaded["FS25_VehicleManagerDisplay"] ~= nil and vehicle.vmControl ~= nil and vehicle.vmControl.typId ~= nil then
			g_currentMission.hlUtils.globalFunction["FS25_VehicleManagerDisplay"].setMarkedVehicleByTypId( {status=false, typId=vehicle.vmControl.typId} );
		end;			
	end;	
end;

function VehicleInspector_DisplaySetGet:resetAllData()

end;

function VehicleInspector_DisplaySetGet:isViewWarnings(values)
	if values.viewWarnings == nil then return false;end;
	for k,v in pairs (values.viewWarnings) do
		if k ~= "isOpen" then
			if v[1] > 1 then return true;end;
		end;
	end;
	return false;
end;

function VehicleInspector_DisplaySetGet:setViewVehiclesBox(box)	
	local playerFarmId = g_currentMission.hlUtils.getPlayerFarmId();
	local boxValues = box.ownTable;
	local globalValues = VehicleInspector.values;
	local vehicles = VehicleInspector_DisplaySetGet:getVehicleNodes(boxValues, globalValues);
	local viewVehicles = {};	
	local viewContractorVehicles = {};
	local playerControlled = {};
	local vehiclesSortBy = {};	
	local openDetails = false;
	local lengthData = {attachedTotal=0};
	local sortList = false;
	local sortNumbers = {isHelperJobEndTimeBlinking=1,isPlayer=2,isOtherPlayer=3,isHelper=4,isMarked=5,isVmViewGroup=6,isNoSort=7};
	if g_currentMission.missionDynamicInfo.isMultiplayer and boxValues.view.contractor[1] == 3 then
		if not viSetGet:hasFarmContracting(playerFarmId) then boxValues.view.contractor[1] = 2;end;		
	end;	
	if vehicles ~= nil and #vehicles > 0 then
		for v=1, #vehicles do
			local vehicle = g_currentMission.nodeToObject[vehicles[v]];
			if vehicle ~= nil then				
				local ownerFarmId = playerFarmId == vehicle.ownerFarmId;
				local viewTable = viewVehicles;
				if viSetGet:isControlledVehicle() and viSetGet:getControlledVehicle() == vehicle then viewTable = playerControlled;
				elseif not ownerFarmId then viewTable = viewContractorVehicles;end;
				viewTable[#viewTable+1] = { ownerFarmId=ownerFarmId, node=vehicles[v], vehicleName=viSetGet:getVehicleName(vehicles[v], boxValues.view["vehicleName"], vehicle.spec_rideable ~= nil, vehicle.trainSystem ~= nil), isMarked=vehicle.viIsMarked, sortType="number", sortBy=0, attached={} };
				viewTable[#viewTable].jobType = {ad=vehicle.spec_autodrive ~= nil and vehicle.ad ~= nil and vehicle.ad.stateModule:isActive(),ls=vehicle.getJob ~= nil and vehicle:getJob(),cp=false};
				if not viewTable[#viewTable].jobType.ad and vehicle.getCpStatus ~= nil then
					local cpStatus = vehicle:getCpStatus();
					viewTable[#viewTable].jobType.cp = cpStatus ~= nil and cpStatus:getIsActive();
				end;				
				viewTable[#viewTable].isJob = viewTable[#viewTable].jobType.ad or viewTable[#viewTable].jobType.ls or viewTable[#viewTable].jobType.cp;				
				viewTable[#viewTable].job = viSetGet:getJobTypeData(vehicle, {}, viewTable[#viewTable].jobType);		 
				viewTable[#viewTable].hasGps = vehicle.spec_globalPositioningSystem ~= nil and vehicle.spec_globalPositioningSystem.hasGuidanceSystem;
				viewTable[#viewTable].isGpsActive = viewTable[#viewTable].hasGps and vehicle.spec_globalPositioningSystem.lastInputValues.guidanceIsActive;
				viewTable[#viewTable].isParking = vehicle.spec_parkvehicle ~= nil and vehicle.spec_parkvehicle.state[vehicle.spec_parkvehicle.uniqueUserId];
				viewTable[#viewTable].isTrain = vehicle.trainSystem ~= nil;
				viewTable[#viewTable].isHorse = vehicle.spec_rideable ~= nil;
				local missionsLeasing = vehicle.viMissionsLeasingField ~= nil and vehicle.viMissionsLeasingField >= 0;
				viewTable[#viewTable].isLeasing = vehicle.propertyState == 3 or vehicle.propertyState == 4 or missionsLeasing;
				viewTable[#viewTable].isMissionLeasing = vehicle.propertyState == 4 or missionsLeasing;
				viewTable[#viewTable].isShopConfig = vehicle.propertyState == 5; --???
				viewTable[#viewTable].hasEngine = viSetGet:hasEngine(vehicle);
				viewTable[#viewTable].isEngine = viewTable[#viewTable].hasEngine and vehicle:getIsMotorStarted();
				viewTable[#viewTable].speed = viSetGet:getVehicleSpeed(vehicles[v], viewTable[#viewTable].hasEngine, boxValues.view["speed"]);
				viewTable[#viewTable].hasTempomat = viewTable[#viewTable].hasEngine and vehicle.spec_drivable ~= nil and vehicle.spec_drivable.cruiseControl ~= nil and vehicle.spec_rideable == nil;
				viewTable[#viewTable].isTempomat = viSetGet:getVehicleSpeedControl(vehicles[v], viewTable[#viewTable].hasTempomat );				
				viewTable[#viewTable].isReverses = viewTable[#viewTable].isEngine and vehicle.getIsDrivingBackward ~= nil and vehicle:getIsDrivingBackward();
				local controlledName, isOtherPlayer, isPlayer = "", false, false, false;
				local isControlled = vehicle.getIsControlled ~= nil and vehicle.getIsControlled(vehicle); --straw harvest pack fix
				if isControlled then
					controlledName, isOtherPlayer = viSetGet:getPlayerName(vehicle);
					isPlayer = controlledName:len() > 0 and isOtherPlayer == false;									
				end;
				viewTable[#viewTable].controlledName = controlledName;				
				viewTable[#viewTable].isPlayer = isPlayer;
				viewTable[#viewTable].isOtherPlayer = isOtherPlayer;
				viewTable[#viewTable].isHelper = viSetGet:isHelper(vehicle);
				viewTable[#viewTable].helperName = viSetGet:getHelperName(vehicle);				
				viewTable[#viewTable].isOnField = false;
				local isOnField, wx, wz = viSetGet:getIsOnField(vehicle, boxValues.view["field"]);
				viewTable[#viewTable].isOnField = isOnField;
				viewTable[#viewTable].fieldNumber = viSetGet:getFieldNumber(isOnField, wx, wz, boxValues.view["field"]);
				
				--viewTable[#viewTable].remainingString = viSetGet:getRemainingString(vehicle, isPlayer, viewTable[#viewTable].jobType, boxValues);
				
				viewTable[#viewTable].remainingData = viSetGet:getRemainingData(vehicle, {timeTxt="", timeLarge=false, waypointsTxt="", waypoints=-1, nSec=0}, isPlayer, viewTable[#viewTable].jobType, boxValues)
				
				viewTable[#viewTable].warnings = {isWater=false,isBlocking=false,blockingTyp=0,isFuelEmpty=false,isDamage=false,isAdBlueEmpty=false};
				if vehicle.trainSystem == nil and vehicle.spec_rideable == nil and VehicleInspector_DisplaySetGet:isViewWarnings(boxValues) then
					viewTable[#viewTable].warnings.isWater = boxValues.viewWarnings.isWater[1] > 1 and (vehicle.isInWater or vehicle.showTailwaterDepthWarning);
					local isDamage, dPercent = viSetGet:getDamage(vehicle, boxValues);
					viewTable[#viewTable].warnings.isDamage = isDamage;
					if isDamage then viewTable[#viewTable].warnings.damageProzent = dPercent;end;					
					local isFuelEmpty, fPercent, fuelType = viSetGet:getFuel(vehicle, boxValues);
					viewTable[#viewTable].warnings.isFuelEmpty = isFuelEmpty;
					if isFuelEmpty then viewTable[#viewTable].warnings.fuelProzent = fPercent;viewTable[#viewTable].warnings.fuelType = fuelType;end;								
					--Mod AdBlue--
					local isAdBlueEmpty adPercent = viSetGet:getAdBlue(vehicle, boxValues);
					viewTable[#viewTable].warnings.isAdBlueEmpty = isAdBlueEmpty;
					if isAdBlueEmpty then viewTable[#viewTable].warnings.adBlueProzent = adPercent;end;
					--Mod AdBlue--
					local isBlocking, didMoveStop, stillBlocking = viSetGet:getCollision(vehicle, viewTable[#viewTable].isJob, boxValues.viewWarnings["isBlocking"]);
					viewTable[#viewTable].warnings.isBlocking = isBlocking;
					if isBlocking then 
						if viewTable[#viewTable].isJob and stillBlocking == nil then
							local adDrivePath = nil;
							if viewTable[#viewTable].jobType.ad then adDrivePath = vehicle.ad.drivePathModule;end;
							if viewTable[#viewTable].jobType.ad and ( (adDrivePath ~= nil and adDrivePath.wayPoints ~= nil) or (didMoveStop ~= nil and didMoveStop) ) then
								viewTable[#viewTable].warnings.blockingTyp = 2;
								if VehicleInspector.otherMods.autoDrive and viewTable[#viewTable].jobType.ad and adDrivePath ~= nil and adDrivePath.wayPoints ~= nil then 
									if vehicle.ad.collisionDetectionModule.detectedObstable then viewTable[#viewTable].warnings.blockingTyp = 1;end;									
								end;								
							else
								viewTable[#viewTable].warnings.blockingTyp = 1;
							end;
						else
							if didMoveStop == nil then viewTable[#viewTable].warnings.blockingTyp = 1;end;
						end;
					end;
				end;
				viewTable[#viewTable].isWarning = viewTable[#viewTable].warnings.isDamage or viewTable[#viewTable].warnings.isFuelEmpty or viewTable[#viewTable].warnings.isBlocking or viewTable[#viewTable].warnings.isWater or viewTable[#viewTable].warnings.isAdBlueEmpty;
				
				--set MissionsVehicle Fields--
				if viewTable[#viewTable].isMissionLeasing and vehicle.viMissionsLeasingField == nil then
					viSetGet:setMissionsVehicleFieldNumber(vehicle);
					if vehicle.viMissionsLeasingField == nil then vehicle.viMissionsLeasingField = 0;end;
				end;
				--search MissionsVehicle Fields--
				
				viewTable[#viewTable].isPipeState = viSetGet:getPipeState(vehicle, viewTable[#viewTable].isJob, boxValues.view["overload"]);
				viewTable[#viewTable].fillLevelInformation = {};
				viSetGet:setFillLevelInformation(vehicle, viewTable[#viewTable].fillLevelInformation, false, viewTable[#viewTable].isPipeState, boxValues);
				local attached, frontloaderAttached = viSetGet:getAttached(vehicle, {}, false);
				viewTable[#viewTable].hasAttached = attached ~= nil and #attached > 0;
				if viewTable[#viewTable].hasAttached then
					if vehicle.trainSystem == nil and vehicle.spec_rideable == nil and lengthData.attachedTotal < #attached then lengthData.attachedTotal = #attached;end;
					viewTable[#viewTable].attached = attached;
					for o=1, #attached do
						if attached[o] ~= nil then							
							viSetGet:setFillLevelInformation(g_currentMission:getNodeObject(attached[o].rootNode), viewTable[#viewTable].fillLevelInformation, nil, nil, boxValues);
						end;
					end;					
				end;				
				if boxValues.view.helperJobEndTimeBlinking[1] > 1 and not isPlayer and not isOtherPlayer then					
					if viewTable[#viewTable].isJob and not vehicle.viJobIsActive then
						vehicle.viJobIsActive = true;
						g_currentMission.hlUtils.removeTimer("viJobBlinkingTimer_".. tostring(vehicle.rootNode));
						g_currentMission.hlUtils.addTimer({name="viJobBlinkingTimer_".. tostring(vehicle.rootNode), delay=boxValues.length.helperJobEndTimeBlinking[1], repeatable=true, ownTable={node=vehicle.rootNode}});						
					elseif vehicle.viJobIsActive and not viewTable[#viewTable].isJob then	
						if g_currentMission.hlUtils.timers ~= nil and g_currentMission.hlUtils.timers["viJobBlinkingTimer_".. tostring(vehicle.rootNode)] ~= nil and g_currentMission.hlUtils.timers["viJobBlinkingTimer_".. tostring(vehicle.rootNode)].action == nil then
							g_currentMission.hlUtils.timers["viJobBlinkingTimer_".. tostring(vehicle.rootNode)].repeatable = false;
							g_currentMission.hlUtils.timers["viJobBlinkingTimer_".. tostring(vehicle.rootNode)].current_time = 0;
							g_currentMission.hlUtils.timers["viJobBlinkingTimer_".. tostring(vehicle.rootNode)].delay = boxValues.length.helperJobEndTimeBlinking[1]*1000;							
							g_currentMission.hlUtils.timers["viJobBlinkingTimer_".. tostring(vehicle.rootNode)].action = VehicleInspector_DisplaySetGet.removeJobEndTimeBlinking;	
						end;
					end;
				else
					g_currentMission.hlUtils.removeTimer("viJobBlinkingTimer_".. tostring(vehicle.rootNode));
					vehicle.viJobIsActive = false;
				end;
				viewTable[#viewTable].hasFrontloader = vehicle.configurations ~= nil and vehicle.configurations.frontloader ~= nil;
				viewTable[#viewTable].isFrontloader = viewTable[#viewTable].hasFrontloader and vehicle.configurations.frontloader > 1;				
				viewTable[#viewTable].frontloaderAttached = viewTable[#viewTable].isFrontloader and frontloaderAttached;				
				local vmIsGroup, vmViewGroup = false,false;
				if g_currentMission.hlUtils.modLoaded["FS25_VehicleManagerDisplay"] ~= nil then
					if g_currentMission.hlHudSystem.ownData.hiddenMods ~= nil and g_currentMission.hlHudSystem.ownData.hiddenMods["VehicleManager"] ~= nil and not g_currentMission.hlHudSystem.ownData.hiddenMods["VehicleManager"].isHidden then 
						vmIsGroup, vmViewGroup = g_currentMission.hlUtils.globalFunction["FS25_VehicleManagerDisplay"].isViewVehicleGroup( {vehicle=vehicle} );
					end;
				end;
				viewTable[#viewTable].vmIsGroup = vmIsGroup;
				viewTable[#viewTable].vmViewGroup = vmViewGroup;
				
				--set sortBy number--				
				if sortList then
					if boxValues.view.helperJobEndTimeBlinking[1] > 1 and vehicle.viJobIsActive then viewTable[#viewTable].sortBy = sortNumbers.isHelperJobEndTimeBlinking;
					elseif isPlayer then viewTable[#viewTable].sortBy = sortNumbers.isPlayer;
					elseif isOtherPlayer then viewTable[#viewTable].sortBy = sortNumbers.isOtherPlayer;
					elseif viewTable[#viewTable].isHelper or viewTable[#viewTable].isJob then viewTable[#viewTable].sortBy = sortNumbers.isHelper;
					elseif vehicle.viIsMarked then viewTable[#viewTable].sortBy = sortNumbers.isMarked;
					elseif vmViewGroup then viewTable[#viewTable].sortBy = sortNumbers.isVmViewGroup;
					else viewTable[#viewTable].sortBy = sortNumbers.isNoSort;sortNumbers.isNoSort = sortNumbers.isNoSort+1;end;
				end;
				--set sortBy number--				
				
				--view--
				local viewSpeciale = (boxValues.view.helperJobEndTimeBlinking[1] > 1 and vehicle.viJobIsActive) or vehicle.viIsMarked or vmViewGroup;
				local viewTrain = (isPlayer or isOtherPlayer) and vehicle.trainSystem ~= nil and boxValues.view.train[1] > 1;
				local viewHorse = (isPlayer or isOtherPlayer) and vehicle.spec_rideable ~= nil and boxValues.view.horse[1] > 1;
				local viewControlled = isPlayer or isOtherPlayer or viewTable[#viewTable].isHelper or viewTable[#viewTable].isJob;
				--								
				if viewControlled and vehicle.trainSystem ~= nil and not viewTrain then viewControlled = false;end;
				if viewControlled and vehicle.spec_rideable ~= nil and not viewHorse then viewControlled = false;end;
				--
				if not viewControlled and isPlayer then viewControlled = true;end; --viewContractorVehicles, force playerControlled Vehicle, set on Top
				if not viewControlled and viewSpeciale then viewControlled = true;end;
				--
				if not viewControlled then viewTable[#viewTable] = nil;end;
				--view--				
			end;
		end;
		--sort on top--
		function sortByNumberDown(w1,w2)		
			if w1.sortBy < w2.sortBy then
				return true;
			end;				
		end;
		if sortList and #viewVehicles > 0 then table.sort(viewVehicles, sortByNumberDown);end;
		if sortList and #viewContractorVehicles > 0 then table.sort(viewContractorVehicles, sortByNumberDown);end;
		--sort on top--
	end;
	local addTables = {};		
	if #playerControlled > 0 then
		table.foreach(playerControlled, function(k, v) table.insert(addTables, v) end);		
	end;
	if (g_currentMission.missionDynamicInfo.isMultiplayer and boxValues.view.contractor[1] ~= 3) or not g_currentMission.missionDynamicInfo.isMultiplayer then
		table.foreach(viewVehicles, function(k, v) table.insert(addTables, v) end);		
	end;	
	if g_currentMission.missionDynamicInfo.isMultiplayer and viewContractorVehicles ~= nil and #viewContractorVehicles > 0 and boxValues.view.contractor[1] > 1 then
		table.foreach(viewContractorVehicles, function(k, v) table.insert(addTables, v) end);
	end;	
	VehicleInspector_DisplaySetGet.viewVehiclesBox = addTables;
	return openDetails, lengthData;
end;

function VehicleInspector_DisplaySetGet.removeJobEndTimeBlinking(timer)
	if timer ~= nil and timer.ownTable ~= nil and timer.ownTable.node ~= nil then
		local vehicle = g_currentMission.nodeToObject[timer.ownTable.node];
		if vehicle ~= nil and vehicle.viJobIsActive then
			vehicle.viJobIsActive = false;
		end;
	end;
end;

function VehicleInspector_DisplaySetGet:setViewVehiclesAllInBox(box)	
	local playerFarmId = g_currentMission.hlUtils.getPlayerFarmId();
	local boxValues = box.ownTable;	
	local globalValues = VehicleInspector.values;
	local vehicles = VehicleInspector_DisplaySetGet:getVehicleNodes(boxValues, globalValues);
	function resetData()
		for key, value in pairs (boxValues.viewTyp) do
			if key ~= "isOpen" then
				value[4] = {total=0,viewVehicles={},viewContractorVehicles={}};
			end;
		end;
	end;
	resetData();
	if vehicles ~= nil and #vehicles > 0 then		
		for v=1, #vehicles do
			local vehicle = g_currentMission.nodeToObject[vehicles[v]];
			if vehicle ~= nil then				
				local attached, frontloaderAttached = viSetGet:getAttached(vehicle, {}, false, true);
				local hasAttached = attached ~= nil and #attached > 0;
				local hasFrontloader = false;
				local isFrontloader = false;
				local isFrontloaderAttached = false;
				
				function setFrontloader()					
					hasFrontloader = vehicle.configurations ~= nil and vehicle.configurations.frontloader ~= nil;
					isFrontloader = hasFrontloader and vehicle.configurations.frontloader > 1;				
					isFrontloaderAttached = isFrontloader and frontloaderAttached;
				end;
				if vehicle.viTypIcon ~= nil and (vehicle.viTypIcon == "tractor" or vehicle.viTypIcon == "tractor_other" or vehicle.viTypIcon == "tractor_frontloader") then setFrontloader();end;
				local viewTyp = box.ownTable.viewTyp[vehicle.viTypIcon];
				if viewTyp == nil then viewTyp = box.ownTable.viewTyp["miscvehicles"];end;
				if isFrontloaderAttached then viewTyp = box.ownTable.viewTyp["tractor_frontloader"];end;
				viewTyp[4].total = viewTyp[4].total+1;
				local ownerFarmId = playerFarmId == vehicle.ownerFarmId;
				local viewTable = viewTyp[4].viewVehicles;
				if not ownerFarmId then viewTable = viewTyp[4].viewContractorVehicles;end;
				
				if viewTyp[1] > 1 then					
					viewTable[#viewTable+1] = { ownerFarmId=ownerFarmId, node=vehicles[v], vehicleName=viSetGet:getVehicleName(vehicles[v], box.ownTable.view["vehicleName"], vehicle.spec_rideable ~= nil, vehicle.trainSystem ~= nil), isMarked=vehicle.viIsMarked, sortType="number", sortBy=0 };
					
					viewTable[#viewTable].hasEngine = vehicle.spec_motorized ~= nil and vehicle.spec_motorized.motorizedNode ~= nil and vehicle.spec_rideable == nil;
					viewTable[#viewTable].isEngine = viewTable[#viewTable].hasEngine and vehicle:getIsMotorStarted();
					
					viewTable[#viewTable].isTrain = vehicle.trainSystem ~= nil;
					viewTable[#viewTable].isHorse = vehicle.spec_rideable ~= nil;
					
					if boxValues.view.damageIcon[1] > 1 and vehicle.getDamageAmount ~= nil then
						local isDamage, dPercent = viSetGet:getDamage(vehicle, boxValues);
						viewTable[#viewTable].damageInfo = {isDamage, tonumber(dPercent)};
					end;
					if boxValues.view.fuelIcon[1] > 1 and viewTable[#viewTable].hasEngine then
						local isFuelEmpty, fPercent, fuelType = viSetGet:getFuel(vehicle, boxValues);
						viewTable[#viewTable].fuelInfo = {isFuelEmpty, tonumber(fPercent), fuelType};
					end;
					local missionsLeasing = vehicle.viMissionsLeasingField ~= nil and vehicle.viMissionsLeasingField >= 0;
					viewTable[#viewTable].isLeasing = vehicle.propertyState == 3 or vehicle.propertyState == 4 or missionsLeasing;
					viewTable[#viewTable].isMissionLeasing = vehicle.propertyState == 4 or missionsLeasing;
					
					local vmIsGroup, vmViewGroup = false,false;
					if g_currentMission.hlUtils.modLoaded["FS25_VehicleManagerDisplay"] ~= nil then
						if g_currentMission.hlHudSystem.ownData.hiddenMods ~= nil and g_currentMission.hlHudSystem.ownData.hiddenMods["VehicleManager"] ~= nil and not g_currentMission.hlHudSystem.ownData.hiddenMods["VehicleManager"].isHidden then 
							vmIsGroup, vmViewGroup = g_currentMission.hlUtils.globalFunction["FS25_VehicleManagerDisplay"].isViewVehicleGroup( {vehicle=vehicle} );
						end;
					end;
					viewTable[#viewTable].vmIsGroup = vmIsGroup;
					viewTable[#viewTable].vmViewGroup = vmViewGroup;
				
					local controlledName, isOtherPlayer, isPlayer = "", false, false, false;
					local isControlled = vehicle.getIsControlled ~= nil and vehicle.getIsControlled(vehicle); --straw harvest pack fix
					if isControlled then
						controlledName, isOtherPlayer = viSetGet:getPlayerName(vehicle);
						isPlayer = controlledName:len() > 0 and isOtherPlayer == false;									
					end;
					viewTable[#viewTable].controlledName = controlledName;				
					viewTable[#viewTable].isPlayer = isPlayer;
					viewTable[#viewTable].isOtherPlayer = isOtherPlayer;
					viewTable[#viewTable].isHelper = viSetGet:isHelper(vehicle);
					viewTable[#viewTable].hasAttached = hasAttached;
					if hasAttached and vehicle.trainSystem == nil and vehicle.spec_rideable == nil then
						viewTable[#viewTable].attached = attached;
					end;
					viewTable[#viewTable].hasFrontloader = hasFrontloader;
					viewTable[#viewTable].isFrontloader = isFrontloader;
					viewTable[#viewTable].frontloaderAttached = isFrontloaderAttached;
				end;
			end;
		end;	
	end;
	local addTables = {};		
	if (g_currentMission.missionDynamicInfo.isMultiplayer and boxValues.view.contractor[1] ~= 3) or not g_currentMission.missionDynamicInfo.isMultiplayer then
		for i=1, #boxValues.typIcon do
			local typName = boxValues.typIcon[i].name;
			if boxValues.viewTyp[typName] ~= nil then
				local value = boxValues.viewTyp[typName];
				if value[4].viewVehicles ~= nil and #value[4].viewVehicles > 0 then
					table.foreach(value[4].viewVehicles, function(k, v) table.insert(addTables, v) end);
				end;
				if g_currentMission.missionDynamicInfo.isMultiplayer and value[4].viewContractorVehicles ~= nil and #value[4].viewContractorVehicles > 0 and boxValues.view.contractor[1] > 1 then
					table.foreach(value[4].viewContractorVehicles, function(k, v) table.insert(addTables, v) end);				
				end;
			end;
		end;		
	elseif g_currentMission.missionDynamicInfo.isMultiplayer and boxValues.view.contractor[1] == 3 then
		for i=1, #boxValues.typIcon do
			local typName = boxValues.typIcon[i].name;
			if boxValues.viewTyp[typName] ~= nil then
				local value = boxValues.viewTyp[typName];
				if value[4].viewContractorVehicles ~= nil and #value[4].viewContractorVehicles > 0 then
					table.foreach(value[4].viewContractorVehicles, function(k, v) table.insert(addTables, v) end);
				else
					value[4].total = 0;
				end;
			end;
		end;		
	end;	
	VehicleInspector_DisplaySetGet.viewVehiclesAllInBox = addTables;
end;

function VehicleInspector_DisplaySetGet:generateBounds(box)
	if box ~= nil and box.ownTable.bounds ~= nil then
		box.ownTable.bounds[1] = 1;
		box.ownTable.bounds[2] = box.ownTable.maxIconWidth or 1;
		box.ownTable.bounds[3] = box.ownTable.bounds[2];
	end;
end;

function VehicleInspector_DisplaySetGet:resetBounds(box)
	if box ~= nil and box.ownTable.bounds ~= nil then		
		box.ownTable.bounds = {-1,0,0,box.ownTable.viewTyp.isOpen[2]};
	end;
end;

function VehicleInspector_DisplaySetGet:setBounds(box, left, right)
	if box ~= nil and box.ownTable.bounds ~= nil then		
		local bounds = box.ownTable.bounds;
		if bounds[4] <= 0 or bounds[3] >= bounds[4] or bounds[1] == 0 then return;end;
		if left ~= nil and left then
			if bounds[1]-1 <= 0 then return;end;
			bounds[1] = bounds[1]-1;
			bounds[2] = bounds[2]-1;
		elseif right ~= nil and right then		
			if bounds[2]+1 > bounds[4] then return;end;
			bounds[1] = bounds[1]+1;
			bounds[2] = bounds[2]+1;
		end;
	end;
end;

function VehicleInspector_DisplaySetGet:setAllViewTypIcons(box, state)
	if box ~= nil then
		for key, value in pairs (box.ownTable.viewTyp) do
			if key ~= "isOpen" then				
				value[1] = state;
			end;
		end;	
	end;
end;

function VehicleInspector_DisplaySetGet:setTotalViewTypIcons(box, state, total)
	if box ~= nil and total ~= nil then
		for key, value in pairs (box.ownTable.viewTyp) do
			if key ~= "isOpen" then				
				if total > 0 then
					if value[4].total > 0 then 
						if state then
							value[1] = 2;
						else
							value[1] = 1;
						end;
					else
						if state then
							value[1] = 1;
						else
							value[1] = 2;
						end;
					end;	
				else
					if value[4].total <= 0 then 
						if state then
							value[1] = 1;
						else
							value[1] = 2;
						end;
					else
						if state then
							value[1] = 2;
						else
							value[1] = 1;
						end;
					end;
				end;								
			end;
		end;	
	end;
end;

function VehicleInspector_DisplaySetGet:sellFrameVehicle(nodeId, attached)
	if nodeId ~= nil then
		local vehicle = g_currentMission.nodeToObject[nodeId];
		if vehicle ~= nil then
			local item = g_storeManager:getItemByXMLFilename(vehicle.configFileName);
			g_shopController:sell(item, vehicle);
		end;
	end;
end;

function VehicleInspector_DisplaySetGet:sellFrameVehicleWorkshop(vehicleNode) --by Giants
	local vehicle = g_currentMission.nodeToObject[vehicleNode];
	if vehicle ~= nil and vehicle.trainSystem == nil and vehicle.spec_rideable == nil and vehicle.propertyState < 4 and vehicle:getShowInVehiclesOverview()then
		local vehicles = {};
		for _, subVehicle in ipairs(vehicle.rootVehicle:getChildVehicles()) do
			if subVehicle.trainSystem == nil and subVehicle.spec_rideable == nil and subVehicle:getShowInVehiclesOverview() then
				table.addElement(vehicles, subVehicle);
			end;
		end;
		table.sort(vehicles, function (a, b)
			return a.rootNode < b.rootNode
		end)
		g_workshopScreen:setSellingPoint(nil, false, false, false);
		g_workshopScreen:setVehicles(vehicles);
		g_workshopScreen.list:setSelectedIndex(table.find(vehicles, vehicle));
		g_gui:showGui("WorkshopScreen");
	end;
end;

function VehicleInspector_DisplaySetGet:showInGameMenuFrame(frame, page, nodeId, attached, global, change, forceMouse, controlled)	
	if frame == nil or g_gui.frames[frame] == nil or change > 1 then return;end;
	local change = change or 0;
	function setForceMouse()		
		g_currentMission.hlUtils.mouseOnOff(false, false); --force mouseOff			
	end;
	if frame == "ingameMenuGameStats" then		
		if (global ~= nil and global) or page == nil then
			if forceMouse == nil or forceMouse then setForceMouse();end; --force mouseOff
			local show = g_gui:showGui("InGameMenu");			
			local pageId = show.parent.pagingElement:getPageIdByElement(show.parent.pageStatistics);
			local pageIndex = show.parent.pagingElement:getPageMappingIndex(pageId);
			show.parent.pageSelector:setState(pageIndex, true);				
		else
			if page ~= nil then
				local frameVehicles = {};
				function setFrameVehicles()
					local vehicleStatisticMarker = g_currentMission.hlUtils.modLoaded["FS25_VehicleStatisticMarker"] ~= nil;
					local allRoundExtension = g_currentMission.hlUtils.modLoaded["FS25_AllRoundExtension"] ~= nil and g_currentMission.hlUtils.globalFunction["FS25_AllRoundExtension"].setFrameVehicles ~= nil;
					if vehicleStatisticMarker or allRoundExtensionand then 					
						frameVehicles[nodeId] = true;
						if attached ~= nil then
							for a=1, #attached do
								if attached[a] ~= nil then frameVehicles[attached[a].rootNode] = false;end;
							end;
						end;
						if vehicleStatisticMarker then g_currentMission.hlUtils.globalFunction["FS25_VehicleStatisticMarker"].setFrameVehicles(frameVehicles);
						elseif allRoundExtension then g_currentMission.hlUtils.globalFunction["FS25_AllRoundExtension"].setFrameVehicles(frameVehicles);end;
					end;
				end;
				if nodeId ~= nil and not g_currentMission.hlUtils.isControlledVehicle() then setFrameVehicles();end;
				if forceMouse == nil or forceMouse then setForceMouse();end; --force mouseOff				
				local show = g_gui:showGui("InGameMenu");				
				local pageId = show.parent.pagingElement:getPageIdByElement(show.parent.pageStatistics);
				local pageIndex = show.parent.pagingElement:getPageMappingIndex(pageId);					
				
				show.parent.pageSelector:setState(pageIndex, true);					
								
				local pageElement = show.parent.pagingElement:getPageById(pageId);
				
				if page == "SUB_CATEGORY.VEHICLE_OVERVIEW" then
					InGameMenuStatisticsFrame.onClickVehicleOverview(pageElement.element);					
					function searchVehicle()
						for v=1, #pageElement.element.vehicles do
							if pageElement.element.vehicles[v] ~= nil then
								if pageElement.element.vehicles[v].vehicle.rootNode == nodeId then
									return 1,v;								
								end;								
							end;												
						end;
						return 1,0;
					end;
					if nodeId ~= nil and #pageElement.element.vehicles > 0 then --and not VehicleInspector.otherMods.vehicleStatisticMarker and not VehicleInspector.otherMods.allRoundExtension then						
						local selectIndex, selectItem = searchVehicle();						
						if selectItem ~= 0 then 										
							pageElement.element.vehiclesList:setSelectedItem(selectIndex, selectItem);
							InGameMenuStatisticsFrame.onListSelectionChanged(pageElement.element, pageElement.element.vehiclesList, nil, selectItem);							
						end;					
					end;				
				end;					
			elseif change == 0 then
				VehicleInspector_DisplaySetGet:showInGameMenuFrame(frame, page, nodeId, attached, true, change+1, forceMouse)
			end;
		end;
	end;	
end;

function VehicleInspector_DisplaySetGet:getTypIcon(args)
	if args == nil then return;end;
	if args.typIcon ~= nil then
		local box = g_currentMission.hlHudSystem.hlBox:getData("VehicleInspector_Display_Box");
		if box == nil then return;end;
		local overlayDefaultGroup = box.overlays.icons["defaultIcons"]["box"];
		local overlayDefaultByName = box.overlays.icons.byName["defaultIcons"]["box"];
		if overlayDefaultGroup == nil or overlayDefaultByName == nil then return;end;
		local overlay = overlayDefaultGroup[overlayDefaultByName[args.typIcon]];
		if overlay == nil then overlay = overlayDefaultGroup[overlayDefaultByName["other"]];end;
		return overlay;
	end;
	return;
end;

function VehicleInspector_DisplaySetGet:getShowColors(args)
	if args == nil or args.showColors == nil then return;end;
	local box = g_currentMission.hlHudSystem.hlBox:getData("VehicleInspector_Display_Box"); --search Box
	if box == nil then return nil;end;
	return box.ownTable.showColors[args.showColors];
end;

function VehicleInspector_DisplaySetGet:setGlobalFunctions()
	g_currentMission.hlUtils.globalFunction["FS25_VehicleInspector"] = {
		getTypIcon = function(args)return VehicleInspector_DisplaySetGet:getTypIcon(args);end;
		setVehiclesPreviewData = function(args) VehicleInspector_DrawPreviewData:setVehiclesOpen(args, true);end;
		getShowColors = function(args) return VehicleInspector_DisplaySetGet:getShowColors(args);end;
	};	
end;