VehicleInspector_DrawPreviewData = {};

function VehicleInspector_DrawPreviewData:setVehiclesOpen(vehicleData, externMod)
	if VehicleInspector.loadError or VehicleInspector.values.showMenue then return;end;
	if vehicleData ~= nil and vehicleData.node ~= nil and (VehicleInspector.values.previewData.vehicles.view[1] > 1 or (externMod ~= nil and externMod)) then 
		VehicleInspector.values.previewData.vehicles.state = true;
		local overlayOwnGroup = nil;
		local overlayOwnByName = nil;
		local overlayVehiclesGroup = nil;
		local overlayVehiclesByName = nil;	
		if g_currentMission.hlUtils.overlays["LS_Vehicles"] ~= nil then
			overlayVehiclesGroup = g_currentMission.hlUtils.overlays["LS_Vehicles"]["vehicles"];
			overlayVehiclesByName = g_currentMission.hlUtils.overlays.byName["LS_Vehicles"]["vehicles"];		
		end;
		if g_currentMission.hlUtils.overlays["VehicleInspector"] ~= nil then
			overlayOwnGroup = g_currentMission.hlUtils.overlays["VehicleInspector"]["own"];
			overlayOwnByName = g_currentMission.hlUtils.overlays.byName["VehicleInspector"]["own"];
		end;
		if overlayVehiclesGroup ~= nil and overlayVehiclesByName ~= nil and overlayOwnGroup ~= nil and overlayOwnByName ~= nil and not vehicleData.isTrain and not vehicleData.isHorse and vehicleData.node > 0 then
			local vehicle = g_currentMission.nodeToObject[vehicleData.node];
			if vehicle ~= nil then
				--local tempHeight = getTextHeight(0.50, utf8Substr("Äg", 0))
				local iconWidth = g_currentMission.hlHudSystem.screen.pixelW*(40+(20*VehicleInspector.values.previewData.vehicles.iSize[1]));
				local iconHeight = g_currentMission.hlHudSystem.screen.pixelH*(40+(20*VehicleInspector.values.previewData.vehicles.iSize[1]));
				--local iconWidth, iconHeight = g_currentMission.hlHudSystem.screen:getOptiWidthHeight( {typ="text", height=tempHeight, width=tempHeight*10} );	
				
				--iconWidth = iconWidth*(VehicleInspector.values.previewData.vehicles.iSize[1]/2);
				--iconHeight = iconHeight*(VehicleInspector.values.previewData.vehicles.iSize[1]/2);
				local posX = 0.5-(iconWidth/2);
				local posY = 0.5-iconHeight;
				local nextPosY = posY;
				local nextPosX = posX;		
				local attachedIconHeight = iconHeight/2;
				local attachedIconWidth = iconWidth/2;			
				local overlay = overlayVehiclesGroup[overlayVehiclesByName[vehicle.viStoreName]];
				local groundOverlay = overlayOwnGroup[overlayOwnByName["bg"]];
				local attachedOverlay = nil;
				if overlay ~= nil and groundOverlay ~= nil then
					g_currentMission.hlUtils.setOverlay(groundOverlay, posX-0.002, posY, iconWidth+0.004, iconHeight);
					groundOverlay:render();					
					g_currentMission.hlUtils.setOverlay(overlay, posX, posY, iconWidth, iconHeight);												
					overlay:render();
					local attached, _ = viSetGet:getAttached(vehicle, {}, false, true);
					if attached ~= nil and #attached > 0 then
						nextPosY = nextPosY-attachedIconHeight-0.002;				
						local setAttachedOverlays = {};
						for o=1, #attached do
							if attached[o] ~= nil then							
								local attachedVehicle = g_currentMission:getNodeObject(attached[o].rootNode);
								if attachedVehicle ~= nil and attachedVehicle.viStoreName ~= nil then							
									table.insert(setAttachedOverlays, attachedVehicle.viStoreName);							
								end;
							end;
						end;
						if #setAttachedOverlays > 0 then
							local startPosX = posX+(iconWidth/2)-(attachedIconWidth/2*#setAttachedOverlays);
							nextPosX = startPosX;
							g_currentMission.hlUtils.setOverlay(groundOverlay, startPosX-0.002, nextPosY, attachedIconWidth*#setAttachedOverlays+0.004, attachedIconHeight);
							groundOverlay:render();
							for o=1, #setAttachedOverlays do
								attachedOverlay = overlayVehiclesGroup[overlayVehiclesByName[setAttachedOverlays[o]]];
								g_currentMission.hlUtils.setOverlay(attachedOverlay, nextPosX, nextPosY, attachedIconWidth, attachedIconHeight);												
								attachedOverlay:render();
								nextPosX = nextPosX+attachedIconWidth;
							end;
						end;
					end;
				end;
			end;		
		end;
	end;
	VehicleInspector.values.previewData.vehicles.state = false;
end;

function VehicleInspector_DrawPreviewData:setFillTypesShowInfo()	
	if viSetGet:getControlledVehicle() then VehicleInspector.values.previewData.loadedFillTypes.fillTypes = {};return;end;
	VehicleInspector.values.previewData.loadedFillTypes.state = true;
	local overlayOwnGroup = nil;
	local overlayOwnByName = nil;
	local overlayFillTypesByName
	local overlayFillTypesGroup
	if g_currentMission.hlUtils.overlays["VehicleInspector"] ~= nil then
		overlayOwnGroup = g_currentMission.hlUtils.overlays["VehicleInspector"]["own"];
		overlayOwnByName = g_currentMission.hlUtils.overlays.byName["VehicleInspector"]["own"];
	end;
	if g_currentMission.hlUtils.overlays["LS_FillTypes"] ~= nil then
		overlayFillTypesGroup = g_currentMission.hlUtils.overlays["LS_FillTypes"]["fillTypes"];
		overlayFillTypesByName = g_currentMission.hlUtils.overlays.byName["LS_FillTypes"]["fillTypes"];	
	end;
	if overlayOwnGroup ~= nil and overlayOwnByName ~= nil and overlayFillTypesGroup ~= nil and overlayFillTypesByName~= nil then
		if VehicleInspector.values.previewData.loadedFillTypes.view[1] == 2 then
			--if not VehicleInspector.values.showMenue then
				local viewMax = 90;
				local isToLarge = false;
				local height = {{1,15},{16,30},{31,45},{46,60},{61,75},{76,95}};
				local maxHeight = 1;
				local length = #VehicleInspector.values.previewData.loadedFillTypes.fillTypes;
				if length > 15 and length <= 30 then maxHeight = 2;elseif length > 30 and length <=45 then maxHeight = 3;elseif length > 45 and length <= 60 then maxHeight = 4;elseif length > 60 and length <= 75 then maxHeight = 5;elseif length > 75 and length <= viewMax then maxHeight = 5;
				elseif length > viewMax then isToLarge = true;end;		
				local iconWidth = g_currentMission.hlHudSystem.screen.pixelW*(10+(3*VehicleInspector.values.previewData.loadedFillTypes.iSize[1]));
				local iconHeight = g_currentMission.hlHudSystem.screen.pixelH*(10+(3*VehicleInspector.values.previewData.loadedFillTypes.iSize[1]));
				
				local widthDif = 0.001;
				local heightDif = 0.001;	
				local posX = 0.5;
				local posY = 0.55;
				if length > 0 then
					local groundOverlay = overlayOwnGroup[overlayOwnByName["bgRound"]];		
					local isLength = 15;
					if length < 15 then isLength = length;end;
					for h=1, maxHeight do
						posX = 0.5-(((iconWidth+widthDif)*isLength)/2);
						for f=height[h][1], height[h][2] do				
							if VehicleInspector.values.previewData.loadedFillTypes.fillTypes[f] ~= nil then
								if overlayFillTypesGroup[overlayFillTypesByName[VehicleInspector.values.previewData.loadedFillTypes.fillTypes[f]]] ~= nil then					
									local overlay = overlayFillTypesGroup[overlayFillTypesByName[VehicleInspector.values.previewData.loadedFillTypes.fillTypes[f]]];
									if overlay ~= nil then
										g_currentMission.hlUtils.setOverlay(groundOverlay, posX, posY, iconWidth, iconHeight);
										groundOverlay:render();
										g_currentMission.hlUtils.setOverlay(overlay, posX, posY, iconWidth, iconHeight);
										overlay:render();
										posX = posX+iconWidth+widthDif;
									end;			
								end;
							else
								break;
							end;
						end;			
						posY = posY+iconHeight+heightDif;
					end;		
					if isToLarge and g_currentMission.hlUtils.runsTimer("1sec", true) then
						posX = 0.5-(((iconWidth+widthDif)*15)/2);
						setTextBold(true);
						setTextColor(unpack(g_currentMission.hlUtils.getColor("ls22", true)));
						renderText(posX, posY+heightDif, 0.015, tostring("! to large !"));
						setTextColor(1, 1, 1, 1);
						setTextBold(false);
					end;		
				end;
			--end;
		elseif VehicleInspector.values.previewData.loadedFillTypes.box.iconWidth ~= nil and VehicleInspector.values.previewData.loadedFillTypes.box.orgBox ~= nil then
			local orgBox = VehicleInspector.values.previewData.loadedFillTypes.box.orgBox;
			local iconWidth = VehicleInspector.values.previewData.loadedFillTypes.box.iconWidth;
			local iconHeight = VehicleInspector.values.previewData.loadedFillTypes.box.iconHeight;
			local maxIconWidth = VehicleInspector.values.previewData.loadedFillTypes.box.maxIconWidth
			local difW = 0.001;
			local difH = 0.001;	
			------------------
			local height = VehicleInspector.values.previewData.loadedFillTypes.box.height;
			if height == nil or height == 0 then return;end;
			local x = VehicleInspector.values.previewData.loadedFillTypes.box.textX;
			local y = VehicleInspector.values.previewData.loadedFillTypes.box.posY;
			--local lineHeight = VehicleInspector.values.previewData.loadedFillTypes.box.lineHeight;
			
			local lineHeight = orgBox.lineToLineOffsetY;			
			local orgPosY = orgBox.bgTop.y + orgBox.bgTop.height + orgBox.titleOffsetY + orgBox.titleToLineOffsetY;
			local orgPosX = x;
			local posY = orgPosY;
			local posX = orgPosX;
			
			local tempLines = {};
			local linePosY = orgPosY;
			for index, line in ipairs(orgBox.lines) do
				if line.isActive then					
					if line.isWarning then
						local plusY = orgBox.warningOffsetY;
						linePosY = linePosY + math.abs(plusY);
					end;					
					table.insert(tempLines,index,{posY=linePosY,key=line.key});
				else
					table.insert(tempLines,index,{});
				end;
				linePosY = linePosY + lineHeight;
			end;
			local isBreak = false;
			local lastInt = 1;
			local int = 1;
			for l=1, #tempLines do
				if not isBreak then
					local tempLine = tempLines[l];
					if tempLine ~= nil and tempLine.posY ~= nil and tempLine.key ~= nil then						
						if tempLine.key:len() <= 1 then							
							--renderText(orgPosX, tempLine.posY, orgBox.keyTextSize, "Test 1")
							posX = orgPosX+(iconWidth*1.5);
							for a=lastInt, maxIconWidth*int do					
								if VehicleInspector.values.previewData.loadedFillTypes.fillTypes[a] ~= nil then
									if overlayFillTypesGroup[overlayFillTypesByName[VehicleInspector.values.previewData.loadedFillTypes.fillTypes[a]]] ~= nil then					
										local overlay = overlayFillTypesGroup[overlayFillTypesByName[VehicleInspector.values.previewData.loadedFillTypes.fillTypes[a]]];
										if overlay ~= nil then								
											g_currentMission.hlUtils.setOverlay(overlay, posX, tempLine.posY, iconWidth, iconHeight);
											overlay:render();
											posX = posX+iconWidth;
										end;			
									end;						
								else
									isBreak = true;
									break;
								end;					
							end;
							lastInt = lastInt+maxIconWidth;
							int = int+1;
						end;
					end;
				end;
			end;
			if new then
				--renderText(orgPosX, orgPosY, orgBox.keyTextSize, "Test")
				--renderText(orgPosX, orgPosY-lineHeight, orgBox.keyTextSize, "Test 1")
				local int = 1;
				for l=1, #VehicleInspector.values.previewData.loadedFillTypes.box.line do
					local line = VehicleInspector.values.previewData.loadedFillTypes.box.line[l];
					posY = orgPosY+(lineHeight*(line.pos+1)); --title +1 ?!?
					posX = orgPosX;
					for a=int, maxIconWidth*l do					
						if VehicleInspector.values.previewData.loadedFillTypes.fillTypes[a] ~= nil then
							if overlayFillTypesGroup[overlayFillTypesByName[VehicleInspector.values.previewData.loadedFillTypes.fillTypes[a]]] ~= nil then					
								local overlay = overlayFillTypesGroup[overlayFillTypesByName[VehicleInspector.values.previewData.loadedFillTypes.fillTypes[a]]];
								if overlay ~= nil then								
									g_currentMission.hlUtils.setOverlay(overlay, posX, posY, iconWidth, iconHeight);
									overlay:render();
									posX = posX+iconWidth;
								end;			
							end;						
						end;					
					end;
					int = int+maxIconWidth;
					posY = orgPosY;
				end;
			end;
			if old then
				local posX = x;
				local posY = y+height;
				local int = 1;
				for l=1, #VehicleInspector.values.previewData.loadedFillTypes.box.line do
					local line = VehicleInspector.values.previewData.loadedFillTypes.box.line[l];
					posY = posY-(lineHeight*(line.pos+1)); --title +1 ?!?
					posX = x;
					for a=int, maxIconWidth*l do					
						if VehicleInspector.values.previewData.loadedFillTypes.fillTypes[a] ~= nil then
							if overlayFillTypesGroup[overlayFillTypesByName[VehicleInspector.values.previewData.loadedFillTypes.fillTypes[a]]] ~= nil then					
								local overlay = overlayFillTypesGroup[overlayFillTypesByName[VehicleInspector.values.previewData.loadedFillTypes.fillTypes[a]]];
								if overlay ~= nil then								
									g_currentMission.hlUtils.setOverlay(overlay, posX, posY, iconWidth, iconHeight);
									overlay:render();
									posX = posX+iconWidth;
								end;			
							end;						
						end;					
					end;
					int = int+maxIconWidth;
					posY = y+height;
				end;
			end;
		end;		
	end;
	VehicleInspector.values.previewData.loadedFillTypes.state = false;
	VehicleInspector.values.previewData.loadedFillTypes.fillTypes = {};
end;

function VehicleInspector_DrawPreviewData:setFillTypesShowInfoAtBox(vehicle, box)
	if VehicleInspector.values.previewData.loadedFillTypes.view[1] == 3 and #VehicleInspector.values.previewData.loadedFillTypes.fillTypes > 0 and vehicle ~= nil and box ~= nil then
		VehicleInspector.values.previewData.loadedFillTypes.box.line = {}; --reset
		local difH = 0.001;
		local difW = 0.001;
		local viewMaxLines = 6; --x16 = 96, 34 Zoll
		local isToLarge = false;		
		local length = #VehicleInspector.values.previewData.loadedFillTypes.fillTypes;		
		local maxIconWidth = VehicleInspector.values.previewData.loadedFillTypes.box.maxIconWidth;		
		local maxHeight = math.ceil(length/maxIconWidth);
		if maxHeight < 1 then maxHeight = 1;end;
		isToLarge = maxHeight > viewMaxLines;
		if isToLarge then maxHeight = viewMaxLines;end;		
		local line = {};
		for h=1, maxHeight do
			VehicleInspector.values.previewData.loadedFillTypes.box.line[h] = {};
			box:addLine(" ", " ");			
			VehicleInspector.values.previewData.loadedFillTypes.box.line[h].pos = #box.lines; --box.currentLineIndex;					
		end;
		VehicleInspector.values.previewData.loadedFillTypes.box.orgBox = box;
		if isToLarge then box:addLine(g_i18n:getText("toLarge"), g_i18n:getText("ui_total").. ": " ..tostring(length), true);end;		
	end;
end;
local test = true;
function VehicleInspector_DrawPreviewData:setOpenTipSide()
	if VehicleInspector:getDetiServer() then return;end;
	if VehicleInspector.values.previewData.unloadSide.view[1] > 1 then
		if viSetGet:isControlledVehicle() then
			local vehicle = viSetGet:getControlledVehicle();
			if vehicle ~= nil and vehicle.getSelectedObject ~= nil and vehicle.spec_rideable == nil then
				local ts, txt = viSetGet:getTipSide(vehicle);
				if ts == nil or ts <= 0 then return;end;
				local vehicleSchemaData = g_currentMission.hlUtils.getVehicleSchemaData();				
				local pf25 = g_modIsLoaded["FS25_precisionFarming"] and FS25_precisionFarming ~= nil and FS25_precisionFarming.g_precisionFarming ~= nil and FS25_precisionFarming.g_precisionFarming.inputHelpDisplayExtension ~= nil and FS25_precisionFarming.g_precisionFarming.inputHelpDisplayExtension.isEnabled;				
				if vehicleSchemaData ~= nil then
					local h = vehicleSchemaData.height;
					local size = g_currentMission.hlUtils.optiHeightSize(h, tostring(txt), VehicleInspector.values.previewData.unloadSide.tSize[1]/1000)+(VehicleInspector.values.previewData.unloadSide.iSize[1]/1000);
					if VehicleInspector.values.previewData.unloadSide.pos[1] == 1 then
						setTextBold(true);
						setTextColor(unpack(g_currentMission.hlUtils.getColor(VehicleInspector.values.previewData.unloadSide.color, true)));
						if vehicleSchemaData.isVisible then									
							--renderText(g_safeFrameOffsetX, y+h, size, tostring(txt));
						else							
							local txtHeight = getTextHeight(size, tostring(txt));
							local textWidth = getTextWidth(size, tostring(" ".. txt));
							local bgLeft = VehicleInspector.values.previewData.unloadSide.overlays.bgLeft;
							local bgMiddle = VehicleInspector.values.previewData.unloadSide.overlays.bgMiddle;
							local bgRight = VehicleInspector.values.previewData.unloadSide.overlays.bgRight;							
							local pW = vehicleSchemaData.leftWidth;
							local posX = vehicleSchemaData.endPosX;
							local posY = vehicleSchemaData.posY;
							if pf25 then
								posX = vehicleSchemaData.posX;
								posY = posY+h+0.0005;								
							end;
							g_currentMission.hlUtils.setOverlay(bgLeft, posX, posY, pW, vehicleSchemaData.height);
							g_currentMission.hlUtils.setOverlay(bgMiddle, bgLeft.x+bgLeft.width, bgLeft.y, textWidth, vehicleSchemaData.height);
							g_currentMission.hlUtils.setOverlay(bgRight, bgMiddle.x+bgMiddle.width, bgLeft.y, pW, vehicleSchemaData.height);
							bgLeft:render();
							bgMiddle:render();
							bgRight:render();
							renderText(bgMiddle.x, posY+(h/2)-(txtHeight/2)+0.0005, size, tostring(txt));							
						end;
						--setTextAlignment(0);
						setTextColor(1, 1, 1, 1);
						setTextBold(false);
					end;			
				end;
			end;
		end;
	end;
end;

function VehicleInspector_DrawPreviewData:setWorkingWidth()
	if VehicleInspector:getDetiServer() then return;end;
	if viSetGet:isControlledVehicle() then
		local vehicle = viSetGet:getControlledVehicle();
		if vehicle ~= nil and vehicle.getSelectedObject ~= nil and vehicle.spec_rideable == nil then
			local aw, wTxt, txt = viSetGet:getWorkingWidth(vehicle);
			if aw <= 0 then return;end;
			local isOkay, cx, x, y, w, h, size = viSetGet:getSpeedMeterData();
			local difSize = 0.0015;			
			local difH = 0.002;
			if isOkay then
				size = size - difSize;
				local rightW = KeyboardHelper.getDisplayKeyName(275.0);
				local leftW = KeyboardHelper.getDisplayKeyName(276.0);
				local dropText = "|".. tostring(leftW).. wTxt.. tostring(rightW).. "|";
				local txtHeight = getTextHeight(size, tostring(dropText));
				local txtWidth = getTextWidth(size, tostring(dropText));
				--local txtHeight = getTextHeight(size, tostring(txt));
				--local txtWidth = getTextWidth(size, tostring(txt).. " ".. tostring(wTxt).. "m");
				--setTextAlignment(RenderText.ALIGN_CENTER);
				setTextBold(true);
				setTextColor(unpack(g_currentMission.hlUtils.getColor(VehicleInspector.values.previewData.workingWidth.color, true)));				
				renderText(cx-(txtWidth/2), y+difH, size, tostring(dropText)); --(txtHeight/2)
				--renderText(cx-(txtWidth/2), y-txtHeight, size, tostring(txt).. " ".. tostring(wTxt).. "m");
				setTextColor(1, 1, 1, 1);
				setTextBold(false);
				--setTextAlignment(0);
			end;
		end;
	end;
end;