viSetGet = {};

function viSetGet:loadOwnIcons()	
	local firstIcon, lastIcon = g_currentMission.hlUtils.insertIcons( {xmlTagName="vi_display.ownIcons64", modDir=VehicleInspector.modDir, iconFile="hlHudSystem/icons/icons.dds", xmlFile="icons_vidisplay/icons.xml", modName="VehicleInspector", groupName="own", fileFormat={64,512,1024}} );
end;

viSetGet.otherSchemaIcons = {
	beetvehicles="harvester_other", potatovehicles="harvester_other", cottonvehicles="harvester_cotton", grapevehicles="harvester_other", olivevehicles="harvester_other",cottonharvester="harvester_cotton", combinecutterfruitpreparer="harvester_other", sugarcanevehicles="harvester_sugarcane",
	conveyorbelt="implement_conveyorbelt", pickupconveyorbelt="implement_conveyorbelt", selfpropelledmower="selfpropelledmower", handtoolmower="handtoolmower", selfpropelledsprayer="selfpropelledsprayer", teleloadervehicles="teleloader", wheelloadervehicles="wheelloader", forklifts="stapler", skidsteervehicles="skidsteer",
	frontloadervehicles="wheelloader", loadervehicles="wheelloader", loadervehicle="wheelloader", forageharvesters="harvester_chaff", miscvehicles="miscvehicles"
};

function viSetGet:openCloseAdHud()
	if FS25_AutoDrive.ADInputManager ~= nil then
		local vehicle = viSetGet:getControlledVehicle(true);
		if vehicle ~= nil and vehicle.trainSystem == nil then FS25_AutoDrive.ADInputManager.onActionCall(vehicle, "ADToggleHud");end;
	end;
end;

function viSetGet:openCloseCpHud()
	local vehicle = viSetGet:getControlledVehicle(true);
	if vehicle ~= nil and vehicle.trainSystem == nil and vehicle.getCpHud ~= nil and vehicle.closeCpHud ~= nil then		
		local cpHud = vehicle:getCpHud();
		if cpHud ~= nil then
			if cpHud:getIsOpen() then					
				vehicle:closeCpHud();					
			else										
				cpHud:openClose(true);
				_G["FS25_Courseplay"].CpHud.isHudActive = true;
			end;
		end;		
	end;
end;

function viSetGet:isControlledVehicle()
	return g_localPlayer ~= nil and g_localPlayer.getCurrentVehicle ~= nil and g_localPlayer:getIsInVehicle();
end;

function viSetGet:getControlledVehicle(isControlled)
	if isControlled ~= nil and isControlled then
		if viSetGet:isControlledVehicle() then return g_localPlayer:getCurrentVehicle();end;
	else
		return g_localPlayer:getCurrentVehicle();
	end;
	return nil;
end;

function viSetGet:getVehicleTypIconBySchema(vehicle)	
	local typIcon = "tractor_other";
	if vehicle.trainSystem ~= nil then return "train";end;
	if vehicle.spec_rideable ~= nil then return "horse";end;
	if vehicle ~= nil and vehicle.schemaOverlay ~= nil then		
		local foundOtherSchema = false;
		typIcon = vehicle.schemaOverlay.schemaName;
		if typIcon == "DEFAULT_IMPLEMENT" then
			typIcon = "IMPLEMENT";
		elseif typIcon == "DEFAULT_VEHICLE" then
			typIcon = "VEHICLE";
		end;
		if typIcon == nil or not typIcon or typIcon == "" then
			typIcon = "tractor_other";
		end;
		if typIcon == "IMPLEMENT" then
			typIcon = "implement_unknown";		
		end;
		if typIcon == "MOTORBIKE" then typIcon = "bike";end;
		if typIcon == "VEHICLE" then typIcon = "tractor";end;		
		function searchSpecialSchema(int)			
			if vehicle.spec_fillUnit ~= nil and vehicle.spec_fillUnit.fillUnits ~= nil and vehicle.spec_fillUnit.fillUnits[1] ~= nil and vehicle.spec_fillUnit.fillUnits[1].fillType ~= nil then
				local fillUnit = vehicle.spec_fillUnit.fillUnits[1];
				local fillType = fillUnit.fillType;
				if fillType == FillType.UNKNOWN and table.size(fillUnit.supportedFillTypes) == 1 then
					fillType = next(fillUnit.supportedFillTypes);
				end;			
				if int == 1 and fillType == FillType.SUGARCANE then foundOtherSchema = true;typIcon = "harvester_sugarcane";	
				elseif int == 2 and fillType == FillType.CHAFF then foundOtherSchema = true;typIcon = "harvester_chaff";
				elseif int == 2 and (fillType == FillType.UNKNOWN or fillType == FillType.SILAGE_ADDITIVE) then 					
					for fillTypeS, accepts in pairs(fillUnit.supportedFillTypes) do
						if accepts then
							if fillTypeS == FillType.GRASS or fillTypeS == FillType.WOODCHIPS then
								
							elseif fillTypeS == FillType.CHAFF then 
								typIcon = "harvester_chaff";
								foundOtherSchema = true;
								break;							
							end;								
						end;
					end;										
				end;
			end;
		end;		
		if typIcon == "HARVESTER" then						
			if vehicle.typeName ~= nil then
				if vehicle.typeName:lower() == "combinecutterfruitpreparer" then searchSpecialSchema(1);elseif vehicle.typeName:lower() == "combinedrivable" then searchSpecialSchema(2);end;				
			end;
		end;			
		if not foundOtherSchema and vehicle.typeName ~= nil then if viSetGet.otherSchemaIcons[vehicle.typeName:lower()] ~= nil then typIcon = viSetGet.otherSchemaIcons[vehicle.typeName:lower()];foundOtherSchema = true;end;end;
		if not foundOtherSchema then
			local item = g_storeManager:getItemByXMLFilename(vehicle.configFileName);
			if item ~= nil and item.categoryName ~= nil then if viSetGet.otherSchemaIcons[item.categoryName:lower()] ~= nil then typIcon = viSetGet.otherSchemaIcons[item.categoryName:lower()];foundOtherSchema = true;end;end;
		end;		
	end;
	return typIcon:lower();
end;

function viSetGet:getAttached(vehicle, aTable, frontloaderAttached, implements)
	if vehicle.getAttachedImplements == nil then return aTable, frontloaderAttached;end;	
	local attachedImplements = vehicle:getAttachedImplements();
	for _, implement in pairs(attachedImplements) do
		local object = implement.object;
		if object ~= nil then			
			if object.propertyState == 4 and object.viMissionsLeasingField == nil then
				viSetGet:setMissionsVehicleFieldNumber(object);
				if object.viMissionsLeasingField == nil then object.viMissionsLeasingField = 0;end;
			end;			
			if not string.find(object.typeName, "implement") or implements then
				table.insert(aTable, {rootNode=Utils.getNoNil(object.rootNode, 0)});			
				if not frontloaderAttached and (object.typeName:lower() == "attachablefrontloader" or object.typeName:lower() == "attachablefrontloaders") then frontloaderAttached = true;end;
				viSetGet:getAttached(object, aTable, frontloaderAttached, implements);
			end;
		end;
	end;
	return aTable, frontloaderAttached;
end;

function viSetGet:setMissionsVehicleFieldNumber(vehicle)	
	if (g_server ~= nil and g_client ~= nil and g_dedicatedServer == nil) or (not g_currentMission.missionDynamicInfo.isMultiplayer) then --only mp host player or single player
		local missionsList = g_missionManager:getMissions();		
		for _, mission in ipairs(missionsList) do
			local isRunning = mission.isInMissionMap or mission.activeMissionId ~= nil;
			if isRunning and mission.spawnedVehicles and mission.vehicles ~= nil and mission.field ~= nil then			
				for v=1, #mission.vehicles do
					local mVehicle = mission.vehicles[v];
					if mVehicle ~= nil and mVehicle.rootNode ~= nil and mVehicle.rootNode == vehicle.rootNode then
						vehicle.viMissionsLeasingField = tonumber(mission.field:getName());						
					end;
				end;
				if vehicle.viMissionsLeasingField ~= nil then break;end;
			end;
		end;
	end;	
end;

function viSetGet:hasFarmContracting(playerFarmId)
	local farmId = playerFarmId or g_currentMission.hlUtils.getPlayerFarmId();
	local playerFarm = g_farmManager:getFarmById(farmId);
	if playerFarm ~= nil then
		for _, farm in ipairs(g_farmManager.farms) do
			if farm ~= nil and playerFarm:getIsContractingFor(farm.farmId) then return true;end;
		end;
	end;
	return false;
end;

function viSetGet:getFarmContractor(playerFarmId, vehicleFarmId)
	if not g_currentMission.missionDynamicInfo.isMultiplayer then return true;end;
	local vehicleFarm = g_farmManager:getFarmById(playerFarmId);
	if vehicleFarm ~= nil then
		return vehicleFarm:getIsContractingFor(vehicleFarmId); 
	end;
	return false;
end;

function viSetGet:getVehicleName(vehicleNode, values, isHorse, isTrain)
	if vehicleNode ~= nil and values[1] > 1 then
		local vehicle = g_currentMission.nodeToObject[vehicleNode];
		local driverName = nil;
		local vehicleName = nil;
		if vehicle ~= nil and not isHorse and not isTrain then
			if vehicle.getName ~= nil then
				vehicleName = vehicle:getName();		
			end;			
			if values[1] == 3 and vehicle.getFullName ~= nil then				
				vehicleName = vehicle:getFullName();
			elseif values[1] == 4 and vehicle.typeDesc ~= nil and vehicle.typeDesc:len() > 0 then 
				vehicleName = vehicle.typeDesc;
			elseif values[1] == 5 and vehicle.ad ~= nil and vehicle.ad.stateModule ~= nil then
				driverName = vehicle.ad.stateModule:getName();
			elseif values[1] == 5 and not VehicleInspector.otherMods.autoDrive and vehicle.vmControl ~= nil then
				driverName = vehicle.vmControl.driverName;			
			end;
		elseif vehicle ~= nil then
			if isHorse then	vehicleName = tostring(g_i18n:getText("fillType_horse"));elseif isTrain then vehicleName = g_i18n:getText("storeItem_train");end;
		end;
		if driverName ~= nil and driverName:len() > 0 and vehicleName ~= nil and vehicleName:len() > 0 then		
			if driverName:lower() == vehicleName:lower() then return vehicleName;else return driverName;end;
		end;		
		return vehicleName;
	end;
	return nil;
end;

function viSetGet:getVehicleSpeed(vehicleNode, hasEngine, values)
	if vehicleNode ~= nil and values[1] > 1 then
		local vehicle = g_currentMission.nodeToObject[vehicleNode];
		if vehicle ~= nil then
			local speed = Utils.getNoNil(vehicle.lastSpeed, 0)*3600;	
			if g_gameSettings:getValue('useMiles') then speed = speed*0.621371;end;	
			if hasEngine then
				if not vehicle:getIsMotorStarted() then --or (vehicle.spec_drivable ~= nil and vehicle.spec_drivable.cruiseControl ~= nil and vehicle.spec_drivable.cruiseControl.state == Drivable.CRUISECONTROL_STATE_OFF) then
					--AD Fix Speed--				
					speed = 0;				
					--AD Fix Speed--
				end;
			end;			
			return string.format("%1.0f", "".. Utils.getNoNil(speed, 0));
		end;
	end;
	return nil;
end;

function viSetGet:getVehicleSpeedControl(vehicleNode, hasTempomat)
	if vehicleNode ~= nil and hasTempomat then
		local vehicle = g_currentMission.nodeToObject[vehicleNode];
		if vehicle ~= nil then
			if vehicle.spec_drivable == nil or vehicle.spec_drivable.cruiseControl == nil or vehicle.spec_rideable ~= nil then return false;end;
			return vehicle.spec_drivable.cruiseControl.state == 1; --Drivable.CRUISECONTROL_STATE_ACTIVE;
		end;
	end;
	return false;
end;

function viSetGet:getPlayerName(vehicle)	
	if vehicle.spec_enterable ~= nil and vehicle.spec_enterable.controllerUserId ~= nil then --getControllerName 
		local user = g_currentMission.userManager:getUserByUserId(vehicle.spec_enterable.controllerUserId);
		if user ~= nil then			
			local userName = Utils.getNoNil(user:getNickname(), "P");
			return userName, userName ~= g_gameSettings.onlinePresenceName;
		end;
	end;		
	return "", false; --error	
end;

function viSetGet:isHelper(vehicle)	
	local adErrorHelper = vehicle.getIsAIActive ~= nil and vehicle:getIsAIActive(); --for AD helper Bug Version >2.0.0.5				
	return (vehicle.getCurrentHelper ~= nil and vehicle.getCurrentHelper(vehicle)) or adErrorHelper;
end;

function viSetGet:getHelperName(vehicle)
	local currentHelper = nil;
	if vehicle.getCurrentHelper ~= nil then
		currentHelper = vehicle.getCurrentHelper(vehicle);
	end;
	local helperName = "";
	if currentHelper ~= nil then helperName = Utils.getNoNil(currentHelper.name, "");end;
	return helperName;
end;

function viSetGet:getHelperType(vehicle)
	local hType = "";
	local iType = "";
	if vehicle.spec_vca ~= nil and vehicle:vcaIsActive() then hType = "-VC";iType = "H-VC";end;
	if vehicle.spec_autodrive ~= nil and vehicle.ad ~= nil then		
		if vehicle.ad.stateModule:isActive() then hType = "-AD";iType = "H-AD";end;
		--local adJob = viSetGet:adJobType(vehicle);
		--if adJob ~= nil and type(adJob) == "number" and adJob > 0 and adJob < 7 then hType = "-AD";end;
	end;
	if vehicle.cp ~= nil and vehicle.getIsCourseplayDriving ~= nil and vehicle:getIsCourseplayDriving() then hType = "-CP";iType = "H-CP";end;
	if (vehicle.aiveIsStarted ~= nil and vehicle.aiveIsStarted) or (vehicle.acTurnStage ~= nil and vehicle.acTurnStage >= 198 ) then hType = "-AI";iType = "H-AI";end;
	return hType, iType;
end;

function viSetGet:adJobType(vehicle)
	return vehicle.ad.stateModule:getMode();
end;

function viSetGet:adMode(vehicle)
	return vehicle.ad.modes[viSetGet:adJobType(vehicle)];
end;

--"AD_MODE_DRIVETO","AD_MODE_DELIVERTO","AD_MODE_PICKUPANDDELIVER","AD_MODE_LOAD","AD_MODE_UNLOAD","AD_MODE_BGA"
function viSetGet:getAdJobType(vehicle)
	local adJob = viSetGet:adJobType(vehicle);	
	if adJob ~= nil and type(adJob) == "number" then
		if adJob == 1 then return tostring(g_i18n:getText("ai_jobTitleGoto")), 1;end;
		if adJob == 2 then return tostring(g_i18n:getText("ai_jobTitleLoadAndDeliver")), 2;end;
		if adJob == 3 then return tostring(g_i18n:getText("ai_jobTitleDeliver")), 3;end;
		if adJob == 4 then return tostring(g_i18n:getText("ui_loading")), 4;end;
		if adJob == 5 then return tostring(g_i18n:getText("typeDesc_combine")).. " ".. tostring(g_i18n:getText("configuration_dischargeable")), 5;end;
		if adJob == 6 then return "BunkerSilo ".. tostring(g_i18n:getText("input_UNLOAD")), 6;end;
	end;
	return nil;
end;

function viSetGet:getJobTypeIconTxt(index, ad)
	if ad and index ~= nil then
		if index == 1 then return "FF";end;
		if index == 2 then return "LL";end;
		if index == 3 then return "LI";end;
		if index == 4 then return "LO";end;
		if index == 5 then return "AB";end;
		if index == 6 then return "BU";end;
	elseif index ~= nil then
		if index == 1 then return "FF";end;
		if index == 2 then return "FA";end;
		if index == 3 then return "CO";end;
		if index == 4 then return "LI";end;
		if index == 5 then return "LL";end;
	end;
	return "?";
end;

function viSetGet:getJobTypeData(vehicle, aTable, jobType)
	if jobType.ad then
		local jobTyp, index = viSetGet:getAdJobType(vehicle);
		if jobTyp ~= nil then
			aTable.typeIndex = index;
			aTable.typeTxt = tostring(jobTyp);
			aTable.typeIconTxt = viSetGet:getJobTypeIconTxt(index, true);
			aTable.helperTypeTxt = {viSetGet:getHelperType(vehicle)};
		else
			jobType.ad = false;
		end;
	elseif (jobType.ls or jobType.cp) and vehicle.getJob ~= nil then
		local isJob = false;
		local job = vehicle:getJob();
		if job ~= nil then
			local jobTyp = g_currentMission.aiJobTypeManager:getJobTypeByIndex(job.jobTypeIndex);
			if jobType ~= nil then
				aTable.typeIndex = job.jobTypeIndex;
				aTable.typeTxt = tostring(jobTyp.title);
				aTable.typeIconTxt = viSetGet:getJobTypeIconTxt(index, false);
				aTable.helperTypeTxt = {viSetGet:getHelperType(vehicle)};
				isJob = true;
			end;
		end;
		if not isJob then jobType.ls = false;jobType.cp = false;end;				
	end;
	return aTable;
end;

function viSetGet:getIsOnField(vehicle, values)
	local isField = false;
	local wx, wy, wz = 0,0,0;
	function getIsOnField()
		--new 1.97--
		if vehicle.steeringAxleNode ~= nil then
			wx, wy, wz = getWorldTranslation(vehicle.steeringAxleNode);
			local h = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, wx, wy, wz);
			if wy < h - 1 then
				return false;
			end;
			local isOnField, _ = FSDensityMapUtil.getFieldDataAtWorldPosition(wx, wy, wz);
			if isOnField then
				isField = true;
				return true;
			end;
		end;	
		--new 1.97--
		--old--
		if vehicle.components == nil then return false;end;
		for _, component in pairs(vehicle.components) do
			wx, wy, wz = localToWorld(component.node, getCenterOfMass(component.node));
			local h = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, wx, wy, wz);
			if wy < h - 1 then
				break;
			end;
			local isOnField, _ = FSDensityMapUtil.getFieldDataAtWorldPosition(wx, wy, wz);
			if isOnField then
				isField = true;
				return true;
			end;
		end;		
		--old--
		return false;
	end;
	if values == nil or values[1] > 1 then getIsOnField();end;
	return isField, wx, wz;
end;

function viSetGet:getFieldNumber(isField, wx, wz, values)
	local fieldNumber = 0;
	if isField and values[1] >= 3 and wx ~= 0 and wz ~= 0 then 
		if values[1] == 3 and g_currentMission.missionDynamicInfo.isMultiplayer then return 0;end;
		local farmlandId = g_farmlandManager:getFarmlandIdAtWorldPosition(wx, wz);	
		if farmlandId ~= nil then
			local foundField = false;
			for f=1, #g_fieldManager.fields do
				if foundField then break;end;
				local field = g_fieldManager.fields[f];
				if field ~= nil and field.farmland ~= nil and field.farmland.id == farmlandId then
					local fieldId = tonumber(field:getName());
					for _, point in ipairs(field:getPolygonPoints()) do --! limit setzen wenn größer als !
						local x0, _, z0 = getWorldTranslation(point);
						local distanceMax = math.max(wx,wz,x0,z0);
						local distance = MathUtil.vector2Length(wx-x0,wz-z0);
						if distance <= distanceMax then
							fieldNumber = fieldId;
							foundField = true;
							break;
						end;
					end;					
				end;
			end;			
		end;
	end;
	return fieldNumber;
end;

--Mod AD Blue--
function viSetGet:getAdBlue(vehicle, values)
	if values.viewWarnings.isAdBlueEmpty[1] == 1 then return false;end;
	if vehicle.spec_defUsage == nil or not vehicle.spec_defUsage.isDefActive then return false;end;
	if vehicle.spec_motorized == nil or vehicle.spec_motorized.motorizedNode == nil or vehicle.getConsumerFillUnitIndex == nil then return false;end;
	local defFillType = vehicle:getConsumerFillUnitIndex(FillType.DEF)
    local defLevel = vehicle:getFillUnitFillLevel(defFillType)
    local capacity = vehicle:getFillUnitCapacity(defFillType)
    if capacity == nil or capacity <= 0 or defLevel == nil then return false;end;	
	local prozent = g_currentMission.hlUtils.getProzentFillLevel(defLevel, capacity, true);
	if prozent ~= nil and tonumber(prozent) ~= nil then
		return tonumber(prozent) <= values.length.adBlueProzent[1], prozent, defFillType;
	end;
	return defLevel < 5, prozent, defFillType
end;
--Mod AD Blue--

function viSetGet:getDamage(vehicle, values)
	if values.viewWarnings.isDamage[1] == 1 or vehicle.getDamageAmount == nil then return false;end;
	local damageLevel = math.min(1, 1 - vehicle:getDamageAmount());
	if damageLevel == nil then return false;end;
	local prozent = g_currentMission.hlUtils.getProzentFillLevel(damageLevel, 1, true);
	if prozent ~= nil and tonumber(prozent) ~= nil then
		if vehicle.isBroken then return true, "100";end;		
		return tonumber(100-prozent) >= values.length.damageProzent[1], prozent;		
	end;
	return vehicle.isBroken or damageLevel < 0.1, prozent;	
end;

function viSetGet:getFuel(vehicle, values)
	if values.viewWarnings.isFuelEmpty[1] == 1 then return false;end;
	if vehicle.spec_motorized == nil or vehicle.spec_motorized.motorizedNode == nil or vehicle.getConsumerFillUnitIndex == nil then return false;end;	
	local fuelLevel, capacity, fuelType = viSetGet:getVehicleFuelLevelAndCapacity(vehicle);
	if capacity == nil or capacity <= 0 or fuelLevel == nil then return false;end;	
	local prozent = g_currentMission.hlUtils.getProzentFillLevel(fuelLevel, capacity, true);
	if prozent ~= nil and tonumber(prozent) ~= nil then
		return tonumber(prozent) <= values.length.fuelProzent[1], prozent, fuelType;
	end;
	return fuelLevel < 5, prozent, fuelType;
end;

function viSetGet:getVehicleFuelLevelAndCapacity(vehicle)
	if vehicle.spec_motorized == nil or vehicle.spec_motorized.motorizedNode == nil or vehicle.getConsumerFillUnitIndex == nil then return nil;end;
	local fuelType = FillType.DIESEL
	local fillUnitIndex = vehicle:getConsumerFillUnitIndex(fuelType);
	if fillUnitIndex == nil then
		fuelType = FillType.ELECTRICCHARGE;
		fillUnitIndex = vehicle:getConsumerFillUnitIndex(fuelType);
		if fillUnitIndex == nil then
			fuelType = FillType.METHANE;
			fillUnitIndex = vehicle:getConsumerFillUnitIndex(fuelType);			
		end;
	end;
	local fuelLevel = vehicle:getFillUnitFillLevel(fillUnitIndex);
	local capacity = vehicle:getFillUnitCapacity(fillUnitIndex);
	return fuelLevel, capacity, fuelType, fillUnitIndex;
end;

function viSetGet:getPipeState(vehicle, isJob, values)
	if vehicle.spec_pipe == nil then return false;end;
	if vehicle.viPipeTimer == nil then vehicle.viPipeTimer = 0;end;
	if not isJob then vehicle.viPipeTimer = 0;return false;end;	
	local spec = vehicle.spec_pipe;
	if spec.targetState ~= 2 and spec.numStates > 1 then vehicle.viPipeTimer = 0;return false;end;	
	local rootVehicle = vehicle.rootVehicle;
	local isTurning = rootVehicle.getAIFieldWorkerIsTurning ~= nil and rootVehicle:getAIFieldWorkerIsTurning();	
	if isTurning then vehicle.viPipeTimer = 0;return false;end;
	local trailerInTrigger = false;
	local trailer = nil;
	if spec.nearestObjectInTrigger ~= nil and spec.nearestObjectInTriggers.objectId ~= nil then
		trailer = NetworkUtil.getObject(spec.nearestObjectInTriggers.objectId);
	end;
	local invalidTrailerInTrigger = false;
	local dischargeNode = rootVehicle:getCurrentDischargeNode();
	if trailer ~= nil then
		trailerInTrigger = true;
	end;	
	if (spec.targetState == 2 or spec.numStates == 1) and trailerInTrigger then
		if spec.nearestObjectInTriggerIgnoreFillLevel then vehicle.viPipeTimer = 0;return false;end;		
		if (not isTurning and rootVehicle:getCanDischargeToObject(dischargeNode)) or vehicle.viPipeTimer > 0 then
			vehicle.viPipeTimer = vehicle.viPipeTimer+1;
			return true;
		end;		
	end;
	vehicle.viPipeTimer = 0;
	return false;
end;

function viSetGet:getCollision(vehicle, isJob, values)	
	if values[1] == 1 or not isJob then return false;end;	
	if vehicle.isBlocked then return true;end;	
	local spec = vehicle.spec_aiFieldWorker;	
	if isJob and spec ~= nil then 		
		if viSetGet:getCollisionSP(vehicle) or viSetGet:getCollisionDebug(spec) then --ls15				
			return true, nil, true;		
		end;		
	end;
	spec = vehicle.spec_aiDrivable;
	if isJob and spec ~= nil then
		if spec.isRunning then
			if spec.lastIsBlocked or (spec.stuckTime ~= nil and spec.stuckTime > 4500) then return true;end;
		end;
	end;
	return viSetGet:getCollisionOther(vehicle, isJob, spec);
end;

function viSetGet:getCollisionDebug(spec)
	if spec.debugTexts ~= nil and #spec.debugTexts > 0 then
		for a=1, #spec.debugTexts do
			if string.find(spec.debugTexts[a], "STOP due to collision") then return true;end;
		end;
	end;
	return false;
end;

function viSetGet:getCollisionOther(vehicle, isJob, spec)	
	if vehicle.viDidNotMoveTimer == nil then vehicle.viDidNotMoveTimer = 5000;vehicle.viDidNotMovePosX = 0;vehicle.viDidNotMovePosZ = 0;end;
	if vehicle.isActive and isJob then		
		local aiRootNode = vehicle.getAIRootNode and vehicle:getAIRootNode();
		if aiRootNode ~= nil then
			local x, y, z = getWorldTranslation(aiRootNode);
			if spec ~= nil and spec.isRunning then			
				local distanceToTarget = MathUtil.vector2Length(x - vehicle.viDidNotMovePosX, z - vehicle.viDidNotMovePosZ);
				if vehicle.viDidNotMoveTimer < 0 and distanceToTarget < 0.5 then				
					return true, nil, true;				
				end;			
			end;		
			if vehicle:getLastSpeed() < 0.5 then 
				vehicle.viDidNotMoveTimer = vehicle.viDidNotMoveTimer-10;
				vehicle.viDidNotMovePosX = x;vehicle.viDidNotMovePosZ = z;
			else
				vehicle.viDidNotMoveTimer = 5000;
				vehicle.viDidNotMovePosX = 0;vehicle.viDidNotMovePosZ = 0;
			end;		
			if vehicle.viDidNotMoveTimer < 0 then return true, true;end;
		end;
	else
		vehicle.viDidNotMoveTimer = 5000;
		vehicle.viDidNotMovePosX = 0;vehicle.viDidNotMovePosZ = 0;
	end;	
	return false;
end;

function viSetGet:getCollisionSP(vehicle)	
	local spec = vehicle.spec_aiFieldWorker;
	if soec ~= nil and spec.isActive and spec.driveStrategies ~= nil and #spec.driveStrategies > 0 then
		for a=1, #spec.driveStrategies do
			if spec.driveStrategies[a].lastHasCollision then return true;end;
		end;		
	end;	
	return false;
end;

function viSetGet:setFillLevelInformation(vehicle, aTable, isObject, isPipeState, values)	
	if vehicle == nil then return;end;
	local spec = vehicle.spec_fillUnit;	
	local typeName = Utils.getNoNil(vehicle.typeName, "Unknown"):lower();	
	local isFillOrObject = false;
	if spec ~= nil and spec.fillUnits ~= nil then		
		for i = 1, #spec.fillUnits do
			local fillUnit = spec.fillUnits[i];
			if fillUnit.capacity > 0 and fillUnit.showOnHud then
				local fillType = fillUnit.fillType;
				if fillType == FillType.UNKNOWN and table.size(fillUnit.supportedFillTypes) == 1 then
					fillType = next(fillUnit.supportedFillTypes);
				end;
				if fillUnit.fillTypeToDisplay ~= FillType.UNKNOWN then
					fillType = fillUnit.fillTypeToDisplay;
				end;
				local fillLevel = fillUnit.fillLevel;
				if fillUnit.fillLevelToDisplay ~= nil then
					fillLevel = fillUnit.fillLevelToDisplay;
				end;
				local capacity = fillUnit.capacity;
				if fillUnit.parentUnitOnHud ~= nil then
					if fillType == FillType.UNKNOWN then
						fillType = spec.fillUnits[fillUnit.parentUnitOnHud].fillType;
					end;
					capacity = 0;
				elseif fillUnit.childUnitOnHud ~= nil and fillType == FillType.UNKNOWN then
					fillType = spec.fillUnits[fillUnit.childUnitOnHud].fillType;
				end;
				--fillLimit--
				if fillLevel > 0 and values.view.fillLimit[1] > 1 and g_currentMission.missionInfo.trailerFillLimit and not fillUnit.ignoreFillLimit then --by VehicleFruitHud
					local fillTypeDesc = g_fillTypeManager:getFillTypeByIndex(fillType);
					if fillTypeDesc ~= nil then
						local availableComponentMass = vehicle:getAvailableComponentMass();
						local limitCapacity = (availableComponentMass/fillTypeDesc.massPerLiter)+fillLevel;
						if limitCapacity ~= nil and type(limitCapacity) == "number" and limitCapacity < capacity then
							capacity = limitCapacity;
						end;
					end;
				end;
				--fillLimit--
				--pipestate flicker text/icon--
				if fillLevel > 0 and fillType ~= FillType.UNKNOWN and values.notViewFillData[fillType] == nil then vehicle.viLastFillType = fillType;end;
				if isPipeState ~= nil and isPipeState and values.notViewFillData[fillType] == nil then					
					if fillLevel < 100 then 
						if vehicle.viLastFillType ~= nil then
							fillType = vehicle.viLastFillType;
						end;
						fillLevel = 100;						
					end;
				end;
				--pipestate flicker text/icon--							
				local maxReached = not fillUnit.ignoreFillLimit and g_currentMission.missionInfo.trailerFillLimit and vehicle.getMaxComponentMassReached ~= nil and vehicle:getMaxComponentMassReached();
				viSetGet:setFillLevel(aTable, Utils.getNoNil(vehicle.rootNode, 0), typeName, fillType, fillLevel, capacity, isObject or false, fillLevel > 0 and fillUnit.uiPrecision or 0, maxReached, values);
				isFillOrObject = true;
			end;
		end;		
	end;
	if isObject == nil or not isObject then
		if vehicle.spec_tensionBelts ~= nil then
			viSetGet:setOtherFillLevelInformation(vehicle, aTable, "tensionbelts", values);
			isFillOrObject = true;
		end;
		if vehicle.spec_treePlanter ~= nil then
			viSetGet:setOtherFillLevelInformation(vehicle, aTable, "treeplanter", values);
			isFillOrObject = true;
		end;
		if vehicle.spec_dynamicMountAttacher ~= nil then
			viSetGet:setOtherFillLevelInformation(vehicle, aTable, "mountattacher", values);
			isFillOrObject = true;
		end;
	end;
	if not isFillOrObject and vehicle.spec_enterable == nil then
		viSetGet:setTool(aTable, Utils.getNoNil(vehicle.rootNode, 0), typeName, values)
	end;
end;

function viSetGet:setOtherFillLevelInformation(vehicle, aTable, otherType, values)	
	if otherType == "tensionbelts" and vehicle.spec_tensionBelts.hasTensionBelts then
		local spec = vehicle.spec_tensionBelts;
		for _, objectData in pairs(spec.objectsToJoint) do
			local object = objectData.object;
			if object ~= nil then
				viSetGet:setFillLevelInformation(object, aTable, true, nil, values);				
			end;
		end;
	elseif otherType == "treeplanter" and vehicle.spec_treePlanter.mountedSaplingPallet then
		viSetGet:setFillLevelInformation(vehicle.spec_treePlanter.mountedSaplingPallet, aTable, false, nil, values);
	elseif otherType == "mountattacher" and vehicle.spec_dynamicMountAttacher.dynamicMountedObjects then
		local spec = vehicle.spec_dynamicMountAttacher;
		for object, _ in pairs(spec.dynamicMountedObjects) do
			if object ~= nil then
				viSetGet:setFillLevelInformation(object, aTable, true, nil, values);
			end;
		end;		
	end;
end;

function viSetGet:setTool(aTable, rootNode, typeName, values)
	if typeName == "implements" or typeName == "implement" then return;end;
	function isNodeExists(fTable)
		for n=1, #fTable do
			if fTable[n] == rootNode then return true;end;
		end;
		return false;
	end;
	local added = false;
	for j = 1, #aTable do
		local fillLevelInformation = aTable[j];
		if fillLevelInformation.rootNodes ~= nil then
			--fillLevelInformation.fillLevel = 0;
			fillLevelInformation.tool = true;
			fillLevelInformation.isSeedsOrAnd = false;	
			if not isNodeExists(fillLevelInformation.rootNodes) then table.insert(fillLevelInformation.rootNodes, rootNode);end;			
			added = true;
			break;
		end;
	end;
	if not added then
		table.insert(aTable, {
			--fillLevel = 0;
			tool = true;
			rootNodes = {rootNode};
			isSeedsOrAnd = false;	
		});
	end;
end;

function viSetGet:setFillLevel(aTable, rootNode, typeName, fillType, fillLevel, capacity, isObject, precision, maxReached, values)
	function isNodeExists(fTable)
		for n=1, #fTable do
			if fTable[n] == rootNode then return true;end;
		end;
		return false;
	end;
	local added = false;
	for j = 1, #aTable do
		local fillLevelInformation = aTable[j];
		if fillLevelInformation.fillType == fillType then
			fillLevelInformation.fillLevel = fillLevelInformation.fillLevel + fillLevel;			
			fillLevelInformation.capacity = fillLevelInformation.capacity + capacity;
			fillLevelInformation.fillProzent = viSetGet:getFillProzent(fillLevelInformation.fillLevel, fillLevelInformation.capacity, fillType, values);
			if not isNodeExists(fillLevelInformation.rootNodes) then table.insert(fillLevelInformation.rootNodes, rootNode);end;
			fillLevelInformation.precision = precision;
			fillLevelInformation.maxReached = maxReached;			
			if isObject and fillLevelInformation.numObject == nil then fillLevelInformation.numObject = 1;elseif isObject then fillLevelInformation.numObject = fillLevelInformation.numObject+1;end;
			added = true;
			break;
		end;
	end;
	if not added then
		if isObject then isObject = 1;else isObject = nil;end;
		local isSeedsOrAnd = values.invertPercentFillData[fillType] ~= nil;
		if not isSeedsOrAnd then isSeedsOrAnd = viSetGet:isInvertFill(typeName);end;
		table.insert(aTable, {
			fillType = fillType;
			fillTypeName = g_fillTypeManager:getFillTypeNameByIndex(fillType);
			fillTypeTitle = g_fillTypeManager:getFillTypeTitleByIndex(fillType);
			fillLevel = fillLevel;			
			capacity = capacity;
			fillProzent = viSetGet:getFillProzent(fillLevel, capacity, fillType, values);
			precision = precision;			
			maxReached = maxReached;
			numObject = isObject;
			typeName = typeName;
			rootNodes = {rootNode};
			isSeedsOrAnd = isSeedsOrAnd;			
		});		
	end;
end;

function viSetGet:getFillProzent(fillLevel, capacity, fillType, values)
	if values.additiveFillData[fillType] ~= nil and fillLevel == 0 then return 0;end; --empty 
	if capacity == nil or capacity == 0 then return 0;end;
	return g_currentMission.hlUtils.getProzentFillLevel(fillLevel, capacity, false);
end;

function viSetGet:isInvertFill(typeName)
	for key,value in pairs(VehicleInspector.values.searchInvert) do
		if value.. "_" == typeName.. "_" then return true;end;				
	end;
	return false;
end;

---------------------------------------------
--!!! wäre wünschenswert nicht alles bei meinem VI abzustauben, sondern sich mal selbst was einfallen zu lassen und dann auch noch so zu tun als wenn es deins wäre - Meister JTSage !!!
function viSetGet:getRemainingData(vehicle, aTable, isPlayer, jobType, values)
	local remainingTimeString = "";
	local remainingWaypointsString = "";
	local remainingWaypoints = 0;
	if jobType.ad then
		if values.view["adRemaining"][1] > 1 then			
			aTable.timeTxt, aTable.timeLarge, aTable.nSec = viSetGet:getAdRemainingTimeString(vehicle, isPlayer, values);			
			aTable.waypointsTxt, aTable.waypoints = viSetGet:getAdRemainingWaypoints(vehicle, values);			
		end;
	elseif jobType.cp then
		if values.view["cpRemaining"][1] > 1 then
			aTable.timeTxt, aTable.timeLarge, aTable.nSec = viSetGet:getCpRemainingTimeString(vehicle, isPlayer, values); --set CP aTable.nSec = nil
			aTable.waypointsTxt, aTable.waypoints = viSetGet:getCpRemainingWaypoints(vehicle, values);
		end;
	elseif jobType.ls then
	
	end;
	return aTable;
end;

function viSetGet:getAdRemainingTimeString(vehicle, isPlayer, values)
	local remainingTimeString, timeLarge, nSec = viSetGet:adRemainingTimeString(vehicle, isPlayer, values);
	if remainingTimeString ~= nil and remainingTimeString:len() > 0 then return remainingTimeString, timeLarge, nSec;end;
	return "";
end;

function viSetGet:getAdRemainingWaypoints(vehicle, values)
	local remainingWaypointsString = "";
	local waypoints = -1;
	local wp, currentWaypoint = viSetGet:adRemainingWaypoints(vehicle);
	if wp ~= nil and currentWaypoint ~= nil then
		remainingWaypointsString = viSetGet:getAdRemainingWaypointsString(wp, currentWaypoint, values);
		if remainingWaypointsString == nil then remainingWaypointsString = "";end;		
		if remainingWaypointsString:len() > 0 then waypoints = #wp-currentWaypoint;end;
	end;	
	return remainingWaypointsString, waypoints;
end;

function viSetGet:adRemainingWaypoints(vehicle)
	if vehicle.ad.drivePathModule ~= nil and vehicle.ad.drivePathModule.getWayPoints ~= nil then
		local wp, currentWaypoint = vehicle.ad.drivePathModule:getWayPoints();  
		if wp ~= nil and #wp > 0 and currentWaypoint > 0 then
			return wp, currentWaypoint;
		end;
	end;
	return nil, nil;
end;

function viSetGet:getAdRemainingWaypointsString(wp, currentWaypoint, values)		
	local waypoints = 0;
	if wp ~= nil and #wp > 0 and currentWaypoint ~= nil and currentWaypoint > 0 and #wp-currentWaypoint > 0 then 
		waypoints = #wp-currentWaypoint;
	else
		return "";
	end;		
	return tostring(waypoints).. tostring(values.viewText.remainingWaypoints);	
end;

function viSetGet:adRemainingTimeString(vehicle, isPlayer, values)
	function getFormatRemainingTime(isAdRemainingTime)
		local nHours, nMins, nSecs = g_currentMission.hlUtils.getMilliSecondsToHours(isAdRemainingTime*1000, false, false, false, true, true, true);
		if nHours == nil then return "";end;
		local txtRemainingTimeSeparator = tostring(values.viewText.remainingTimeSeparator);
		if tonumber(nHours) > 0 then return tostring(nHours).. txtRemainingTimeSeparator.. tostring(nMins).. txtRemainingTimeSeparator.. tostring(nSecs), true, nSecs;end;
		return tostring(nMins).. txtRemainingTimeSeparator.. tostring(nSecs), false, nSecs;
	end;
	function getRemainingTime(isAdRemainingTime)
		if isAdRemainingTime ~= nil and isAdRemainingTime > 0 then			
			return getFormatRemainingTime(isAdRemainingTime);		
		end;
		return "";	
	end;	
	if vehicle.ad.stateModule ~= nil then
		if g_currentMission.missionDynamicInfo.isMultiplayer then
			if g_server == nil and g_client ~= nil and g_dedicatedServer ~= nil then --MP DetiServer Client
				if isPlayer then --Player
					return getRemainingTime(vehicle.ad.stateModule:getRemainingDriveTime());
				elseif not isPlayer and vehicle.ad.stateModule.adGetRemainingDriveTime ~= nil then --KI
					return getRemainingTime(vehicle.ad.stateModule:adGetRemainingDriveTime()); 
				end;
			elseif g_server ~= nil and g_client ~= nil and g_dedicatedServer == nil then --MP HostServer Server/Client
				if isPlayer then --Player
					return getRemainingTime(vehicle.ad.stateModule:getRemainingDriveTime());
				elseif not isPlayer and vehicle.ad.stateModule.adGetRemainingDriveTime ~= nil then --KI
					return getRemainingTime(vehicle.ad.stateModule:adGetRemainingDriveTime());					
				end;
			elseif g_server == nil and g_client ~= nil and g_dedicatedServer == nil then --MP HostServer Client
				if isPlayer then --Player
					return getRemainingTime(vehicle.ad.stateModule:getRemainingDriveTime()); 
				elseif not isPlayer and vehicle.ad.stateModule.adGetRemainingDriveTime ~= nil then --KI
					return getRemainingTime(vehicle.ad.stateModule:adGetRemainingDriveTime()); 
				end;
			end;
			return "";
		else --SP Client
			if isPlayer then --Player
				return getRemainingTime(vehicle.ad.stateModule:getRemainingDriveTime());
			elseif not isPlayer and vehicle.ad.stateModule.adGetRemainingDriveTime ~= nil then --KI
				return getRemainingTime(vehicle.ad.stateModule:adGetRemainingDriveTime());				
			end;
			return "";
		end;
	end;
	return "";
end;

function viSetGet:calculateAdRemainingDriveTime(vehicle, wp, currentWaypoint)
   	local remainingDriveTime = 0;	
	if FS25_AutoDrive ~= nil and FS25_AutoDrive.ADGraphManager ~= nil and FS25_AutoDrive.ADGraphManager.getDriveTimeBetweenNodes ~= nil then
		local isOnField, _ = viSetGet:getIsOnField(vehicle);		
		if not isOnField then			
			remainingDriveTime = viSetGet:getAdDriveTimeForWaypoints(wp, currentWaypoint, math.min((vehicle.spec_motorized.motor.maxForwardSpeed * 3.6), vehicle.speedLimit));
		end;
	end;
	return remainingDriveTime;
end;

function viSetGet:getAdDriveTimeForWaypoints(wp, currentWaypoint, maxDrivingSpeed)
	local totalTime = 0;
	if wp ~= nil and currentWaypoint ~= nil and wp[currentWaypoint + 1] ~= nil and wp[currentWaypoint] ~= nil and wp[currentWaypoint - 1] == nil then
		totalTime = totalTime + FS25_AutoDrive.ADGraphManager:getDriveTimeBetweenNodes(wp[currentWaypoint].id, wp[currentWaypoint + 1].id, nil, maxDrivingSpeed, true);
		currentWaypoint = currentWaypoint + 1;
	end
	while wp ~= nil and currentWaypoint ~= nil and wp[currentWaypoint - 1] ~= nil and wp[currentWaypoint + 1] ~= nil do
		if wp[currentWaypoint] ~= nil then
			totalTime = totalTime + FS25_AutoDrive.ADGraphManager:getDriveTimeBetweenNodes(wp[currentWaypoint].id, wp[currentWaypoint + 1].id, wp[currentWaypoint - 1].id, maxDrivingSpeed, true);
		end
		currentWaypoint = currentWaypoint + 1;
	end
	return totalTime * 1.15;
end;

function viSetGet:getCpRemainingTimeString(vehicle, isPlayer, values)
	local remainingTimeString, timeLarge = viSetGet:cpRemainingTimeString(vehicle, isPlayer, values);
	if remainingTimeString ~= nil and remainingTimeString:len() > 0 then return remainingTimeString, timeLarge;end;
	return "";
end;

function viSetGet:cpRemainingTimeString(vehicle, isPlayer, values)
	if vehicle.getCpStatus ~= nil then
		local cpStatus = vehicle:getCpStatus();
		if cpStatus ~= nil and cpStatus:getIsActive() then			
			local wp, currentWaypoint = viSetGet:cpRemainingWaypoints(vehicle);			
			if wp ~= nil and currentWaypoint ~= nil then
				local otherCpRemainingTime = viSetGet:otherCpRemainingTime(vehicle, wp, currentWaypoint, values);
				if otherCpRemainingTime ~= nil and otherCpRemainingTime:len() > 0 then
					return tostring(otherCpRemainingTime), false;
				end;
			end;
			local cpRemainingTime = viSetGet:calculateCpRemainingDriveTime(vehicle);
			if cpRemainingTime ~= nil and cpRemainingTime > 0 then
				local nHours, nMins, nSecs = g_currentMission.hlUtils.getMilliSecondsToHours(cpRemainingTime*1000, false, false, false, true, true, true);
				if nHours == nil then return "";end;
				local txtRemainingTimeSeparator = tostring(values.viewText.remainingTimeSeparator);
				if tonumber(nHours) > 0 then return tostring(nHours).. txtRemainingTimeSeparator.. tostring(nMins).. txtRemainingTimeSeparator.. tostring(nSecs), true;end;
				return tostring(nMins).. txtRemainingTimeSeparator.. tostring(nSecs), false;
			end;			
		end;
	end;
	return "";
end;

function viSetGet:getCpRemainingWaypoints(vehicle, values)
	local remainingWaypointsString = "";
	local waypoints = -1;
	local wp, currentWaypoint = viSetGet:cpRemainingWaypoints(vehicle);
	if wp ~= nil and currentWaypoint ~= nil then
		remainingWaypointsString = viSetGet:getCpRemainingWaypointsString(wp, currentWaypoint, values);
		if remainingWaypointsString == nil then remainingWaypointsString = "";end;		
		if remainingWaypointsString:len() > 0 then waypoints = wp-currentWaypoint;end;
	end;
	return remainingWaypointsString, waypoints;
end;

function viSetGet:cpRemainingWaypoints(vehicle)	
	if vehicle.getCpStatus ~= nil then
		local cpStatus = vehicle:getCpStatus();
		if cpStatus ~= nil and cpStatus:getIsActive() then	
			if cpStatus.numberOfWaypoints ~= nil and cpStatus.currentWaypointIx ~= nil then				
				return Utils.getNoNil(cpStatus.numberOfWaypoints, 0), Utils.getNoNil(cpStatus.currentWaypointIx, 0);
			end;
		end;
	end;
	return nil, nil;
end;

function viSetGet:getCpRemainingWaypointsString(wp, currentWaypoint, values)		
	local waypoints = 0;
	if wp ~= nil and wp > 0 and currentWaypoint ~= nil and currentWaypoint > 0 and wp-currentWaypoint > 0 then 
		waypoints = wp-currentWaypoint;
	else
		return "";
	end;		
	return tostring(waypoints).. tostring(values.viewText.remainingWaypoints);	
end;

function viSetGet:otherCpRemainingTime(vehicle, wp, currentWaypoint, values)
	if wp == 0 then return "--".. values.viewText.remainingTimeSeparator.. "--";end;	
	if vehicle.spec_reverseDriving and vehicle.spec_reverseDriving.isReverseDriving then return "--:--";end;
	if (vehicle.getMotor and vehicle:getMotor():getGearRatio() < 0 and math.abs(vehicle.lastSpeedReal) > 0.00001) or (wp > 0 and currentWaypoint >= 0 and wp == wp+currentWaypoint) then return "--".. values.viewText.remainingTimeSeparator.. "--";end;
	if math.abs(vehicle.lastSpeedReal) < 0.0001 then		
		return "?-".. values.viewText.remainingTimeSeparator.. "-?";
	end;	
	return nil;
end;

function viSetGet:calculateCpRemainingDriveTime(vehicle)
	local remainingDriveTime = 0;	
	if FS25_Courseplay ~= nil and FS25_Courseplay.CpRemainingTime ~= nil and vehicle.getFieldWorkCourse ~= nil then			
		local cpRemainingTime = FS25_Courseplay.CpRemainingTime;
		local course = vehicle:getFieldWorkCourse();		
		if course ~= nil then			
			function getTurnPenalty(course, ix)
				if course == nil or ix == nil then 
					return 0;
				end;
				local dist, numTurns = course:getRemainingDistanceAndTurnsFrom(ix);
				return numTurns * cpRemainingTime.TURN_PENALTY;
			end;			
			function getOptiSpeed()
				if vehicle.getCpSettings ~= nil then 
					local fieldSettingSpeed = vehicle:getCpSettings().fieldWorkSpeed:getValue();
					if fieldSettingSpeed ~= nil then
						local speedLimit = vehicle:getSpeedLimit(true);
						if speedLimit == math.huge then
							return 0;
						end;				
						return MathUtil.kmhToMps(math.clamp(speedLimit, 0, fieldSettingSpeed));
					end;
				end;
				return 0;
			end;			
			function getOptimalCourseTime(course, ix)
				if course == nil or ix == nil then 
					return 0;
				end;
				local dist = course:getRemainingDistanceAndTurnsFrom(ix);
				local speed = getOptiSpeed();
				if speed == 0 then 
					return 0;
				end;
				return dist / speed;
			end;			
			function getCorrectionFactor(course, ix)
				return course ~= nil and ix ~=nil and math.max(math.exp(1-course:getProgress(ix)) * cpRemainingTime.EXP_PENALTY_REDUCTION, 1) or 0;
			end;
			function getRemainingCourseTime(course, ix)
				return math.max(0, getCorrectionFactor(course, ix) * getOptimalCourseTime(course, ix) + getTurnPenalty(course, ix));
			end;			
			local cpTime = getRemainingCourseTime(course, course:getCurrentWaypointIx());			
			if cpTime ~= nil and cpTime ~= 0 then			
				remainingDriveTime = cpTime;				
			end;
			
		end;
	end;
	return remainingDriveTime;
end;
---------------------------------------------
--ls25
function viSetGet:getAvailableHeight(box, lineHeight) --auto height
	local x, y, w, h = box:getScreen();	
	local beginPosY = y+h;
	local endPosY = viSetGet:getEndPosY(box.ownTable);
	local maxHeight = 1;		
	local helpMenu = g_currentMission.hlUtils.getHelpMenuData();
	local f1PosX, f1PosY, f1Width, f1Height = helpMenu.posX, helpMenu.posY, helpMenu.lineWidth, helpMenu.totalHeight;
	f1PosY = f1PosY - f1Height;	
	--local isHelpMenu, f1PosX, f1PosY, f1Width, f1Height = viSetGet:getHelpMenueData(nil, true);
	local isIngameMap, mPosX, mPosY, mWidth, mHeight = nil,0,0,0,0;
	if box.ownTable.showBox.helpMenu[1] == 1 and box.ownTable.showBox.ingameMap[1] > 1 then isIngameMap, mPosX, mPosY, mWidth, mHeight = viSetGet:getIngameMapData(box.ownTable);end;	
	if helpMenu.isVisible and (box.ownTable.showBox.helpMenu[1] == 2 or box.ownTable.showBox.helpMenu[1] == 4) then 
		if not box.ownTable.showBox.helpMenu[4] then
			beginPosY = f1PosY;
		elseif box.ownTable.showBox.helpMenu[4] then
			beginPosY = f1PosY+f1Height;
		end;
	elseif not helpMenu.isVisible and (box.ownTable.showBox.helpMenu[1] == 3 or box.ownTable.showBox.helpMenu[1] == 4) then
		beginPosY = f1PosY;
	elseif isIngameMap ~= nil then
		if not box.ownTable.showBox.ingameMap[4] then
			beginPosY = f1PosY;
			if ingameMap then
				--endPosY = mPosY;
			end;
		end;
	end;
	maxHeight = g_currentMission.hlUtils.getMaxIconHeight(beginPosY-endPosY, lineHeight, true);
	if maxHeight < 2 then maxHeight = 2;end;
	return maxHeight;
end;

function viSetGet:getEndPosY(values)
	local alignIngameMap = values.showBox.helpMenu[1] == 1 and values.showBox.ingameMap[1] > 1;
	if (values.showBox.helpMenu[1] > 1 and not values.showBox.helpMenu[4]) or alignIngameMap then
		local ingameMap = g_currentMission.hud.ingameMap;
		local inGameMapState = g_currentMission.hlUtils.getIngameMapState();
		if ingameMap ~= nil and (inGameMapState == 2 or inGameMapState == 3) then		
			local baseX, baseY = ingameMap:getPosition();		
			local baseHeight = ingameMap:getHeight();		
			--local height = ingameMap.toggleMapSizeGlyph:getHeight()		
			local posY = baseY + baseHeight + getTextHeight(0.017, "Äg"); -- + ingameMap.toggleSizeGlyphOffsetY;			
			if not alignIngameMap or (alignIngameMap and not values.showBox.ingameMap[4]) then return posY;end;
		end;
	end;	
	return 0.005;
end;

function viSetGet:getIngameMapData(values)
	local ingameMap = g_currentMission.hud.ingameMap;
	local inGameMapState = g_currentMission.hlUtils.getIngameMapState();
	local baseX, baseY = ingameMap:getPosition();
	local offX, offY = getNormalizedScreenValues(unpack(IngameMap.POSITION.INPUT_ICON));
	baseX = baseX + offX;
	local widthM, heightM = ingameMap.layout:getMapSize();
	local baseHeight = ingameMap:getHeight();
	local baseWidth = ingameMap:getWidth();
	local inputHelpDisplay = g_currentMission.hud.inputHelp;
	if inGameMapState == 2 or inGameMapState == 3 then		
		local iconWidth = (values.iconWidth*1.3)/2;
		local height = ingameMap.toggleMapSizeGlyph:getHeight();
		local posY = baseY + baseHeight + getTextHeight(0.017, "Äg"); -- + ingameMap.toggleSizeGlyphOffsetY;			
		if values.showBox.ingameMap[4] then
			if values.view.vehicleName[1] > 1 then
				return true, baseX, baseY + baseHeight + (height/2), baseWidth+(inputHelpDisplay.textOffsetX*0.5), baseHeight;
			else
				return true, baseX, baseY + baseHeight + (height/2), baseWidth+(inputHelpDisplay.textOffsetX*0.5)+iconWidth, baseHeight;
			end;
		else
			return true, baseX, posY, baseWidth, baseHeight;
		end;
	elseif inGameMapState == 4 then --large
		return nil;
	end;
	return false, baseX, baseY, baseWidth, baseHeight;
end;
local test = true;
function viSetGet:getWorkingWidth(vehicle)
	local selectObject = vehicle:getSelectedObject();
	local txt = tostring(g_i18n:getText("configuration_workingWidth")).. ":";
	local areaWidth = 0;
	if selectObject ~= nil and selectObject.vehicle ~= nil and selectObject.vehicle.spec_workArea ~= nil then
		local workAreas = selectObject.vehicle.spec_workArea.workAreas;
		if old then
			if workAreas ~= nil then
				local hasVarUsage = selectObject.vehicle.getVariableWorkWidthUsage ~= nil;
				if hasVarUsage then hasVarUsage = selectObject.vehicle:getVariableWorkWidthUsage();end;
				local workWidth = 0;
				if hasVarUsage == nil or not hasVarUsage then
					for _, workArea in pairs(workAreas) do
						local w1, _, _ = localToLocal(selectObject.vehicle.components[1].node, workArea.start, 0, 0, 0)
						local w2, _, _ = localToLocal(selectObject.vehicle.components[1].node, workArea.width, 0, 0, 0)
						local w3, _, _ = localToLocal(selectObject.vehicle.components[1].node, workArea.height, 0, 0, 0)
						local ww = math.max(w1, w2, w3) - math.min(w1, w2, w3);
						workWidth = workWidth + ww;
					end;				
				else
					workWidth = MathUtil.round(hasVarUsage);		
				end;
				areaWidth = tonumber(workWidth);
			end;
		end;
		--if old then
			if workAreas ~= nil then
				for _, workArea in pairs(workAreas) do				
					--if workArea.functionName ~= nil then
					--if g_workAreaTypeManager:getWorkAreaTypeIsAIArea(workArea.type) then					
						local w1, _, _ = localToLocal(selectObject.vehicle.components[1].node, workArea.start, 0, 0, 0)
						local w2, _, _ = localToLocal(selectObject.vehicle.components[1].node, workArea.width, 0, 0, 0)
						local w3, _, _ = localToLocal(selectObject.vehicle.components[1].node, workArea.height, 0, 0, 0)
						workWidth = math.max(w1, w2, w3) - math.min(w1, w2, w3);
						
						
						--local workWidth = workArea.workWidth;
						--local ww = workArea.workWidth * workArea.testAreaWidthScale;
						--workWidth = workWidth * workArea.testAreaWidthScale;
						areaWidth = areaWidth + workWidth;
					--end;				
				end;
				if test then
					test = false;
					--print(DebugUtil.printTableRecursively(workAreas, "workAreas ", 0, 1))	
				end;			
			end;
			if selectObject.vehicle.spec_sprayer ~= nil and selectObject.vehicle.spec_sprayer.usageScale ~= nil then
				areaWidth = selectObject.vehicle.spec_sprayer.usageScale.workingWidth*2;
				
			end;
			--elseif selectObject.vehicle.size ~= nil and selectObject.vehicle.size.width < areaWidth then areaWidth = selectObject.vehicle.size.width;end;
		--end;
	end;
	return areaWidth, string.format("%0.1f", areaWidth);
end;

function viSetGet:getWorkingWidthOld(vehicle)
	local selectObject = vehicle:getSelectedObject();
	local txt = tostring(g_i18n:getText("configuration_workingWidth")).. ":";
	if selectObject ~= nil and selectObject.vehicle ~= nil and selectObject.vehicle.size ~= nil then		
		local width = Utils.getNoNil(selectObject.vehicle.size.width, 0);
		local activeWidth = "";
		local isWidth = 0;
		if selectObject.vehicle.spec_sprayer ~= nil and selectObject.vehicle.spec_sprayer.usageScale ~= nil then
			local isArea = selectObject.vehicle.spec_workArea ~= nil and selectObject.vehicle.spec_workArea.workAreas ~= nil and selectObject.vehicle.spec_workArea.workAreas[1] ~= nil and selectObject.vehicle.spec_workArea.workAreas[1].workWidth ~= nil;
			if isArea then isWidth = selectObject.vehicle.spec_workArea.workAreas[1].workWidth;activeWidth = "("..string.format("%0.1f", selectObject.vehicle.spec_workArea.workAreas[1].workWidth)..")";end; 
			--if selectObject.vehicle.viWorkingWidth ~= nil then 
				--width = selectObject.vehicle.viWorkingWidth;				
			--else
				width = selectObject.vehicle.spec_sprayer.usageScale.workingWidth*2;
			--end;
			if string.format("%0.1f", isWidth) == string.format("%0.1f", width) then activeWidth = "";end;
		end;
		return tonumber(width), string.format("%0.1f", width).. activeWidth, txt; 
	elseif vehicle.size ~= nil then
		local width = Utils.getNoNil(vehicle.size.width, 0);
		local activeWidth = "";
		local isWidth = 0;
		if vehicle.spec_sprayer ~= nil and vehicle.spec_sprayer.usageScale ~= nil then
			local isArea = selectObject.vehicle.spec_workArea ~= nil and selectObject.vehicle.spec_workArea.workAreas ~= nil and selectObject.vehicle.spec_workArea.workAreas[1] ~= nil and selectObject.vehicle.spec_workArea.workAreas[1].workWidth ~= nil;
			if isArea ~= nil then isWidth = selectObject.vehicle.spec_workArea.workAreas[1].workWidth;activeWidth = "("..string.format("%0.1f", selectObject.vehicle.spec_workArea.workAreas[1].workWidth)..")";end; 
			--if vehicle.viWorkingWidth ~= nil then 
			--	width = vehicle.viWorkingWidth;
			--else
				width = vehicle.spec_sprayer.usageScale.workingWidth*2;
			--end;
			if string.format("%0.1f", isWidth) == string.format("%0.1f", width) then activeWidth = "";end;
		end;
		return tonumber(width), string.format("%0.1f", width).. activeWidth, txt; 
	end;
	return 0;
end;

function viSetGet:getSpeedMeterData(bar)
	local speedMeter = g_currentMission.hud.speedMeter;
	if speedMeter ~= nil then
		if bar then return speedMeter, speedMeter:getBasePosition();end;
		local baseX, baseY = speedMeter:getPosition();
		local centerPosX = baseX + speedMeter.speedBg.width * 0.5;		
		local baseWidth = speedMeter.speedBg.width;
		local baseHeight = speedMeter.speedBg.height;				
		local size = Utils.getNoNil(speedMeter.speedUnitTextSize, 0.0115)+(VehicleInspector.values.previewData.workingWidth.iSize[1]/1000);
		local centerPosX = speedMeter.speedBgScale.x - (baseWidth/2)
		return true, centerPosX, baseX, baseY, baseWidth, baseHeight, size;
	end;
	return false;
end;

function viSetGet:getTipSide(vehicle) 
	local selectObject = vehicle:getSelectedObject();
	if selectObject ~= nil and selectObject.vehicle ~= nil then
		if selectObject.vehicle.spec_trailer ~= nil and selectObject.vehicle.spec_trailer.tipSideCount > 0 then
			local spec = selectObject.vehicle.spec_trailer;
			local txt = string.format(spec.infoText, spec.tipSides[spec.preferedTipSideIndex].name)
			return spec.preferedTipSideIndex, txt;
		end;
		--for Autoloader Script by loki_79/Achimobil
		if selectObject.vehicle.spec_universalAutoload ~= nil then
			local spec = selectObject.vehicle.spec_universalAutoload;
			if spec.isAutoloadAvailable and not spec.autoloadDisabled then
				local tipsideText = g_i18n:getText("universalAutoload_tipside", "FS25_UniversalAutoload")..": "..g_i18n:getText("universalAutoload_"..(spec.currentTipside or "none"), "FS25_UniversalAutoload");
				local unloadSide = spec.forceUnloadPosition;
				local sideTxt = g_i18n:getText("info_tipSideRight");
				local currentTipside = 1;
				if unloadeSide == "left" then currentTipside = 2;sideTxt = g_i18n:getText("info_tipSideLeft");elseif unloadeSide == "rear" or unloadeSide == "behind" then currentTipside = 3;sideTxt = g_i18n:getText("info_tipSideBack");end;
				local txt = string.format(g_i18n:getText("action_toggleTipSide"), sideTxt);
				if spec.currentTipside == "none" then currentTipside = 1;txt = g_i18n:getText("universalAutoload_tipside", "FS25_UniversalAutoload")..": "..g_i18n:getText("universalAutoload_"..(spec.currentTipside or "none"), "FS25_UniversalAutoload");end;
				return currentTipside, tipsideText;
			end;
		end;
		--for Autoloader Script by loki_79/Achimobil
	end;
	return 0;
end;

function viSetGet:getAttachedDamage(vehicle)
	local selectObject = vehicle:getSelectedObject();
	if selectObject ~= nil and selectObject.vehicle ~= nil and selectObject.vehicle ~= vehicle then
		if selectObject.vehicle.getDamageShowOnHud ~= nil and selectObject.vehicle:getDamageShowOnHud() and selectObject.vehicle.getDamageAmount ~= nil and selectObject.vehicle:getDamageAmount() ~= nil then
			local damageValue = math.min(1, 1 - selectObject.vehicle:getDamageAmount());
			return true, damageValue;
		end;
	end;
	return false;
end;

function viSetGet:getMass(vehicle)
	if vehicle.getTotalMass ~= nil then
		return vehicle:getTotalMass();
	end;
end;

function viSetGet:hasEngine(vehicle)
	return vehicle.spec_motorized ~= nil and vehicle.spec_motorized.motorizedNode ~= nil and vehicle.spec_rideable == nil;
end;

function viSetGet:getEngine(vehicle)
	return vehicle.spec_motorized ~= nil and vehicle.spec_motorized.motorizedNode ~= nil and vehicle:getIsMotorStarted() and vehicle.spec_rideable == nil;
end;

function viSetGet:getMotorState(vehicle)
	if vehicle.spec_motorized ~= nil and vehicle.spec_motorized.motorizedNode ~= nil and vehicle.spec_rideable == nil then
		return vehicle:getIsMotorStarted();
	end;
	return false;
end;

function viSetGet:loadUnlodSideOverlays() --bg for unloadeSide Text
	local r, g, b, a = unpack(HUD.COLOR.BACKGROUND)
	VehicleInspector.values.previewData.unloadSide.overlays.bgLeft = g_overlayManager:createOverlay("gui.filltypes_left", 0, 0, 0, 0);
	VehicleInspector.values.previewData.unloadSide.overlays.bgLeft:setColor(r, g, b, a);
	VehicleInspector.values.previewData.unloadSide.overlays.bgMiddle = g_overlayManager:createOverlay("gui.filltypes_middle", 0, 0, 0, 0); 
	VehicleInspector.values.previewData.unloadSide.overlays.bgMiddle:setColor(r, g, b, a);	
	VehicleInspector.values.previewData.unloadSide.overlays.bgRight = g_overlayManager:createOverlay("gui.filltypes_right", 0, 0, 0, 0);
	VehicleInspector.values.previewData.unloadSide.overlays.bgRight:setColor(r, g, b, a);
end;

function viSetGet:getCapacityShowInfo(vehicle)
	local spec = vehicle.spec_fillUnit
	if spec == nil then return 0;end;	
	local capacity = 0;
	local limitCapacity = 0;
	local isOkay, _, _, fuelType = viSetGet:getVehicleFuelLevelAndCapacity(vehicle);
	for index, fillUnit in ipairs(spec.fillUnits) do
		if fillUnit.supportedFillTypes ~= nil and fillUnit.showOnInfoHud then			
			for fillType,isAccepted in pairs(fillUnit.supportedFillTypes) do
				if isAccepted and fillType ~= nil and fillType ~= FillType.DEF and fillType ~= FillType.AIR and fillType ~= FillType.UNKNOWN and fillType ~= FillType.TARP and (isOkay == nil or fillType ~= fuelType) then
					capacity = Utils.getNoNil(fillUnit.capacity,0);break;
				end;
			end;
		end;
		--fillLimit--
		if fillUnit.fillLevel > 0 and fillUnit.capacity > 0 and (isOkay == nil or fillUnit.fillType ~= fuelType) and g_currentMission.missionInfo.trailerFillLimit and not fillUnit.ignoreFillLimit then --by VehicleFruitHud
			local fillTypeDesc = g_fillTypeManager:getFillTypeByIndex(fillUnit.fillType);
			if fillTypeDesc ~= nil then
				local availableComponentMass = vehicle:getAvailableComponentMass();
				local tempLimitCapacity = (availableComponentMass/fillTypeDesc.massPerLiter)+fillUnit.fillLevel;
				if tempLimitCapacity ~= nil and type(tempLimitCapacity) == "number" and tempLimitCapacity < fillUnit.capacity then
					limitCapacity = tempLimitCapacity;
				end;
			end;
			break;
		end;
		--fillLimit--	
	end;
	return capacity, limitCapacity;
end;

function viSetGet:getPowerShowInfo(vehicle)	
	if vehicle.spec_motorized == nil or vehicle.spec_motorized.motorizedNode == nil then return nil;end;
	local storeItem = g_storeManager:getItemByXMLFilename(vehicle.configFileName);	
	local minPower, maxPower = nil;
	local minPs = 0;
	local maxPs = 0;
	local ps = 0;
	if storeItem ~= nil then
		if storeItem.configurations ~= nil and vehicle.configurations ~= nil and vehicle.configurations.motor ~= nil and storeItem.configurations.motor ~= nil then
			local configId = vehicle.configurations.motor;
			minPower = storeItem.configurations.motor[configId].power;
			maxPower = minPower;
			if minPower == nil then
				if storeItem.specs ~= nil then
					minPower = storeItem.specs.power;
				else
					minPower = nil;
				end;
				maxPower = minPower;
			end;
			if minPower ~= nil and maxPower ~= nil then
				minPs = MathUtil.round(minPower);maxPs = MathUtil.round(maxPower);
			end;
		end;								
		if minPs == maxPs then 
			ps = maxPs;
			if storeItem.configurations ~= nil and storeItem.configurations.motor ~= nil then
				minPower, maxPower = nil;
				for configId = 1, #storeItem.configurations.motor do
					local configItem = storeItem.configurations.motor[configId];
					if configItem.power ~= nil then
						minPower = math.min(minPower or math.huge, configItem.power);
						maxPower = math.max(maxPower or 0, configItem.power);
					end
				end;
				if minPower == nil then
					if storeItem.specs ~= nil then
						minPower = storeItem.specs.power;
					else
						minPower = nil;
					end;					
					maxPower = minPower;
				end;
				if minPower ~= nil and maxPower ~= nil then
					minPs = MathUtil.round(minPower);maxPs = MathUtil.round(maxPower);
					if ps == 0 then ps = minPs;end;
				end;										
			end;
		end;
	end;
	return ps, minPower, maxPower;					
end;

function viSetGet:getFillTypesShowInfo(vehicle)	
	if vehicle == nil then return false;end;
	local spec = vehicle.spec_fillUnit
	if spec == nil then return false;end;
	local isOkay, _, _, fuelType = viSetGet:getVehicleFuelLevelAndCapacity(vehicle);
	local fillTypes = {};	
	for index, fillUnit in ipairs(spec.fillUnits) do
		if fillUnit.supportedFillTypes ~= nil and fillUnit.showOnInfoHud then			
			for fillType,isAccepted in pairs(fillUnit.supportedFillTypes) do
				if isAccepted and fillType ~= nil and fillType ~= FillType.DEF and fillType ~= FillType.AIR and fillType ~= FillType.UNKNOWN and fillType ~= FillType.TARP and (isOkay == nil or fillType ~= fuelType) then
					table.insert(fillTypes, g_fillTypeManager:getFillTypeNameByIndex(fillType));					
				end;					
			end;			
		end;		
	end;	
	return #fillTypes > 0, fillTypes;
end;

function viSetGet:getVehicleCategoryByXml(self) --Mod friends for VI
	return self.xmlFile:getValue("vehicle.storeData.viCategory#name");	
end;

function viSetGet:loadFinishedVehicles()
	if VehicleInspector:getDetiServer() then return;end;
	if self.schemaOverlay ~= nil then
		--print("##Schema: ".. tostring(self.schemaOverlay.schemaName));		
	end;
	--if self.type ~= nil and self.type.name ~= nil then print("##Type.Name: ".. tostring(self.type.name));end;
	--if self.typeName ~= nil then print("##TypeName: ".. tostring(self.typeName));end;
	if self.configFileName ~= nil then
		local vehicleTypeName = self.typeName;
		local stopLoad = vehicleTypeName == nil or string.find(vehicleTypeName:lower(), "train") or string.find(vehicleTypeName:lower(), "locomotive") or string.find(vehicleTypeName:lower(), "pallet") or string.find(vehicleTypeName:lower(), "horse"); --or string.find(vehicleTypeName:lower(), "wagon") 
		if not stopLoad then
			local storeItem = g_storeManager:getItemByXMLFilename(self.configFileName);
			if storeItem ~= nil then 
				--local category = storeItem.categoryName
				--print("##CategoryName: ".. tostring(storeItem.categoryName))
				--local categoryType = g_storeManager:getCategoryByName(storeItem.categoryName)
				--print("##CategoryType: ".. tostring(categoryType.type))
				self.viStoreName = storeItem.name;
				g_currentMission.hlUtils.loadVehicleOverlay(nil, storeItem);
			end;			
		end;
	end;
end;

function viSetGet:loadedFillTypes(vehicle)
	if VehicleInspector:getDetiServer() then return;end;
	VehicleInspector.values.previewData.loadedFillTypes.fillTypes = {};
	if vehicle ~= nil and VehicleInspector.values.previewData.loadedFillTypes.view[1] > 1 and not VehicleInspector.values.previewData.vehicles.state then
		local isOkay, fillTypes = viSetGet:getFillTypesShowInfo(vehicle);					
		if isOkay then			
			VehicleInspector.values.previewData.loadedFillTypes.fillTypes = fillTypes;						
		else
			VehicleInspector.values.previewData.loadedFillTypes.fillTypes = {};			
		end;		
	else
		VehicleInspector.values.previewData.loadedFillTypes.fillTypes = {};		
	end;
end;

function viSetGet:vehicleInfos(vehicle, box)
	if vehicle ~= nil and box ~= nil and VehicleInspector.values.previewData.vehicleInfos.view[1] > 1 then
		if vehicle.propertyState >= 3 then
			local leasingTxt = "Leasing";
			if vehicle.propertyState == 4 then 
				--local playerFarmId = g_currentMission.hlUtils.getPlayerFarmId();
				if vehicle.viMissionsLeasingField ~= nil and vehicle.viMissionsLeasingField > 0 then
					leasingTxt = "Mission Leasing -F ".. tostring(vehicle.viMissionsLeasingField);
				else
					leasingTxt = "Mission Leasing";
				end;
			end;
			box:addLine(g_i18n:getText("helpLine_IconOverview_Info"), tostring(leasingTxt));
		end;
		local capacity, limitCapacity = viSetGet:getCapacityShowInfo(vehicle);
		if capacity ~= nil and type(capacity) == "number" and capacity > 0 and capacity ~= math.huge then --? for Mod TGS Hack Error (nil and type) ?
			local capacityTxt = g_i18n:formatNumber(capacity);
			box:addLine(g_i18n:getText("shop_capacity"), tostring(capacityTxt));
			--fillLimit--
			if limitCapacity ~= nil and limitCapacity > 0 then
				local limitCapacityTxt = g_i18n:formatNumber(limitCapacity);
				box:addLine(g_i18n:getText("setting_trailerFillLimit"), tostring(limitCapacityTxt));
			end;
			--fillLimit--
		end;
		--by Achimobil--
		if not VehicleInspector.otherMods.infoDisplayExtension then
			if vehicle.getDirtAmount ~= nil then
				local dirt = vehicle:getDirtAmount();
				if dirt ~= nil and dirt > 0.01 then
					box:addLine(g_i18n:getText("groundType_dirt"), string.format("%d %%", dirt * 100))
				end;
			end;
			if vehicle.ideNeededPowerValue == nil then		
				local neededPower = PowerConsumer.loadSpecValueNeededPower(vehicle.xmlFile);						
				vehicle.ideNeededPowerValue = neededPower.base;						
				if vehicle.configurations.powerConsumer ~= nil then
					vehicle.ideNeededPowerValue = neededPower.config[vehicle.configurations.powerConsumer];
				end;						
				if vehicle.ideNeededPowerValue == nil then
					vehicle.ideNeededPowerValue = 0;
				end;
			end;
			if vehicle.ideNeededPowerValue ~= nil and vehicle.ideNeededPowerValue ~= 0 then
				local hp, kw = g_i18n:getPower(vehicle.ideNeededPowerValue);
				local neededPower = string.format(g_i18n:getText("shop_neededPowerValue"), MathUtil.round(kw), MathUtil.round(hp));
				box:addLine(g_i18n:getText("shop_neededPower"):gsub(":", ""), neededPower);
			end;
		end;
		--by Achimobil--
		local mass = viSetGet:getMass(vehicle);
		if mass ~= nil then
			local massTxt = g_i18n:formatMass(mass);
			box:addLine(g_i18n:getText("infohud_mass"), tostring(massTxt));
		end;
		local age = vehicle.age;
		if age ~= nil then					
			if age > 1 or age == 0 then
				box:addLine(g_i18n:getText("infohud_age"), tostring(age).. " ".. g_i18n:getText("ui_months"));
			else
				box:addLine(g_i18n:getText("infohud_age"), tostring(age).. " ".. g_i18n:getText("ui_month"));
			end;
		end;
		if vehicle.spec_motorized ~= nil and vehicle.spec_motorized.motorizedNode ~= nil then
			local ps, minPs, maxPs = viSetGet:getPowerShowInfo(vehicle)
			if ps ~= nil then
				local isPsTxt = string.format(g_i18n:getText("shop_maxPowerValueSingle"), ps)
				if minPs ~= nil and maxPs ~= nil and minPs ~= maxPs then
					local psTxt = string.format(g_i18n:getText("shop_maxPowerValueRange"), minPs, maxPs);
					if not VehicleInspector.otherMods.infoDisplayExtension then
						box:addLine(g_i18n:getText("configuration_motorSetup"), tostring(psTxt).. "/".. tostring(isPsTxt));
					else
						box:addLine(g_i18n:getText("configuration_motorSetup"), tostring(psTxt));
					end;
				elseif not VehicleInspector.otherMods.infoDisplayExtension then
					box:addLine(g_i18n:getText("configuration_motorSetup"), tostring(isPsTxt));
				end;					
			end;					
		end;
	end;
end;

function viSetGet:generateKeyValueBox()
	VehicleInspector.values.previewBox = g_currentMission.hud.infoDisplay:createBox(InfoDisplayKeyValueBox);
	local box = VehicleInspector.values.previewBox;		
	local difH = 0.002;
	local difW = 0.001;
	local widthArea = box.boxWidth - (box.keyOffsetX*1.5); -- - box.leftTextOffsetX - box.listMarginWidth - box.rightTextOffsetX - box.listMarginWidth + (difW*2);
	local iconWidth, iconHeight = g_currentMission.hlHudSystem.screen:getOptiWidthHeight( {typ="icon", height=box.lineHeight-difH, width=box.boxWidth} );
	VehicleInspector.values.previewData.loadedFillTypes.box.iconWidth = iconWidth;VehicleInspector.values.previewData.loadedFillTypes.box.iconHeight = iconHeight;
	VehicleInspector.values.previewData.loadedFillTypes.box.maxIconWidth = g_currentMission.hlUtils.getMaxIconWidth(widthArea, iconWidth);
	VehicleInspector.values.previewData.loadedFillTypes.box.lineHeight = box.lineHeight;
	VehicleInspector.values.previewData.loadedFillTypes.box.posX = 1 - g_safeFrameOffsetX;
	VehicleInspector.values.previewData.loadedFillTypes.box.posY = g_safeFrameOffsetY + box.titleAndBoxHeight; --(g_hudAnchorRight, g_hudAnchorBottom)
	VehicleInspector.values.previewData.loadedFillTypes.box.textX = 1 - g_safeFrameOffsetX - box.boxWidth; -- + box.keyOffsetX;
	--InfoDisplayKeyValueBox:delete(VehicleInspector.values.previewBox);
end;

function viSetGet.showVehicleInfo(self, vehicle)
	if VehicleInspector:getDetiServer() then return;end;
	if self ~= nil and self.isVehicle then 
		viSetGet:loadedFillTypes(self.object);		
		viSetGet:vehicleInfos(self.object, self.objectBox);		
		if VehicleInspector.values.previewData.loadedFillTypes.box.iconWidth ~= nil then
			VehicleInspector_DrawPreviewData:setFillTypesShowInfoAtBox(self.object, self.objectBox);
			VehicleInspector.values.previewData.loadedFillTypes.box.height = self.objectBox.bgScale.height; --self.objectBox.titleAndBoxHeight;
		end;
	else
		VehicleInspector.values.previewData.loadedFillTypes.fillTypes = {};	
	end;		
end;

function viSetGet:generateAttachedDamageBar()
	local speedMeter = g_currentMission.hud.speedMeter;	
	function createDamageBar(bar)		
		bar = ThreePartOverlay.new();
		bar:setLeftPart("gui.progressbar_left", 0, 0);
		bar:setMiddlePart("gui.progressbar_middle", 0, 0);
		bar:setRightPart("gui.progressbar_right", 0, 0);
		bar:setRotation(math.rad(90));
		local barPartWidth, barPartHeight = speedMeter:scalePixelValuesToScreenVector(6, 6);
		local barTotalWidth, _ = speedMeter:scalePixelValuesToScreenVector(130, 0);
		bar.barMaxScaleWidth = barTotalWidth-2*barPartWidth;
		bar:setLeftPart(nil, barPartWidth, barPartHeight);
		bar:setMiddlePart(nil, bar.barMaxScaleWidth, barPartHeight);
		bar:setRightPart(nil, barPartWidth, barPartHeight);
		return bar;
	end;	
	if speedMeter ~= nil then		
		local difWidth = 0.001; --see bar better		
		local width = speedMeter.repairBarScaleWidth;		
		local posX, posY = speedMeter:getPosition();		
		VehicleInspector.attachedDamageBar = createDamageBar({});		
		posX = posX + speedMeter.sectionOffsetX + speedMeter.repairOffsetX - width + difWidth;
		posY = posY + speedMeter.sectionOffsetY + speedMeter.repairOffsetY;
		VehicleInspector.attachedDamageBar:setColor(0, 0, 0, 1);
        VehicleInspector.attachedDamageBar:setMiddlePart(nil, speedMeter.barMaxScaleWidth, nil);
        VehicleInspector.attachedDamageBar:setPosition(posX + speedMeter.repairBarOffsetX, posY + speedMeter.repairBarOffsetY);		
		return true;
	end;
	return false;
end;

function viSetGet.showDamageSpeedMeterDraw(self)
	if VehicleInspector:getDetiServer() or VehicleInspector.attachedDamageBar == nil then return;end;
	if self ~= nil and VehicleInspector.values.previewData.attachedDamage.view[1] > 1 then				
		local vehicle = self.vehicle;		
		if vehicle == nil or not self.isVehicleDrawSafe then return;end;			
		if vehicle.getSelectedObject ~= nil and vehicle.spec_rideable == nil and vehicle.trainSystem == nil then			
			local damageValue = 1;
			if vehicle.getDamageAmount ~= nil and vehicle:getDamageAmount() ~= nil then									
				local vehicles = vehicle.rootVehicle.childVehicles;
				for _, subVehicle in ipairs(vehicles) do
					if subVehicle.getDamageShowOnHud ~= nil and subVehicle:getDamageShowOnHud() then
						damageValue = math.min(damageValue, 1 - subVehicle:getDamageAmount());
					end;
				end;					
				local isOkay, attachedDamage = viSetGet:getAttachedDamage(vehicle);
				if isOkay then						
					VehicleInspector.attachedDamageBar:setMiddlePart(nil, self.barMaxScaleWidth, nil);
					VehicleInspector.attachedDamageBar:setColor(0, 0, 0, 1);
					VehicleInspector.attachedDamageBar:render();
					local barColor = {1, 0.1233, 0, 1};
					if damageValue > 0.2 and attachedDamage > 0.2 then
						barColor = {0.0097, 0.4287, 0.6445, 1}; 
						damageValue = damageValue + attachedDamage; --set new value dif
						local barScale = math.clamp(self.barMaxScaleWidth * damageValue, 0, self.barMaxScaleWidth); --replace new value dif
						self.bar:setMiddlePart(nil, barScale, nil); --replace new value dif
						local attachedBarScale = math.clamp(self.barMaxScaleWidth * attachedDamage, 0, self.barMaxScaleWidth); 
						VehicleInspector.attachedDamageBar:setMiddlePart(nil, attachedBarScale, nil);					
					else
						VehicleInspector.attachedDamageBar:setMiddlePart(nil, self.barMaxScaleWidth, nil);
					end;
					VehicleInspector.attachedDamageBar:setColor(unpack(barColor));
					VehicleInspector.attachedDamageBar:render();				
				end;			
			end;		
		end;		
	end;
end;

---Autolicht automatisch anschalten bei Nacht---
function viSetGet:updateAutoLight(dt)
	if VehicleInspector:getDetiServer() then return;end;
	if VehicleInspector.values.otherData.autoLight.view[1] == 1 or VehicleInspector.otherMods.autoLight or not viSetGet:isControlledVehicle() or g_localPlayer == nil then return;end;
	function getIsLightTurnedOn(vehicle)		
		if vehicle.spec_lights.currentLightState > 0 then
			return true;
		else
			return false;
		end;
	end;	
	VehicleInspector.values.otherData.autoLight.delta = VehicleInspector.values.otherData.autoLight.delta + dt;	
	if VehicleInspector.values.otherData.autoLight.delta > VehicleInspector.values.otherData.autoLight.rate then		
		VehicleInspector.values.otherData.autoLight.delta = 0;
		if g_gui.currentGui == nil then
    		local needLights = not g_currentMission.environment.isSunOn;
			local vehicle = viSetGet:getControlledVehicle();
			if vehicle ~= nil and vehicle.spec_lights ~= nil and viSetGet:hasEngine(vehicle) then				
				if vehicle.getIsAIActive == nil or not vehicle:getIsAIActive() then
					local motorState = viSetGet:getMotorState(vehicle);
					local isLightTurnedOn = getIsLightTurnedOn(vehicle);
					if not isLightTurnedOn and needLights and motorState then						
						vehicle:setNextLightsState(vehicle.spec_lights.numLightTypes);
					end;
					if isLightTurnedOn and (not needLights or not motorState) then						
						vehicle:deactivateLights(true);
					end;
				end;					
			end;
		end;
	end;
end;
---Autolicht automatisch anschalten bei Nacht---