VehicleInspector_Display_XmlHud = {};

function VehicleInspector_Display_XmlHud:defaultValues(hud)
	hud.ownTable = {viewHudTyp=1, maxHudTyp=3};
end;

function VehicleInspector_Display_XmlHud:onLoadXml(hud, Xml, xmlNameTag)
	if hud.ownTable.viewHudTyp == nil then VehicleInspector_Display_XmlHud:defaultValues(hud);end;	
	if Xml ~= nil and xmlNameTag ~= nil then	
		if getXMLInt(Xml, xmlNameTag.."#version") ~= nil then 
						
		else
			return; --first config not found
		end;
		if getXMLInt(Xml, xmlNameTag.."#viewHudTyp") ~= nil then 
			hud.ownTable.viewHudTyp = getXMLInt(Xml, xmlNameTag.. "#viewHudTyp");
			if hud.ownTable.viewHudTyp > hud.ownTable.maxHudTyp or hud.ownTable.viewHudTyp < 1 then hud.ownTable.viewHudTyp = 1;end;
		end;			
	end;	
end;

function VehicleInspector_Display_XmlHud.onSaveXml(hud, Xml, xmlNameTag)	
	setXMLInt(Xml, xmlNameTag.."#version", VehicleInspector.metadata.xmlVersion);
	setXMLInt(Xml, xmlNameTag.."#viewHudTyp", hud.ownTable.viewHudTyp);	
end;

function VehicleInspector_Display_XmlHud:loadHud(name) 
	local hud = nil;
	if name == "VehicleInspector_Display_Hud" then
		local hud = g_currentMission.hlHudSystem.hlHud.generate( {name=name, width=40, info="VehicleInspector Mod\n(VehicleInspector)", displayName="VehicleInspectorDisplay Hud", hiddenMod="VehicleInspector", ownTable={}} );
		if hud ~= nil then			
			g_currentMission.hlUtils.loadLanguage( {modTitle=tostring(VehicleInspector.metadata.title), class=VehicleInspector.modName, modDir=VehicleInspector.modDir.. "scripte_vidisplay/", xmlDir="FS25_VehicleInspector", xmlVersion=VehicleInspector.metadata.languageVersion} );
			VehicleInspector_DisplaySetGet:loadFillTypesIcons();
			VehicleInspector_DisplaySetGet:loadHudIcons(hud);
			VehicleInspector:loadSource(3);			
			hud.onDraw = VehicleInspector_Display_DrawHud.setHud;
			hud.onClick = VehicleInspector_Display_MouseKeyEventsHud.onClick;
			hud.onSaveXml = VehicleInspector_Display_XmlHud.onSaveXml;						
			VehicleInspector_Display_XmlHud:onLoadXml(hud, hud:getXml()); --own hud load over Xml
			hud.displayName = "VehicleInspectorDisplay Hud" --fix DisplayName;
			if hud.ownTable.viewHudTyp == 3 then hud.autoZoomOutIn = "text";else hud.autoZoomOutIn = "";end; --set text zoom is ...typ 1			
			if g_currentMission.hlHudSystem.isAlreadyExistsXml("box", "VehicleInspector_Display_Box") then VehicleInspector_Display_XmlBox:loadBox("VehicleInspector_Display_Box", nil);end; --optional load
			if g_currentMission.hlHudSystem.isAlreadyExistsXml("box", "VehicleInspector_Display_AllInBox") then VehicleInspector_Display_XmlBox:loadBox("VehicleInspector_Display_AllInBox", nil);end; --optional load
			return true;
		end;
	end;
	return false;
end;
