TrailerJointBlock = {};
TrailerJointBlock.modName = g_currentModName;
TrailerJointBlock.visibleEventText = false;
TrailerJointBlock.visibleOnDraw = true;
TrailerJointBlock.color = {block="khaki",unblock="ls25active",blockUnblock="yellow"};

function TrailerJointBlock:loadIcons()	
	local _, _ = g_currentMission.hlUtils.insertIcons( {xmlTagName="vi_display.trailerJointBlock", modDir=VehicleInspector.modDir, iconFile="hlHudSystem/icons/other1Icons.dds", xmlFile="icons_vidisplay/icons.xml", modName="VehicleInspector", groupName="trailerJointBlock", fileFormat={32,256,512}} );
end;

function TrailerJointBlock.initSpecialization()
    local schemaSavegame = Vehicle.xmlSchemaSavegame;
    schemaSavegame:register(XMLValueType.BOOL, "vehicles.vehicle(?).trailerJointBlock#isBlocked", "Blocked Trailer Joint.", false);
end;

function TrailerJointBlock.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function TrailerJointBlock.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", TrailerJointBlock);
    SpecializationUtil.registerEventListener(vehicleType, "onPostLoad", TrailerJointBlock);
    SpecializationUtil.registerEventListener(vehicleType, "saveToXMLFile", TrailerJointBlock);
    SpecializationUtil.registerEventListener(vehicleType, "onUpdate", TrailerJointBlock);
    SpecializationUtil.registerEventListener(vehicleType, "onWriteStream", TrailerJointBlock);
    SpecializationUtil.registerEventListener(vehicleType, "onReadStream", TrailerJointBlock);
    SpecializationUtil.registerEventListener(vehicleType, "onRegisterActionEvents", TrailerJointBlock);
	SpecializationUtil.registerEventListener(vehicleType, "onDraw", TrailerJointBlock);
end;

function TrailerJointBlock.registerFunctions(vehicleType)
    SpecializationUtil.registerFunction(vehicleType, "toggleTrailerBlockState", TrailerJointBlock.toggleTrailerBlockState);
end;

function TrailerJointBlock:onLoad(savegame)
    local spec = self.spec_trailerJointBlock;
    spec.isValid = false;
    spec.isBlocked = false;
    spec.lastBlockedState = false;
    spec.unblockText = g_i18n:getText("VI_TRAILERUNBLOCKFRONTJOINT");
    spec.blockText = g_i18n:getText("VI_TRAILERBLOCKFRONTJOINT");
    spec.warningText = g_i18n:getText("VI_WARNINGINVALIDTRAILERPOSITION");
    if self.spec_trailer == nil or #spec.componentJoints < 2 then
        return;
    end;
    if self.isServer then        
        local rotLimit = spec.componentJoints[1].rotLimit;
        if rotLimit == nil or math.deg(rotLimit[2]) == 0 then
            return;
        end;
        spec.rotLimitBackup = {
            rotLimit[1] or 0,
            rotLimit[2] or 0,
            rotLimit[3] or 0
        };
        spec.isValid = true;
    end;
end;

function TrailerJointBlock:onPostLoad(savegame)
    local spec = self.spec_trailerJointBlock;
    if self.isServer and spec.isValid then
        if savegame ~= nil and not savegame.resetVehicles then
            spec.isBlocked = savegame.xmlFile:getValue(savegame.key.. ".trailerJointBlock#isBlocked", spec.isBlocked);
        end;
    end;
end;

function TrailerJointBlock:saveToXMLFile(xmlFile, key, usedModNames)
    local spec = self.spec_trailerJointBlock;
    if spec.isValid then
        xmlFile:setValue(key.. "#isBlocked", spec.isBlocked);
    end;
end;

function TrailerJointBlock:setVisibleEventText(onStart)
	if self.isClient then
		local spec = self.spec_trailerJointBlock;
		if spec ~= nil and spec.actionEventIds ~= nil then
			if onStart == nil then TrailerJointBlock.visibleEventText = not TrailerJointBlock.visibleEventText;end;
			for _, actionEventId in ipairs(spec.actionEventIds) do
				g_inputBinding:setActionEventTextVisibility(actionEventId, TrailerJointBlock.visibleEventText);
			end;
		end;
	end;
end;

function TrailerJointBlock:onWriteStream(streamId, connection)
    if not connection:getIsServer() then
        local spec = self.spec_trailerJointBlock;
        if streamWriteBool(streamId, spec.isValid) then
            streamWriteBool(streamId, spec.isBlocked);
        end;
    end;
end;

function TrailerJointBlock:onReadStream(streamId, connection)
    if connection:getIsServer() then
        local spec = self.spec_trailerJointBlock;
        spec.isValid = streamReadBool(streamId);
        if spec.isValid then
            spec.isBlocked = streamReadBool(streamId);
        end;
    end;
end;

function TrailerJointBlock:onUpdate(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
    local spec = self.spec_trailerJointBlock;
    if spec.isValid then
        if self.isClient then
            TrailerJointBlock.updateActionEvents(self);
        end;
        if self.isServer then
            if spec.lastBlockedState ~= spec.isBlocked then
                if spec.isBlocked then
                    self:setComponentJointRotLimit(self.componentJoints[1], 2, 0, 0);
                else
                    self:setComponentJointRotLimit(self.componentJoints[1], 2, -spec.rotLimitBackup[2], spec.rotLimitBackup[2]);
                end;
                spec.lastBlockedState = spec.isBlocked;
            end;
        end;
    end;
end;

function TrailerJointBlock:onRegisterActionEvents(isActiveForInput, isActiveForInputIgnoreSelection)
    local spec = self.spec_trailerJointBlock;
    if self.isClient and spec.isValid then
       self:clearActionEventsTable(spec.actionEvents);
       spec.actionEventIds = {};
	   if isActiveForInputIgnoreSelection then
            local _, actionEventId = self:addActionEvent(spec.actionEvents, InputAction.VI_TRAILERBLOCKFRONTJOINT, self, TrailerJointBlock.actionEventBlock, false, true, false, true, nil);
            g_inputBinding:setActionEventTextPriority(actionEventId, GS_PRIO_VERY_LOW);
            g_inputBinding:setActionEventTextVisibility(actionEventId, TrailerJointBlock.visibleEventText);
			table.insert(spec.actionEventIds, actionEventId);
			TrailerJointBlock.updateActionEvents(self);
        end;
    end;
end;

function TrailerJointBlock:updateActionEvents()
    local spec = self.spec_trailerJointBlock;
    local actionEvent = spec.actionEvents[InputAction.VI_TRAILERBLOCKFRONTJOINT];
    if actionEvent ~= nil then
        if self.isActive then
            if TrailerJointBlock.visibleEventText then
				if spec.isBlocked then g_inputBinding:setActionEventText(actionEvent.actionEventId, spec.unblockText);else g_inputBinding:setActionEventText(actionEvent.actionEventId, spec.blockText);end;
			end;			
        end;
        g_inputBinding:setActionEventActive(actionEvent.actionEventId, self.isActive);
    end;
end;

function TrailerJointBlock:toggleTrailerBlockState(isBlocked, noEventSend)
    local spec = self.spec_trailerJointBlock;
    if isBlocked ~= spec.isBlocked then
        spec.isBlocked = isBlocked;
        if self.isClient and g_dedicatedServer == nil and g_localPlayer ~= nil then
			local state = " ".. g_i18n:getText("setting_disasterDestructionState_enabled")
			if spec.isBlocked then g_currentMission.hlHudSystem.showInfoBox( {spec.blockText.. state, 2000, g_currentMission.hlUtils.getColor("ls25active", true)} );else g_currentMission.hlHudSystem.showInfoBox( {spec.unblockText.. state, 2000, g_currentMission.hlUtils.getColor("ls25active", true)} );end;
		end;
		if noEventSend == nil or noEventSend == false then
            if g_server ~= nil then
                g_server:broadcastEvent(TrailerJointBlockEvent.new(self, isBlocked), nil, nil, self);
            else
                g_client:getServerConnection():sendEvent(TrailerJointBlockEvent.new(self, isBlocked));
            end;
        end;
    end;
end;

function TrailerJointBlock.actionEventBlock(self, actionName, inputValue, callbackState, isAnalog)
    local spec = self.spec_trailerJointBlock;
    local x1, y1, z1 = getRotation(self.components[1].node);
    local x2, y2, z2 = getRotation(self.components[2].node);
    if math.abs(y1 - y2) < 0.05 then
        self:toggleTrailerBlockState(not spec.isBlocked);
    else
        if self.isClient and g_dedicatedServer == nil and g_localPlayer ~= nil then g_currentMission.hlHudSystem.showInfoBox( {spec.warningText, 2000} );end;	
    end;
end;

function TrailerJointBlock:onDraw()
	if self.isClient and g_dedicatedServer == nil and g_localPlayer ~= nil and TrailerJointBlock.visibleOnDraw then
		local spec = self.spec_trailerJointBlock;
		if spec ~= nil and self.spec_trailer ~= nil and #spec.componentJoints > 1 then		
			local overlayGroup = g_currentMission.hlUtils.overlays["VehicleInspector"]["trailerJointBlock"];
			local overlayByName = g_currentMission.hlUtils.overlays.byName["VehicleInspector"]["trailerJointBlock"];
			if overlayGroup ~= nil and overlayByName ~= nil then
				local color = TrailerJointBlock.color.unblock;
				local overlay = overlayGroup[overlayByName["axleUnblocked"]];	
				if spec.isBlocked then overlay = overlayGroup[overlayByName["axleBlocked"]];color = TrailerJointBlock.color.block;end;
				local cruiseOverlay = g_currentMission.hud.speedMeter.cruiseControl;
				if overlay ~= nil and cruiseOverlay ~= nil then					
					g_currentMission.hlUtils.setOverlay(overlay, cruiseOverlay.x-(cruiseOverlay.width*0.65), cruiseOverlay.y+(cruiseOverlay.height*0.15), cruiseOverlay.width*0.75, cruiseOverlay.height*0.75);
					g_currentMission.hlUtils.setBackgroundColor(overlay, g_currentMission.hlUtils.getColor(color, true));
					overlay:render();				
				end;
			end;
		end;
	end;
end;

--------------
-- MP event --
--------------

TrailerJointBlockEvent = {};
local TrailerJointBlockEvent_mt = Class(TrailerJointBlockEvent, Event);

InitEventClass(TrailerJointBlockEvent, "TrailerJointBlockEvent");

function TrailerJointBlockEvent.emptyNew()
    local self = Event.new(TrailerJointBlockEvent_mt);
    return self;
end;

function TrailerJointBlockEvent.new(trailer, isBlocked)
    local self = TrailerJointBlockEvent.emptyNew();
    self.trailer = trailer;
    self.trailerIsBlocked = isBlocked;
    return self;
end;

function TrailerJointBlockEvent:readStream(streamId, connection)
    self.trailer = NetworkUtil.readNodeObject(streamId);
    self.trailerIsBlocked = streamReadBool(streamId);
    self:run(connection);
end;

function TrailerJointBlockEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.trailer);
    streamWriteBool(streamId, self.trailerIsBlocked);
end

function TrailerJointBlockEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(TrailerJointBlockEvent.new(self.trailer, self.trailerIsBlocked), nil, connection, self.trailer);
    end
    if self.trailer ~= nil then
        self.trailer:toggleTrailerBlockState(self.trailerIsBlocked, true);
    end;
end;
