VehicleManager_Display = {};
VehicleManager_Display.modDir = g_currentModDirectory;
VehicleManager_Display.modName = g_currentModName;
VehicleManager_Display.settingsDir = getUserProfileAppPath().. "modSettings/HL/FS25_VehicleManagerDisplay/";

VehicleManager_Display.metadata = {
	interface = "FS25 ...", --convert ls22 to ls25
	title = "VehicleManager Display",
	notes = "Konfiguriert Fahrzeug Gruppierungen oder Automatische Abläufe und mehr (mit integrierten HL Hud System)",
	author = "(by HappyLooser)",
	version = "1.0.0.2",
	build = 36,
	xmlVersion = 1,
	languageVersion = 1,
	datum = "06.06.2024", 
	update = "13.04.2025",	
	discord = "HappyLooser Modding",
	info = " Link Freigabe,Änderungen,Kopien oder Code Benutzung ist ohne meine Zustimmung nicht erlaubt"	
};

function VehicleManager_Display:loadMap(mapName)		
	print("---loading ".. tostring(VehicleManager_Display.metadata.title).. " ".. tostring(VehicleManager_Display.metadata.version).. "(#".. tostring(VehicleManager_Display.metadata.build).. ") ".. tostring(VehicleManager_Display.metadata.author).. "---")
	if not VehicleManager_Display:getDetiServer() then		
		VehicleManager_Display:loadValues();		
	end;
end;

function VehicleManager_Display:loadValues() --for All in Mod Extra Load
	if not VehicleManager_Display:getDetiServer() then
		VehicleManager_Display.hlDebugMode = false;	--for Modder Testing			
		VehicleManager_Display.testString = {};	
		VehicleManager_Display.autoDrive = {loaded=false, startGroup={isReady=false,isActive=false,copyPasteCourse={},vehicles={}}};
		generateFolders();
		VehicleManager_Display:loadSource(1);		
		VehicleManager_Display.loadError = false; --optional for !		
		Mission00.onStartMission = Utils.appendedFunction(Mission00.onStartMission, VehicleManager_Display.onStartMission);		
	end;
end;

function VehicleManager_Display:onStartMission()
	if VehicleManager_Display:getDetiServer() then return;end;	
	g_currentMission.hlUtils.modLoad("FS25_VehicleManagerDisplay");	
	VehicleManager_Display.vehicleInspector = g_currentMission.hlUtils.modLoaded["FS25_VehicleInspector"] ~= nil;	
	VehicleManager_Display.autoDrive.loaded = g_modIsLoaded["FS25_AutoDrive"] and _G["FS25_AutoDrive"] ~= nil;	
	vmGroups:setGlobalFunctions();
	VehicleManager_Display.lastPlayerFarmId = g_currentMission.hlUtils.getPlayerFarmId();
	VehicleManager_Display.firstPlayerControlled = false; --for ad hud
	--VehicleManager_Display.values = {showVehicleInfos=false}; --group infos !!
	--PlayerHUDUpdater.showVehicleInfo = Utils.appendedFunction(PlayerHUDUpdater.showVehicleInfo, VehicleManager_DisplaySetGet.showVehicleInfo);
	VehicleManager_Display.values = {viMarkersColors="mangenta",ghostGroupsVehicles=0,vehicleSchema={}};
	if g_currentMission.hlHudSystem ~= nil and g_currentMission.hlHudSystem.hlHud ~= nil and g_currentMission.hlHudSystem.hlHud.generate ~= nil then --check is HL Hud System ready !
		--FSBaseMission.saveSavegame = Utils.appendedFunction(FSBaseMission.saveSavegame, VehicleManager_Display.saveSavegame);
		ItemSystem.save = Utils.prependedFunction(ItemSystem.save, VehicleManager_Display.saveSavegame); --patch 1.5.0.1
		vmGroups:setGetMapData();
		g_currentMission.hlUtils.loadLanguage( {modTitle=tostring(VehicleManager_Display.metadata.title), class=VehicleManager_Display.modName, modDir=VehicleManager_Display.modDir.. "scripte_vmdisplay/", xmlDir="FS25_VehicleManager", xmlVersion=VehicleManager_Display.metadata.languageVersion} );
		vmGroupsXml:loadXml();
		print("#Info: ".. tostring(VehicleManager_Display.metadata.title).. " generate Hud --> for HL Hud System (".. tostring(g_currentMission.hlHudSystem.metadata.version).. ")")
		VehicleManager_Display:loadSource(2);
		if VehicleManager_Display_XmlHud:loadHud("VehicleManager_Display_Hud") then
			VehicleManager_Display:loadSource(3);			
		else
			VehicleManager_Display.loadError = true; --optional for !			
			print("#WARNING: ".. tostring(VehicleManager_Display.metadata.title).. " CAN NOT GENERATE Hud ! Check/Search: ? Mod cause with integrated HL Hud System ? ")
		end;		
	else
		g_currentMission.hlUtils.modUnLoad("FS25_VehicleManagerDisplay");
		VehicleManager_Display.loadError = true; --optional for !		
		print("#WARNING: ".. tostring(VehicleManager_Display.metadata.title).. " CAN NOT GENERATE Hud/Pda/Box ! MISSING --> HL Hud System ! Check/Search: ? Corrupt Mod with integrated HL Hud System ? ")
	end;	
end;

function VehicleManager_Display:delete()
	
end;

function VehicleManager_Display:deleteMap()
	--if g_currentMission == nil then return;end;
	--if VehicleManager_Display:getDetiServer() then return;end;
	--vmGroupsXml:saveConfig()	
end;

function VehicleManager_Display:mouseEvent(posX, posY, isDown, isUp, button)
	
end;	

function VehicleManager_Display:keyEvent(unicode, sym, modifier, isDown)
	
end;

function VehicleManager_Display:update(dt)	
	if VehicleManager_Display:getDetiServer() then return;end;	
	
	--if VehicleManager_Display.lastPlayerFarmId ~= nil and VehicleManager_Display.lastPlayerFarmId ~= g_currentMission.hlUtils.getPlayerFarmId() then VehicleManager_Display.lastPlayerFarmId = g_currentMission.hlUtils.getPlayerFarmId();VehicleManager_DisplaySetGet:resetAllData();end;
end;

function VehicleManager_Display:draw()
	if VehicleManager_Display:getDetiServer() or g_currentMission.hlUtils:getIngameMap() or g_currentMission.hlUtils:getFullSize(true,true) then return;end;
	--respect settings for other mods (not every mod) that's why
	setTextAlignment(0);
	setTextLineBounds(0, 0);
	setTextWrapWidth(0);
	setTextColor(1, 1, 1, 1);
	setTextBold(false);
	--respect settings for other mods
	
	if not VehicleManager_Display.loadError then VehicleManager_Display_Draw:setOtherArea("vmDisplayName_");end;
		
	if #VehicleManager_Display.testString > 0 then
		setTextBold(true);		
		for a=1, #VehicleManager_Display.testString do
			local posY = 0.25-(a/100);
			renderText(0.5, posY, 0.010, "-S ".. tostring(a).. "- ".. tostring(VehicleManager_Display.testString[a]));
		end;
	end;
	
	--respect settings for other mods
	setTextAlignment(0);
	setTextLineBounds(0, 0);
	setTextWrapWidth(0);
	setTextColor(1, 1, 1, 1);
	setTextBold(false);
	--respect settings for other mods
end;
addModEventListener(VehicleManager_Display);

function VehicleManager_Display:getDetiServer()	
	return g_server ~= nil and g_client ~= nil and g_dedicatedServer ~= nil;	
end;

function VehicleManager_Display:getHostOrSp()	
	return (g_server ~= nil and g_client ~= nil and g_dedicatedServer == nil) or (not g_currentMission.missionDynamicInfo.isMultiplayer); --only mp host player or single player
end;

function VehicleManager_Display.saveSavegame() --Save by LS22
	vmGroupsXml:saveBySavegame();
end;

function VehicleManager_Display:loadSource(int)
	if int == 1 then
		source(VehicleManager_Display.modDir.."scripte_vmdisplay/VehicleManager_DisplaySetGet.lua");		
	elseif int == 2 then
		source(VehicleManager_Display.modDir.."scripte_vmdisplay/mouseKeyEvents/VehicleManager_Display_MouseKeyEventsHud.lua");
		source(VehicleManager_Display.modDir.."scripte_vmdisplay/draw/VehicleManager_Display_DrawHud.lua");
		source(VehicleManager_Display.modDir.."scripte_vmdisplay/xml/VehicleManager_Display_XmlHud.lua");
		source(VehicleManager_Display.modDir.."scripte_vmdisplay/mouseKeyEvents/VehicleManager_Display_MouseKeyEventsBox.lua");
		source(VehicleManager_Display.modDir.."scripte_vmdisplay/draw/VehicleManager_Display_DrawBox.lua");
		source(VehicleManager_Display.modDir.."scripte_vmdisplay/xml/VehicleManager_Display_XmlBox.lua");
		source(VehicleManager_Display.modDir.."scripte_vmdisplay/vmGuiBoxSetGet.lua");
		source(VehicleManager_Display.modDir.."scripte_vmdisplay/mouseKeyEvents/VehicleManager_Display_MouseKeyEventsGuiBox.lua");
	elseif int == 3 then
		source(VehicleManager_Display.modDir.."scripte_vmdisplay/mouseKeyEvents/VehicleManager_Display_MouseKeyEvents.lua");
		source(VehicleManager_Display.modDir.."scripte_vmdisplay/draw/VehicleManager_Display_Draw.lua");
	elseif int == 4 then
		
	end;
end;

function generateFolders()
	createFolder(getUserProfileAppPath().. "modSettings/");
	createFolder(getUserProfileAppPath().. "modSettings/HL/");
	createFolder(getUserProfileAppPath().. "modSettings/HL/FS25_VehicleManagerDisplay/");
	createFolder(getUserProfileAppPath().. "modSettings/HL/FS25_VehicleManagerDisplay/languages/");
	createFolder(getUserProfileAppPath().. "modSettings/HL/FS25_VehicleManagerDisplay/profile/");	
end;