vmControl = {};

vmControl.values = {typId={}, onLoadNew={}, gostVehicles={}, xmlLoaded=false, searchGhostVehicles=80000, firstLoadTimer=true, timer=0, viewTypId=false};

function vmControl:getTypId(change)	
	function getTypId()
		local randomNr = math.random (1, 9);		
		local typIdDate_D = string.format("%0.2i", Utils.getNoNil(getDate("%d"), tostring(randomNr)));		
		local typIdDate_M = string.format("%0.2i", Utils.getNoNil(getDate("%m"), tostring(randomNr))); 
		local typIdDate_Y = string.format("%0.2i", Utils.getNoNil(getDate("%y"), tostring(randomNr))); 
		local typIdTimeH = string.format("%0.2i", Utils.getNoNil(getDate("%I"), tostring(randomNr)));
		--if tonumber(typIdTimeH) <= 0 then typIdTimeH = "24";else typIdTimeH = string.format("%0.2i", typIdTimeH);end;		
		local typIdTimeM = Utils.getNoNil(getDate("%M"), tostring(randomNr));
		if tonumber(typIdTimeM) <= 0 then typIdTimeM = "60";else typIdTimeM = string.format("%0.2i", typIdTimeM);end;
		local typIdTimeS = Utils.getNoNil(getDate("%S"), tostring(randomNr));
		if tonumber(typIdTimeS) <= 0 then typIdTimeS = "60";else typIdTimeS = string.format("%0.2i", typIdTimeS);end;
		local typIdString = typIdDate_D.. typIdDate_M.. typIdDate_Y.. typIdTimeH.. typIdTimeM.. typIdTimeS.. tostring(randomNr);		
		return tonumber(typIdString);
	end;
	local typId = getTypId();	
	if change ~= nil and change and vmControl.values.typId[tonumber(typId)] ~= nil then
		for c=1, 5 do --5x
			typId = getTypId();
			if vmControl.values.typId[tonumber(typId)] == nil then break;end;
		end;
	end;	
	vmControl:setTypId(tonumber(typId));	
	return tonumber(typId);
end;

function vmControl:setTypId(typId)
	if vmControl.values.typId[typId] == nil then
		vmControl.values.typId[typId] = {};
	end;
end;

function vmControl:setNodeByTypId(typId, node)
	if vmControl.values.typId[typId] == nil then vmControl.values.typId[typId] = {};end;
	vmControl.values.typId[typId].node = node;
end;

function vmControl:setDriverNameByTypId(typId, driverName)
	if vmControl.values.typId[typId] ~= nil then
		vmControl.values.typId[typId].driverName = driverName or nil;
	end;
end;

function vmControl:delTypId(typId)
	vmControl.values.typId[typId] = nil;
end;

function vmControl:getNodeByTypId(typId)
	if vmControl.values.typId[typId] ~= nil and vmControl.values.typId[typId].node ~= nil and vmControl.values.typId[typId].node > 0 then return vmControl.values.typId[typId].node;end;
	return 0;
end;

function vmControl:getDriverNameByTypId(typId)
	if vmControl.values.typId[typId] ~= nil and vmControl.values.typId[typId].driverName ~= nil and vmControl.values.typId[typId].driverName:len() > 1 then return vmControl.values.typId[typId].driverName;end;
	return nil;
end;

function vmControl:searchNodeByTypId(typId) --change
	if g_currentMission.nodeToObject ~= nil then
		for node, object in pairs(g_currentMission.nodeToObject) do
			if object ~= nil and object:isa(Vehicle) and object.vmControl ~= nil then
				if object.vmControl.typId == typId then return node;end;
			end;
		end;
	end;
	return 0;
end;

function vmControl:getTypIdByNode(node)
	for typId, value in pairs(vmControl.values.typId) do
		if typId ~= nil and typId > 0 then
			local vehicleNode = value.node;
			if vehicleNode ~= nil and vehicleNode == node then return typId;end;
		end;
	end;	
	return 0;
end;

function vmControl:isGhostVehicle(typId, vehicleNode)
	local vehicle = nil;	
	if vehicleNode ~= nil then
		vehicle = g_currentMission.nodeToObject[vehicleNode];
	elseif typId ~= nil then
		vehicleNode = vmControl:getNodeByTypId(typId);
		vehicle = g_currentMission.nodeToObject[vehicleNode];
	end;
	return vehicle == nil;
end;

function vmControl:searchGhostVehicles()	
	local foundGhostVehicles = false;
	for typId, value in pairs(vmControl.values.typId) do
		if typId ~= nil and typId > 0 then
			local vehicleNode = value.node;
			if vehicleNode ~= nil then
				local vehicle = g_currentMission.nodeToObject[vehicleNode];
				if vehicle == nil then vehicle = g_currentMission.nodeToObject[vmControl:searchNodeByTypId(typId)];end; --change
				if vehicle ~= nil then 
					vmControl.values.typId[typId].node = vehicle.rootNode;
				elseif vehicle == nil then 
					vmControl:delTypId(typId);					
					vmGroups:delVehicleAtGroups(typId);
					foundGhostVehicles = true;
				end;
			end;
		end;	
	end;	
	for typId, value in pairs(vmGroups.values.markedVehicles) do
		local vehicleNode = value.node;
		if vehicleNode ~= nil then
			local vehicle = g_currentMission.nodeToObject[vehicleNode];
			if vehicle == nil then vehicle = g_currentMission.nodeToObject[vmControl:searchNodeByTypId(typId)];end; --change
			if vehicle ~= nil then 
				vmGroups.values.markedVehicles[typId].node = vehicle.rootNode;
			elseif vehicle == nil then 
				vmGroups.values.markedVehicles[typId] = nil;
				foundGhostVehicles = true;
			end;
		end;
	end;
	--if foundGhostVehicles then vmGroupsXml:saveProfile();end;
end;

function vmControl.initSpecialization()

    local schemaSavegame = Vehicle.xmlSchemaSavegame   
    schemaSavegame:register(XMLValueType.STRING, "vehicles.vehicle(?).FS25_VehicleManager.vmControl#typId", "Current TypeId index for Vehicle");
	--schemaSavegame:register(XMLValueType.INT, "vehicles.vehicle(?).FS25_VehicleManager.vmControl#autoProgress", "Current Automatic Progresses for Vehicle (needs AD)");
	--schemaSavegame:register(XMLValueType.INT, "vehicles.vehicle(?).FS25_VehicleManager.vmControl#groups", "Current Group(s) for VehicleManager");
end;

function vmControl.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Enterable, specializations) and SpecializationUtil.hasSpecialization(Motorized, specializations) and SpecializationUtil.hasSpecialization(Drivable, specializations);
end;

function vmControl.registerFunctions(vehicleType)
    SpecializationUtil.registerFunction(vehicleType, "setVmControlKey", vmControl.setVmControlKey)    
    --SpecializationUtil.registerFunction(vehicleType, "MPEvent", vmControl.MPEvent)
end

function vmControl.registerEventListeners(vehicleType)
	local functionNames = {
		"onLoad"
		,"onPostLoad"
		,"onDelete"
		,"saveToXMLFile"		
		,"onReadStream"
		,"onWriteStream"
		--,"onUpdate"
		--,"onUpdateTick"
		,"onDraw"
	};
	
	for i, v in ipairs(functionNames) do
		SpecializationUtil.registerEventListener(vehicleType, v, vmControl);
	end;
end;

function vmControl:onLoad(savegame)	
	if g_dedicatedServer == nil then VehicleManager_DisplaySetGet:loadVehicleOverlay(self);end;
	self.setVmControlKey = vmControl.setVmControlKey;	
	if self.vmControl == nil then
		self.vmControl = {typId=0, groups={}, autoProgress={} };
		self.vmControl.typId = vmControl:getTypId(true);
		vmControl:setNodeByTypId(self.vmControl.typId, self.rootNode);		
	elseif self.vmControl.typId == 0 then
		self.vmControl.typId = vmControl:getTypId(true);
		vmControl:setNodeByTypId(self.vmControl.typId, self.rootNode);	
	end;	
end;

function vmControl:onPostLoad(savegame)	
	if savegame ~= nil then
		if g_dedicatedServer == nil then VehicleManager_DisplaySetGet:loadVehicleOverlay(self);end;
		local typId = savegame.xmlFile:getValue(savegame.key..".FS25_VehicleManager.vmControl#typId")
		if typId ~= nil then
			if self.vmControl == nil then 
				self.vmControl = {typId=tonumber(typId), groups={}, autoProgress={} };				
			else
				self.vmControl.typId = tonumber(typId);
			end;
			vmControl:setNodeByTypId(tonumber(typId), self.rootNode);			
		end;		
	end;	
end;

function vmControl:onDelete()	
	if self.isClient and self.vmControl ~= nil and self.vmControl.typId ~= nil and self.vmControl.typId > 0 then		
		if self.isDeleted then
			--print("Delete Vehicle")			
		else
			--print("loadingStep: ".. tostring(self.loadingStep));
			--local typIdNode = vmControl:getNodeByTypId(self.vmControl.typId);
			--if typIdNode > 0 and self.rootNode ~= typIdNode then
			--	if self.propertyState == Vehicle.PROPERTY_STATE_SHOP_CONFIG then
			--		print("Node nicht identisch aber noch im Shop Config: ")
			--	else
			--		print("Node nicht identisch: ".. tostring(self.loadingStep))
			--	end;			
			--elseif self.propertyState == Vehicle.PROPERTY_STATE_SHOP_CONFIG then
			--	print("Node ist gleich aber noch im Shop Config")
			--end;
		end;		
	end;
end;

function vmControl:saveToXMLFile(xmlFile, key)
	
	xmlFile:setValue(key.."#typId", tostring(self.vmControl.typId));

end;

function vmControl:onReadStream(streamId, connection)
    if connection:getIsServer() then
        local typId = streamReadString(streamId)
		self.vmControl.typId = tonumber(typId);
		vmControl:setTypId(tonumber(typId));
		vmControl:setNodeByTypId(tonumber(typId), self.rootNode);			
    end;
end;

function vmControl:onWriteStream(streamId, connection)
    if not connection:getIsServer() then
        local typId = self.vmControl.typId
		streamWriteString(streamId, tostring(typId));		
    end;
end;

function vmControl:onUpdate(dt)
	
end;

function vmControl:onUpdateTick(dt)

end;

function vmControl:onDraw()

	if self.isClient and self.spec_enterable.isEntered and self.vmControl ~= nil and self.vmControl.typId ~= nil and vmControl.values.viewTypId then
		local speedMeter = g_currentMission.inGameMenu.hud.speedMeter;
		if speedMeter ~= nil then
			local baseX, baseY = speedMeter.gaugeBackgroundElement:getPosition();
			local centerPosX = baseX + speedMeter.gaugeBackgroundElement:getWidth() * 0.5;
			local baseWidth = speedMeter:getWidth();
			local baseHeight = speedMeter:getHeight();
			local size = speedMeter.cruiseControlTextSize * 0.75;
			local text = tostring(self.vmControl.typId).. "/".. tostring(self.rootNode);
			setTextBold(true);
			setTextAlignment(RenderText.ALIGN_CENTER);
			renderText(baseX+(baseWidth/2.1), baseY+baseHeight-0.008, size, "VM: ".. tostring(text));
			setTextColor(1,1,1,1);
			setTextAlignment(0);
			setTextBold(false);
		end;
	end;	

end;

function vmControl:setVmControlKey(key)

	


end;

