vmGroupsXml = {};

function vmGroupsXml:saveBySavegame()	
	vmGroupsXml:saveConfig(vmGroupsXml:getConfigFile());
	vmGroupsXml:saveProfil();
end;

function vmGroupsXml:canSaveBySavegame()	
	if VehicleManager_Display:getHostOrSp() then return g_currentMission.missionInfo.savegameDirectory ~= nil;end;
	return true;
end;

function vmGroupsXml:loadXml()
	local file = vmGroupsXml:getConfigFile();	
	if not fileExists(file) then
		print("#Info: ".. tostring(VehicleManager_Display.metadata.title).. " *GroupManager* generate config file ".. tostring(file))
		vmGroupsXml:saveConfig(file, true);
	else
		print("#Info: ".. tostring(VehicleManager_Display.metadata.title).. " *GroupManager* load config file ".. tostring(file))
		vmGroupsXml:loadConfig(file);
	end;	
end;

function vmGroupsXml:loadConfig(file)
	local Xml = loadXMLFile("vehicleManager_XML", file, "vehicleManager");
	local groupNameTag = ("vehicleManager.global(%d)"):format(0);
	local activeProfil = "vm_Group_Profil";
	--if getXMLString(Xml, groupNameTag.."#activeProfil") ~= nil then activeProfil = getXMLString(Xml, groupNameTag.."#activeProfil");end;		
	if getXMLBool(Xml, groupNameTag.."#viewTypId") ~= nil then vmControl.values.viewTypId = getXMLBool(Xml, groupNameTag.."#viewTypId");end;		
	--if not VehicleManager_Display:getHostOrSp() then vmGroupsXml:searchProfile();end;
	vmGroupsXml:searchVorlageProfil();
	vmGroupsXml:loadProfilFile();
	delete(Xml);
end;

function vmGroupsXml:saveConfig(file, newXml)
	if file == nil then print("#Warning: ".. tostring(VehicleManager_Display.metadata.title).. " *GroupManager* can not save vehicleManager.xml");return;end;	
	local Xml = createXMLFile("VehicleManager_XML", file, "vehicleManager");
	local groupNameTag = ("vehicleManager.global(%d)"):format(0);	
	--local activeProfil = vmGroups:getActiveProfil();
	--setXMLString(Xml, groupNameTag.."#activeProfil", tostring(activeProfil));
	setXMLBool(Xml, groupNameTag.."#viewTypId", vmControl.values.viewTypId);	
	saveXMLFile(Xml);
	delete(Xml);
	--if newXml ~= nil and newXml then vmGroupsXml:saveProfil(activeProfil);end;
end;

function vmGroupsXml:getConfigFile()
	local file = VehicleManager_Display.settingsDir.. "vehicleManager.xml";
	
	--if VehicleManager_Display:getHostOrSp() then --load by savegame
	--	local path = g_currentMission.missionInfo.savegameDirectory;
	--	if path == nil then
	--		file = getUserProfileAppPath() .. "savegame" .. g_currentMission.missionInfo.savegameIndex.. "/vehicleManager.xml";
	--	else
	--		file = path.. "/vehicleManager.xml";
	--	end;
	--end;
	return file;
end;

function vmGroupsXml:getProfilFile(profilName)
	if profilName == nil then profilName = vmGroups:getActiveProfil();end;
	local file = VehicleManager_Display.settingsDir.. "profile/".. profilName.. ".xml";
	if VehicleManager_Display:getHostOrSp() then --load by savegame
		local path = g_currentMission.missionInfo.savegameDirectory;
		if path == nil then
			file = getUserProfileAppPath() .. "savegame" .. g_currentMission.missionInfo.savegameIndex.. "/".. profilName.. ".xml";
		else
			file = path.. "/".. profilName.. ".xml";
		end;
	end;
	return file;
end;

function vmGroupsXml:searchProfile(profilName, reload) --client MP old Profile
	--print("#Info: ".. tostring(VehicleManager_Display.metadata.title).. " *GroupManager* load group profil files")
	if profilName == nil then profilName = vmGroups:getActiveProfil();end;	
	local files = Files.new(VehicleManager_Display.settingsDir.. "profile/");
	if reload ~= nil and reload then vmGroups.values.profile = {["vm_Group_Profil"]={active=false, displayName="vm_Group_Profil", isVorlage=false}};end;
	for _, v in pairs(files.files) do		
		if not v.isDirectory then			
			local newFile = string.find(v.filename, "_ID_") or false;			
			local fileName = string.gsub(v.filename, ".xml", "");
			local displayName = fileName;
			if newFile then local splitText = g_currentMission.hlUtils.stringSplit(fileName, "_ID_");displayName = splitText[2];end;			
			vmGroups.values.profile[fileName] = {active=v.filename == profilName.. ".xml", newFile=newFile, displayName=displayName, isVorlage=false};			
		end;
	end;
end;

function vmGroupsXml:searchVorlageProfil() --client MP	
	local file = VehicleManager_Display.settingsDir.. "vm_Vorlage_Profil.xml";
	if fileExists(file) then		
		vmGroups.values.hasVorlage = true;
	end;
end;

function vmGroupsXml:loadProfilFile(profilName)
	if profilName == nil then profilName = vmGroups:getActiveProfil();end;
	print("#Info: ".. tostring(VehicleManager_Display.metadata.title).. " *GroupManager* load group profil -".. tostring(profilName).. "-")
	vmGroups:setActiveProfil(profilName);
	local file = vmGroupsXml:getProfilFile(profilName);
	if not fileExists(file) then
		vmGroupsXml:saveProfil(profilName, file);
	else
		vmGroupsXml:loadProfil(profilName, file);
	end;
end;

function vmGroupsXml:loadProfil(profilName, file, copyPaste)
	if profilName == nil then profilName = vmGroups:getActiveProfil();end;
	if file == nil and copyPaste == nil then file = vmGroupsXml:getProfilFile(profilName);end;	
	--mp lua error -vmGroupsXml.lua:119/vmGroupsXml.lua:206 copypaste and load profil ?
	if not fileExists(file) then
		if copyPaste ~= nil and copyPaste then g_currentMission.hlHudSystem.showInfoBox( {"Not found a Profil", 2500, g_currentMission.hlUtils.getColor("orangeRed", true)} );end;
		return;
	end;
	--
	local groupProfilXml = loadXMLFile("VehicleManager_XML", file, "vehicleManager");
	local intG = 0;		
	vmGroups.values.groups = {}; --reload profil	
	while true do
		local groupNameTag = ("vehicleManager.group(%d)"):format(intG);
		if groupNameTag == nil or getXMLString(groupProfilXml, groupNameTag.."#name") == nil then break;end;
		local groupsName = getXMLString(groupProfilXml, groupNameTag.."#name");
		local viewOpen = false;
		if getXMLBool(groupProfilXml, groupNameTag.."#viewOpen") ~= nil then viewOpen = getXMLBool(groupProfilXml, groupNameTag.."#viewOpen");end;
		local viewTyp = 1;
		if getXMLInt(groupProfilXml, groupNameTag.."#viewTyp") ~= nil then viewTyp = getXMLInt(groupProfilXml, groupNameTag.."#viewTyp");end;
		if not VehicleManager_Display.vehicleInspector and viewTyp == 2 then viewTyp = 1;end;
		vmGroups.values.groups[#vmGroups.values.groups+1] = {name=groupsName, viewOpen=viewOpen, viewTyp=viewTyp, maxViewTyp=2, typId={}, uGroups={}, marker={text="",color={}}};		
		local markerText = "";
		if getXMLString(groupProfilXml, groupNameTag.. "#markerText") ~= nil then markerText = getXMLString(groupProfilXml, groupNameTag.. "#markerText");end;
		if markerText:len() > 0 and markerText:len() <= 2 then vmGroups.values.groups[#vmGroups.values.groups].marker.text = markerText;end;		
		local intV = 0;
		while true do
			local tempGroupNameTag = (groupNameTag.. ".vehicle(%d)"):format(intV);
			if tempGroupNameTag == nil or getXMLString(groupProfilXml, tempGroupNameTag.. "#typId") == nil then break;end;
			local typId = getXMLString(groupProfilXml, tempGroupNameTag.. "#typId");
			local storeName = "Unknown Name";			
			local driverName = nil;
			if getXMLString(groupProfilXml, tempGroupNameTag.. "#driverName") ~= nil then driverName = getXMLString(groupProfilXml, tempGroupNameTag.. "#driverName");end;
			local vehicleNode = vmControl:getNodeByTypId(tonumber(typId));
			vmGroups.values.groups[#vmGroups.values.groups].typId[tonumber(typId)] = {storeName=storeName, driverName=driverName, node=vehicleNode};
			if driverName ~= nil and vehicleNode ~= nil and vehicleNode > 0 then
				local vehicle = g_currentMission.nodeToObject[vehicleNode];
				if vehicle ~= nil and vehicle.vmControl ~= nil then vehicle.vmControl.driverName = driverName;vmControl:setDriverNameByTypId(vehicle.vmControl.typId, driverName);end;
			end;
			if vehicleNode == nil or vehicleNode == 0 then vmGroups.values.ghostGroupsVehicles = vmGroups.values.ghostGroupsVehicles+1;end;
			intV = intV+1;
		end;
		intG = intG+1;
		--uGroups--		
		local intUG = 0;
		while true do
			local uGroupNameTag = (groupNameTag.. ".uGroup(%d)"):format(intUG);
			if uGroupNameTag == nil or getXMLString(groupProfilXml, uGroupNameTag.."#name") == nil then break;end;
			local uGroupsName = getXMLString(groupProfilXml, uGroupNameTag.."#name");
			viewOpen = false;
			if getXMLBool(groupProfilXml, uGroupNameTag.."#viewOpen") ~= nil then viewOpen = getXMLBool(groupProfilXml, uGroupNameTag.."#viewOpen");end;
			viewTyp = 1;
			if getXMLInt(groupProfilXml, uGroupNameTag.."#viewTyp") ~= nil then viewTyp = getXMLInt(groupProfilXml, uGroupNameTag.."#viewTyp");end;
			if not VehicleManager_Display.vehicleInspector and viewTyp == 2 then viewTyp = 1;end;
			vmGroups.values.groups[#vmGroups.values.groups].uGroups[#vmGroups.values.groups[#vmGroups.values.groups].uGroups+1] = {name=uGroupsName, viewOpen=viewOpen, viewTyp=viewTyp, maxViewTyp=2, typId={}, marker={text="",color={}}};			
			markerText = "";
			if getXMLString(groupProfilXml, uGroupNameTag.. "#markerText") ~= nil then markerText = getXMLString(groupProfilXml, uGroupNameTag.. "#markerText");end;
			if markerText:len() > 0 and markerText:len() <= 2 then vmGroups.values.groups[#vmGroups.values.groups].uGroups[#vmGroups.values.groups[#vmGroups.values.groups].uGroups].marker.text = markerText;end;		
			local intUV = 0;
			while true do
				local tempUgroupNameTag = (uGroupNameTag.. ".vehicle(%d)"):format(intUV);
				if tempUgroupNameTag == nil or getXMLString(groupProfilXml, tempUgroupNameTag.. "#typId") == nil then break;end;
				local uTypId = getXMLString(groupProfilXml, tempUgroupNameTag.. "#typId");
				local storeName = "Unknown Name";								
				local driverName = nil;
				if getXMLString(groupProfilXml, tempUgroupNameTag.. "#driverName") ~= nil then driverName = getXMLString(groupProfilXml, tempUgroupNameTag.. "#driverName");end;
				local vehicleNode = vmControl:getNodeByTypId(tonumber(uTypId));
				vmGroups.values.groups[#vmGroups.values.groups].uGroups[#vmGroups.values.groups[#vmGroups.values.groups].uGroups].typId[tonumber(uTypId)] = {storeName=storeName, driverName=driverName, node=vehicleNode};
				if driverName ~= nil and vehicleNode ~= nil and vehicleNode > 0 then
					local vehicle = g_currentMission.nodeToObject[vehicleNode];
					if vehicle ~= nil and vehicle.vmControl ~= nil then vehicle.vmControl.driverName = driverName;vmControl:setDriverNameByTypId(vehicle.vmControl.typId, driverName);end;
				end;
				if vehicleNode == nil or vehicleNode == 0 then vmGroups.values.ghostGroupsVehicles = vmGroups.values.ghostGroupsVehicles+1;end;
				intUV = intUV+1;
			end;
			intUG = intUG+1		
		end;
		--uGroups--
	end;
	--markedVehicles by VehicleInspector--		
	if VehicleManager_Display.vehicleInspector then
		vmGroups.values.markedVehicles = {}; --reload profil
		local int = 0;
		groupNameTag = ("vehicleManager.markedVehicles(%d)"):format(0);		
		while true do
			local tempGroupNameTag = (groupNameTag.. ".vehicle(%d)"):format(int);
			if tempGroupNameTag == nil or getXMLString(groupProfilXml, tempGroupNameTag.. "#typId") == nil then break;end;
			local typId = getXMLString(groupProfilXml, tempGroupNameTag.. "#typId");
			local storeName = "Unknown Name";			
			local vehicleNode = vmControl:getNodeByTypId(tonumber(typId));
			if vehicleNode ~= nil then
				local vehicle = g_currentMission.nodeToObject[vehicleNode];
				if vehicle ~= nil then
					vmGroups.values.markedVehicles[tonumber(typId)] = {storeName=storeName, node=vehicleNode};						
					vehicle.viIsMarked = true;
				end;
			end;
			int = int+1;			
		end;
	end;
	--markedVehicles by VehicleInspector--	
	delete(groupProfilXml);
	if vmGroups.values.ghostGroupsVehicles > 0 then
		if g_currentMission.hlHudSystem.textTicker ~= nil and g_currentMission.hlHudSystem.textTicker.isOn then
			local msg = g_currentMission.hlHudSystem.textTicker:getMsgById("VehicleManager_GhostGroupsVehicles");
			if msg == nil then
				g_currentMission.hlHudSystem.textTicker:addMsg( {text=string.format(g_i18n:getText("profile_ghostGroupsVehicles"), vmGroups:getActiveProfil(true), vmGroups.values.ghostGroupsVehicles),color="orangeRed", id="VehicleManager_GhostGroupsVehicles",firstWait=700} );
			end;									
		end;
		vmGroups.values.ghostGroupsVehicles = 0;
	end;
end;

function vmGroupsXml:saveProfil(profilName, file, isVorlage)	
	if profilName == nil then profilName = vmGroups:getActiveProfil();end;
	if file == nil then file = vmGroupsXml:getProfilFile(profilName);end;
	local groupProfilXml = createXMLFile("vehicleManager_XML", file, "vehicleManager");		
	local groupNameTag = ("vehicleManager.data(%d)"):format(0);
	setXMLString(groupProfilXml, groupNameTag.."#mapName", vmGroups.values.mapName);
	setXMLBool(groupProfilXml, groupNameTag.."#modMap", vmGroups.values.isModMap);
	local date_D = string.format("%0.2i", Utils.getNoNil(getDate("%d"), 0));		
	local date_M = string.format("%0.2i", Utils.getNoNil(getDate("%m"), 0)); 
	local date_Y = string.format("%0.2i", Utils.getNoNil(getDate("%y"), 0)); 
	local lastSaveString = date_D.. date_M.. date_Y;
	setXMLInt(groupProfilXml, groupNameTag.."#lastSave", tonumber(lastSaveString));
	local foundData = false;
	if #vmGroups.values.groups > 0 then
		for group=1, #vmGroups.values.groups do
			groupNameTag = ("vehicleManager.group(%d)"):format(group-1);
			setXMLString(groupProfilXml, groupNameTag.."#name", vmGroups.values.groups[group].name);
			local viewOpen = vmGroups.values.groups[group].viewOpen;
			if isVorlage ~= nil and isVorlage then viewOpen = false;end;
			setXMLBool(groupProfilXml, groupNameTag.."#viewOpen", viewOpen);
			setXMLInt(groupProfilXml, groupNameTag.."#viewTyp", vmGroups.values.groups[group].viewTyp);			
			setXMLString(groupProfilXml, groupNameTag.."#markerText", vmGroups.values.groups[group].marker.text);			
			if isVorlage == nil or not isVorlage then
				local intV = 0;
				for typId, value in pairs(vmGroups.values.groups[group].typId) do			
					local tempGroupNameTag = (groupNameTag.. ".vehicle(%d)"):format(intV);
					setXMLString(groupProfilXml, tempGroupNameTag.."#typId", tostring(typId));					
					local driverName = vmControl:getDriverNameByTypId(typId);
					if driverName ~= nil and driverName:len() > 1 then
						setXMLString(groupProfilXml, tempGroupNameTag.."#driverName", tostring(driverName));
					end;
					--local vehicle = g_currentMission.nodeToObject[value.node];					
					--if vehicle ~= nil and vehicle.vmControl ~= nil and vehicle.vmControl.driverName ~= nil and vehicle.vmControl.driverName:len() > 1 then
					--	setXMLString(groupProfilXml, tempGroupNameTag.."#driverName", tostring(vehicle.vmControl.driverName));
					--end;				
					intV = intV+1;
				end;
			end;
			--uGroups--
			if #vmGroups.values.groups[group].uGroups > 0 then
				for uGroup=1, #vmGroups.values.groups[group].uGroups do
					local uGroupNameTag = (groupNameTag.. ".uGroup(%d)"):format(uGroup-1);
					setXMLString(groupProfilXml, uGroupNameTag.."#name", vmGroups.values.groups[group].uGroups[uGroup].name);
					viewOpen = vmGroups.values.groups[group].uGroups[uGroup].viewOpen;
					if isVorlage ~= nil and isVorlage then viewOpen = false;end;
					setXMLBool(groupProfilXml, uGroupNameTag.."#viewOpen", viewOpen);
					setXMLInt(groupProfilXml, uGroupNameTag.."#viewTyp", vmGroups.values.groups[group].uGroups[uGroup].viewTyp);
					setXMLString(groupProfilXml, uGroupNameTag.."#markerText", vmGroups.values.groups[group].uGroups[uGroup].marker.text);
					if isVorlage == nil or not isVorlage then
						local intUV = 0;
						for uTypId, uValue in pairs(vmGroups.values.groups[group].uGroups[uGroup].typId) do
							local tempUgroupNameTag = (uGroupNameTag.. ".vehicle(%d)"):format(intUV);
							setXMLString(groupProfilXml, tempUgroupNameTag.."#typId", tostring(uTypId));							
							local driverName = vmControl:getDriverNameByTypId(uTypId)
							if driverName ~= nil and driverName:len() > 1 then
								setXMLString(groupProfilXml, tempUgroupNameTag.."#driverName", tostring(driverName));
							end;
							
							--local vehicle = g_currentMission.nodeToObject[uValue.node];							
							--if vehicle ~= nil and vehicle.vmControl ~= nil and vehicle.vmControl.driverName ~= nil and vehicle.vmControl.driverName:len() > 1 then
							--	setXMLString(groupProfilXml, tempUgroupNameTag.."#driverName", tostring(vehicle.vmControl.driverName));
							--end;						
							intUV = intUV+1;
						end;
					end;
				end;
			end;
			--uGroups--
		end;
		foundData = true;
	end;
	--markedVehicles by VehicleInspector--
	if isVorlage == nil or not isVorlage then
		local int = 0;
		groupNameTag = ("vehicleManager.markedVehicles(%d)"):format(0);		
		for typId, value in pairs(vmGroups.values.markedVehicles) do		
			if typId == nil then break;end;
			local tempGroupNameTag = (groupNameTag.. ".vehicle(%d)"):format(int);
			setXMLString(groupProfilXml, tempGroupNameTag.."#typId", tostring(typId));			
			int = int+1;
			foundData = true;
		end;
	end;
	--markedVehicles by VehicleInspector--
	if foundData then saveXMLFile(groupProfilXml);end;
	delete(groupProfilXml);
end;

function vmGroupsXml.copyPasteProfil(yes, args)
	if yes then
		local profilName = args.profilName;
		local isVorlage = args.isVorlage or false;
		local activeProfil = vmGroups:getActiveProfil();
		local copyFile = VehicleManager_Display.settingsDir.. "profile/".. profilName.. ".xml";
		if isVorlage then copyFile = VehicleManager_Display.settingsDir.. profilName.. ".xml";end;
		vmGroupsXml:loadProfil(profilName, copyFile, true);	
		local pasteFile = VehicleManager_Display.settingsDir.. "profile/".. activeProfil.. ".xml";
		vmGroupsXml:saveProfil(activeProfil, pasteFile, isVorlage);
		--if not VehicleManager_Display:getHostOrSp() then vmGroupsXml:searchProfile(activeProfil, true);end;		
		local infoTxt=string.format(g_i18n:getText("profile_isCopyPaste"), profilName)
		g_currentMission.hlHudSystem.showInfoBox( {tostring(infoTxt), 2500, g_currentMission.hlUtils.getColor("ls25active", true)} );		
		g_currentMission.hlHudSystem.isSave = false; --global
	end;
end;

function vmGroupsXml:generateVorlageProfil()
	if #vmGroups.values.groups > 0 then
		local pasteFile = VehicleManager_Display.settingsDir.. "vm_Vorlage_Profil.xml";
		vmGroupsXml:saveProfil("vm_Vorlage_Profil", pasteFile, true);	
		--if not VehicleManager_Display:getHostOrSp() then vmGroupsXml:searchProfile(nil, true);end;
		vmGroupsXml:searchVorlageProfil();
		local infoTxt=g_i18n:getText("profile_vorlage_isGenerate");
		g_currentMission.hlHudSystem.showInfoBox( {tostring(infoTxt), 2500, g_currentMission.hlUtils.getColor("ls25active", true)} );				
	else
		local infoTxt=g_i18n:getText("profile_vorlage_notGenerate");		
		g_currentMission.hlHudSystem.showInfoBox( {tostring(infoTxt), 2500, g_currentMission.hlUtils.getColor("orangeRed", true)} );
	end;
end;