vmGuiBoxSetGet = {};

function vmGuiBoxSetGet:loadBox(box)	
	if box == nil then box = g_currentMission.hlHudSystem.hlBox:getData("VehicleManager_Display_Box");end;
	if box ~= nil then
		box.guiMenu = g_currentMission.hlHudSystem.hlGuiBox.generate( {name="VehicleManager_Display_GuiBox", title="VehicleManager Settings", onOverGuiBoxHudSystem=true} );
		box.guiMenu.screen.canBounds.on = true;
		box.guiMenu.onClick = VehicleManager_Display_MouseKeyEventsGuiBox.onClickArea;
		box.guiMenu.getLine = vmGuiBoxSetGet.getLines;
		local linesSequence = {"vehicleHeadline_","vehicleIcon_","vehicleName_","combiVehicleName_","folderLines_"};
		box.guiMenu.guiLines = {};
		for k,v in pairs(linesSequence) do
			table.insert(box.guiMenu.guiLines, v);
		end;
		if g_currentMission.hlUtils.modLoaded["FS25_VehicleInspector"] ~= nil then
			local viLinesSequence = {"viHeadline_","previewVehicles_"};
			for k,v in pairs(viLinesSequence) do
				table.insert(box.guiMenu.guiLines, v);
			end;
		end;
		vmGuiBoxSetGet:addLines(box);
	end;
end;

function vmGuiBoxSetGet:addLines(box)
	if box == nil then box = g_currentMission.hlHudSystem.hlBox:getData("VehicleManager_Display_Box");end;
	if box ~= nil then		
		for l=1, #box.guiMenu.guiLines do
			box.guiMenu:addLine( {} );
		end;
		box.guiMenu:resetDimension();
	end;
end;

function vmGuiBoxSetGet.getLines(args)	
	local box = args.box;
	if box == nil then  box = g_currentMission.hlHudSystem.hlBox:getData("VehicleManager_Display_Box");end;
	local line = args.line or 1;
	local overlayDefaultGroup = box.overlays.icons["defaultIcons"]["box"];
	local overlayDefaultByName = box.overlays.icons.byName["defaultIcons"]["box"];
	local values = box.ownTable;
	local text1 = "";
	local text2 = "-";
	local textColor = "white";
	local textOffColor = box.overlays.color.notActive;
	local iconColor = box.overlays.color.notActive;	
	local helpText = "";
	local helpText2 = "";	
	local stateOn = g_i18n:getText("ui_on");
	local stateOff = g_i18n:getText("ui_off");
	local state = false;
	local stateColor = nil;	
	local moreTxt = "";
	local infoTxt = "";
	---vehicles---
	if box.guiMenu.guiLines[line] == "vehicleHeadline_" then	
		text1 = g_i18n:getText("box_vehicleHeadline");	
		return {typ="headline", text={[1]={text=text1, color="ls25"}} };
	end;
	if box.guiMenu.guiLines[line] == "vehicleIcon_" then
		text1 = g_i18n:getText("box_viewVehicleIcons");
		infoTxt = stateOff;
		local icon = overlayDefaultGroup[overlayDefaultByName["tractor"]];
		if values.view["vehicleIcon"][1] > 1 then 
			iconColor = box.overlays.color.on;
			if values.view["vehicleIcon"][1] == 2 then infoTxt = "TypeDesc";elseif values.view["vehicleIcon"][1] == 3 then icon = overlayDefaultGroup[overlayDefaultByName["tractor_org"]];iconColor = {1,1,1,1};infoTxt = g_i18n:getText("input_TOGGLE_STORE");end;
			text1 = text1.. " (".. infoTxt.. ")";
		end;
		helpText = string.format(g_i18n:getText("box_viewVehicleIcons_help"), infoTxt);
		if values.view["vehicleIcon"][1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=icon, iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=text1,color=stateColor}, [2]={color=stateColor,state=values.view["vehicleIcon"][1] > 1}}, ownTable={"view","vehicleIcon"} };	
	end;
	if box.guiMenu.guiLines[line] == "vehicleName_" then
		text1 = g_i18n:getText("box_viewVehicleName");		
		local stateTxt = "";
		local driverText = "(VM)";
		if VehicleManager_Display.autoDrive then driverText = "(AD)";end;
		if values.view.vehicleName[1] == 2 then stateTxt = "\nView: VehicleName"elseif values.view.vehicleName[1] == 3 then stateTxt = "\nView: Full VehicleName";elseif values.view.vehicleName[1] == 4 then stateTxt = "\nView: TypName";elseif values.view.vehicleName[1] == 5 then stateTxt = "\nView: DriverName ".. driverText;end;
		helpText = string.format(g_i18n:getText("box_viewVehicleName_help"), driverText, driverText).. stateTxt;		
		if values.view["vehicleName"][1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["tractor"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=text1,color=stateColor}, [2]={color=stateColor,state=values.view["vehicleName"][1] > 1}}, ownTable={"view","vehicleName"} };
	end;
	if box.guiMenu.guiLines[line] == "combiVehicleName_" then
		text1 = g_i18n:getText("box_viewCombiVehicleName");
		infoTxt = stateOff;
		local stateTxt = "";
		local driverText = "(VM)";		
		state = values.view["combiVehicleName"][1] > 1;
		if VehicleManager_Display.autoDrive then driverText = "(AD)";end;		
		if values.view["vehicleName"][1] > 1 and values.view["combiVehicleName"][1] > 1 then			 
			if values.view.vehicleName[1] == 2 then infoTxt = "VehicleName"elseif values.view.vehicleName[1] == 3 then infoTxt = "Full VehicleName";elseif values.view.vehicleName[1] == 4 then infoTxt = "TypName";elseif values.view.vehicleName[1] == 5 then stateTxt = "DriverName ".. driverText;end;
			if values.view["combiVehicleName"][1] == 2 then infoTxt = "\nView: ".. infoTxt.. tostring(values.viewText.combiVehicleNameSeparator).. "DriverName ".. driverText;else infoTxt = "\nView: DriverName ".. driverText.. tostring(values.viewText.combiVehicleNameSeparator).. infoTxt;end;
		else
			infoTxt = "\nView: ".. infoTxt;
		end;		
		helpText = string.format(g_i18n:getText("box_viewCombiVehicleName_help"), driverText, driverText).. infoTxt;		
		if values.view["vehicleName"][1] == 1 or values.view["vehicleName"][1] == 5 or values.view["combiVehicleName"][1] == 1 then stateColor = textOffColor;state=false;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["tractor"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=text1,color=stateColor}, [2]={color=stateColor,state=state}}, ownTable={"view","combiVehicleName"} };		
	end;
	if box.guiMenu.guiLines[line] == "folderLines_" then
		text1 = g_i18n:getText("box_viewFolderLines");
		if values.view["folderLines"][1] > 1 then iconColor = box.overlays.color.text;else stateColor = textOffColor;end;
		helpText = g_i18n:getText("box_viewFolderLines_help");		
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["folderLine"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=text1,color=stateColor}, [2]={color=stateColor,state=values.view["folderLines"][1] > 1}}, ownTable={"view","folderLines"} };
	end;
	---vehicles---
	---optional optionen---
	if box.guiMenu.guiLines[line] == "viHeadline_" then
		text1 = g_i18n:getText("box_viHeadline");	
		return {typ="headline", text={[1]={text=text1, color="ls25"}} };
	end;
	if box.guiMenu.guiLines[line] == "previewVehicles_" then
		text1 = g_i18n:getText("box_previewVehicles");		
		if values.view["previewVehicles"][1] > 1 then iconColor = box.overlays.color.on;end;
		helpText = g_i18n:getText("box_previewVehicles_help");		
		if values.view["previewVehicles"][1] == 1 then stateColor = textOffColor;end;
		return {oneClick=true, icon=overlayDefaultGroup[overlayDefaultByName["previewVehicles"]], iconColor=iconColor, typ="boolean", helpText=helpText, text={[1]={text=text1,color=stateColor}, [2]={color=stateColor,state=values.view["previewVehicles"][1] > 1}}, ownTable={"view","previewVehicles"} };
	end;
	---optional optionen---
end;